/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.SingleAxisRotatingVisual;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorClientBehaviour;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorPackagePhysicsData;
import com.zurrtum.create.client.flywheel.api.instance.Instancer;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.TickableVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleTickableVisual;
import com.zurrtum.create.client.flywheel.lib.visual.util.SmartRecycler;
import com.zurrtum.create.client.foundation.render.SpecialModels;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBehaviour;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.logistics.box.PackageItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class ChainConveyorVisual
extends SingleAxisRotatingVisual<ChainConveyorBlockEntity>
implements SimpleDynamicVisual,
SimpleTickableVisual {
    private final List<TransformedInstance> guards = new ArrayList<TransformedInstance>();
    private final SmartRecycler<Identifier, TransformedInstance> boxes;
    private final SmartRecycler<Identifier, TransformedInstance> rigging;

    public ChainConveyorVisual(VisualizationContext context, ChainConveyorBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick, Models.partial(AllPartialModels.CHAIN_CONVEYOR_SHAFT));
        this.setupGuards();
        this.boxes = new SmartRecycler<Identifier, TransformedInstance>(key -> this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.PACKAGES.get(key))).createInstance());
        this.rigging = new SmartRecycler<Identifier, TransformedInstance>(key -> this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.PACKAGE_RIGGING.get(key))).createInstance());
    }

    @Override
    public void update(float pt) {
        super.update(pt);
        this.setupGuards();
    }

    @Override
    public void tick(TickableVisual.Context context) {
        ((ChainConveyorBehaviour)((ChainConveyorBlockEntity)this.blockEntity).getBehaviour(ChainConveyorClientBehaviour.TYPE)).tickBoxVisuals();
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        float partialTicks = ctx.partialTick();
        this.boxes.resetCount();
        this.rigging.resetCount();
        for (ChainConveyorPackage chainConveyorPackage : ((ChainConveyorBlockEntity)this.blockEntity).getLoopingPackages()) {
            this.setupBoxVisual((ChainConveyorBlockEntity)this.blockEntity, chainConveyorPackage, partialTicks);
        }
        for (Map.Entry entry : ((ChainConveyorBlockEntity)this.blockEntity).getTravellingPackages().entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                this.setupBoxVisual((ChainConveyorBlockEntity)this.blockEntity, box, partialTicks);
            }
        }
        this.boxes.discardExtra();
        this.rigging.discardExtra();
    }

    private void setupBoxVisual(ChainConveyorBlockEntity be, ChainConveyorPackage box, float partialTicks) {
        if (box.worldPosition == null) {
            return;
        }
        if (box.item == null || box.item.isEmpty()) {
            return;
        }
        ChainConveyorPackagePhysicsData physicsData = ChainConveyorClientBehaviour.physicsData(box, (LevelAccessor)be.getLevel());
        if (physicsData.prevPos == null) {
            return;
        }
        Vec3 position = physicsData.prevPos.lerp(physicsData.pos, (double)partialTicks);
        Vec3 targetPosition = physicsData.prevTargetPos.lerp(physicsData.targetPos, (double)partialTicks);
        float yaw = AngleHelper.angleLerp(partialTicks, physicsData.prevYaw, physicsData.yaw);
        Vec3 offset = new Vec3(targetPosition.x - (double)this.pos.getX(), targetPosition.y - (double)this.pos.getY(), targetPosition.z - (double)this.pos.getZ());
        BlockPos containingPos = BlockPos.containing((Position)position);
        Level level = be.getLevel();
        int light = LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, containingPos), (int)level.getBrightness(LightLayer.SKY, containingPos));
        if (physicsData.modelKey == null) {
            Identifier key = BuiltInRegistries.ITEM.getKey((Object)box.item.getItem());
            if (key == BuiltInRegistries.ITEM.getDefaultKey()) {
                return;
            }
            physicsData.modelKey = key;
        }
        TransformedInstance rigBuffer = this.rigging.get(physicsData.modelKey);
        TransformedInstance boxBuffer = this.boxes.get(physicsData.modelKey);
        Vec3 dangleDiff = VecHelper.rotate(targetPosition.add(0.0, 0.5, 0.0).subtract(position), -yaw, Direction.Axis.Y);
        float zRot = Mth.wrapDegrees((float)((float)Mth.atan2((double)(-dangleDiff.x), (double)dangleDiff.y) * 57.295776f)) / 2.0f;
        float xRot = Mth.wrapDegrees((float)((float)Mth.atan2((double)dangleDiff.z, (double)dangleDiff.y) * 57.295776f)) / 2.0f;
        zRot = Mth.clamp((float)zRot, (float)-25.0f, (float)25.0f);
        xRot = Mth.clamp((float)xRot, (float)-25.0f, (float)25.0f);
        for (TransformedInstance buf : new TransformedInstance[]{rigBuffer, boxBuffer}) {
            buf.setIdentityTransform();
            buf.translate((Vec3i)this.getVisualPosition());
            buf.translate(offset);
            buf.translate(0.0f, 0.625f, 0.0f);
            buf.rotateYDegrees(yaw);
            buf.rotateZDegrees(zRot);
            buf.rotateXDegrees(xRot);
            if (physicsData.flipped && buf == rigBuffer) {
                buf.rotateYDegrees(180.0f);
            }
            buf.uncenter();
            buf.translate(0.0f, -PackageItem.getHookDistance(box.item) + 0.4375f, 0.0f);
            buf.light(light);
            buf.setChanged();
        }
    }

    private void deleteGuards() {
        for (TransformedInstance guard : this.guards) {
            guard.delete();
        }
        this.guards.clear();
    }

    private void setupGuards() {
        this.deleteGuards();
        Instancer<TransformedInstance> wheelInstancer = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.chunkDiffuse(AllPartialModels.CHAIN_CONVEYOR_WHEEL));
        Instancer<TransformedInstance> guardInstancer = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.chunkDiffuse(AllPartialModels.CHAIN_CONVEYOR_GUARD));
        TransformedInstance wheel = wheelInstancer.createInstance();
        ((TransformedInstance)wheel.translate((Vec3i)this.getVisualPosition())).light(this.rotatingModel.light).setChanged();
        this.guards.add(wheel);
        for (BlockPos blockPos : ((ChainConveyorBlockEntity)this.blockEntity).connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = ((ChainConveyorBlockEntity)this.blockEntity).connectionStats.get(blockPos);
            if (stats == null) continue;
            Vec3 diff = stats.end().subtract(stats.start());
            double yaw = 57.2957763671875 * Mth.atan2((double)diff.x, (double)diff.z);
            TransformedInstance guard = guardInstancer.createInstance();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)guard.translate((Vec3i)this.getVisualPosition())).center()).rotateYDegrees((float)yaw)).uncenter()).light(this.rotatingModel.light).setChanged();
            this.guards.add(guard);
        }
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        for (TransformedInstance guard : this.guards) {
            this.relight(guard);
        }
    }

    @Override
    protected void _delete() {
        super._delete();
        this.deleteGuards();
        this.boxes.delete();
        this.rigging.delete();
    }
}

