/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.crafter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.crafter.RecipeGridHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class MechanicalCrafterRenderer
implements BlockEntityRenderer<MechanicalCrafterBlockEntity, MechanicalCrafterRenderState> {
    protected final ItemModelResolver itemModelManager;

    public MechanicalCrafterRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public MechanicalCrafterRenderState createRenderState() {
        return new MechanicalCrafterRenderState();
    }

    public void extractRenderState(MechanicalCrafterBlockEntity be, MechanicalCrafterRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        Direction targetDirection;
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        Level world = be.getLevel();
        MechanicalCrafterBlockEntity.Phase phase = be.phase;
        state.item = MechanicalCrafterRenderer.createItemState(this.itemModelManager, be, world, state.blockState, phase, tickProgress);
        Direction facing = (Direction)state.blockState.getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        float yRot = AngleHelper.horizontalAngle(facing);
        if (state.item != null) {
            Vec3 vec = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i()).scale(0.58).add(0.5, 0.5, 0.5);
            if (phase == MechanicalCrafterBlockEntity.Phase.EXPORTING) {
                targetDirection = MechanicalCrafterBlock.getTargetDirection(state.blockState);
                float progress = Mth.clamp((float)(((float)(1000 - be.countDown) + (float)be.getCountDownSpeed() * tickProgress) / 1000.0f), (float)0.0f, (float)1.0f);
                vec = vec.add(Vec3.atLowerCornerOf((Vec3i)targetDirection.getUnitVec3i()).scale((double)(progress * 0.75f)));
            }
            state.offset = vec;
            state.yRot = (float)Math.PI / 180 * yRot;
        }
        state.layer = RenderTypes.solidMovingBlock();
        if (!VisualizationManager.supportsVisualization((LevelAccessor)world)) {
            state.cogwheel = CogwheelRenderState.create(be, state.blockState, state.blockPos, facing);
        }
        float xRot = ((Pointing)((Object)state.blockState.getValue(MechanicalCrafterBlock.POINTING))).getXRotation();
        state.upRot = (float)((double)((yRot + 90.0f) / 180.0f) * Math.PI);
        state.eastRot = (float)((double)(xRot / 180.0f) * Math.PI);
        if ((be.covered || phase != MechanicalCrafterBlockEntity.Phase.IDLE) && phase != MechanicalCrafterBlockEntity.Phase.CRAFTING && phase != MechanicalCrafterBlockEntity.Phase.INSERTING) {
            state.lid = CachedBuffers.partial(AllPartialModels.MECHANICAL_CRAFTER_LID, state.blockState);
        }
        if (MechanicalCrafterBlock.isValidTarget(world, state.blockPos.relative(targetDirection = MechanicalCrafterBlock.getTargetDirection(state.blockState)), state.blockState)) {
            state.belt = CachedBuffers.partial(AllPartialModels.MECHANICAL_CRAFTER_BELT, state.blockState);
            state.frame = CachedBuffers.partial(AllPartialModels.MECHANICAL_CRAFTER_BELT_FRAME, state.blockState);
            if (phase == MechanicalCrafterBlockEntity.Phase.EXPORTING) {
                int textureIndex = (int)((float)be.getCountDownSpeed() / 128.0f * (float)AnimationTickHolder.getTicks());
                state.beltScroll = (float)(textureIndex % 4) / 4.0f;
            }
        } else {
            state.arrow = CachedBuffers.partial(AllPartialModels.MECHANICAL_CRAFTER_ARROW, state.blockState);
        }
    }

    public static MechanicalCrafterItemRenderState createItemState(ItemModelResolver itemModelManager, MechanicalCrafterBlockEntity be, Level world, BlockState blockState, MechanicalCrafterBlockEntity.Phase phase, float tickProgress) {
        if (phase == MechanicalCrafterBlockEntity.Phase.IDLE) {
            return MechanicalCrafterSingleItemRenderState.create(itemModelManager, be, world);
        }
        if (phase == MechanicalCrafterBlockEntity.Phase.CRAFTING) {
            return MechanicalCrafterCraftingItemRenderState.create(itemModelManager, be, world, tickProgress);
        }
        return MechanicalCrafterPhaseItemRenderState.create(itemModelManager, be, world, blockState, phase);
    }

    public void submit(MechanicalCrafterRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
        if (state.item != null) {
            matrices.translate(state.offset);
            matrices.scale(0.5f, 0.5f, 0.5f);
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(state.yRot));
            state.item.render(queue, matrices, state.lightCoords);
        }
    }

    private SuperByteBuffer renderAndTransform(PartialModel renderBlock, BlockState crafterState) {
        SuperByteBuffer buffer = CachedBuffers.partial(renderBlock, crafterState);
        float xRot = ((Pointing)((Object)crafterState.getValue(MechanicalCrafterBlock.POINTING))).getXRotation();
        float yRot = AngleHelper.horizontalAngle((Direction)crafterState.getValue(HorizontalKineticBlock.HORIZONTAL_FACING));
        buffer.rotateCentered((float)((double)((yRot + 90.0f) / 180.0f) * Math.PI), Direction.UP);
        buffer.rotateCentered((float)((double)(xRot / 180.0f) * Math.PI), Direction.EAST);
        return buffer;
    }

    public static class MechanicalCrafterRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public Vec3 offset;
        public float yRot;
        public MechanicalCrafterItemRenderState item;
        public RenderType layer;
        public CogwheelRenderState cogwheel;
        public float upRot;
        public float eastRot;
        public SuperByteBuffer lid;
        public SuperByteBuffer belt;
        public SuperByteBuffer frame;
        public float beltScroll;
        public SuperByteBuffer arrow;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            if (this.cogwheel != null) {
                this.cogwheel.render(matricesEntry, vertexConsumer, this.lightCoords);
            }
            if (this.lid != null) {
                ((SuperByteBuffer)((SuperByteBuffer)this.lid.rotateCentered(this.upRot, Direction.UP)).rotateCentered(this.eastRot, Direction.EAST)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            }
            if (this.belt != null) {
                ((SuperByteBuffer)this.belt.rotateCentered(this.upRot, Direction.UP)).rotateCentered(this.eastRot, Direction.EAST);
                if (this.beltScroll != 0.0f) {
                    this.belt.shiftUVtoSheet(AllSpriteShifts.CRAFTER_THINGIES, this.beltScroll, 0.0f, 1);
                }
                this.belt.light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
                ((SuperByteBuffer)((SuperByteBuffer)this.frame.rotateCentered(this.upRot, Direction.UP)).rotateCentered(this.eastRot, Direction.EAST)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            } else {
                ((SuperByteBuffer)((SuperByteBuffer)this.arrow.rotateCentered(this.upRot, Direction.UP)).rotateCentered(this.eastRot, Direction.EAST)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }

    public static interface MechanicalCrafterItemRenderState {
        public void render(SubmitNodeCollector var1, PoseStack var2, int var3);
    }

    public record CogwheelRenderState(SuperByteBuffer cogwheel, float angle, Direction direction, Color color, float upAngle) {
        public static CogwheelRenderState create(MechanicalCrafterBlockEntity be, BlockState blockState, BlockPos pos, Direction facing) {
            SuperByteBuffer model = CachedBuffers.partial(AllPartialModels.SHAFTLESS_COGWHEEL, blockState);
            Direction.Axis axis = facing.getAxis();
            float angle = KineticBlockEntityRenderer.getAngleForBe(be, pos, axis);
            Direction direction = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            float upAngle = axis != Direction.Axis.X ? 0.0f : 1.5707964f;
            Color color = KineticBlockEntityRenderer.getColor(be);
            return new CogwheelRenderState(model, angle, direction, color, upAngle);
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer, int light) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.cogwheel.rotateCentered(this.angle, this.direction)).rotateCentered(this.upAngle, Direction.UP)).rotateCentered(1.5707964f, Direction.EAST)).light(light).renderInto(matricesEntry, vertexConsumer);
        }
    }

    public record MechanicalCrafterSingleItemRenderState(float offset, float yRot, ItemStackRenderState state) implements MechanicalCrafterItemRenderState
    {
        public static MechanicalCrafterSingleItemRenderState create(ItemModelResolver itemModelManager, MechanicalCrafterBlockEntity be, Level world) {
            ItemStack stack = be.getInventory().getStack();
            if (stack.isEmpty()) {
                return null;
            }
            float offset = -0.00390625f;
            float yRot = (float)Math.PI;
            ItemStackRenderState state = new ItemStackRenderState();
            state.displayContext = ItemDisplayContext.FIXED;
            itemModelManager.appendItemLayers(state, stack, state.displayContext, world, null, 0);
            return new MechanicalCrafterSingleItemRenderState(offset, yRot, state);
        }

        @Override
        public void render(SubmitNodeCollector queue, PoseStack ms, int light) {
            ms.pushPose();
            ms.translate(0.0f, 0.0f, this.offset);
            ms.mulPose((Quaternionfc)Axis.YP.rotation(this.yRot));
            this.state.submit(ms, queue, light, OverlayTexture.NO_OVERLAY, 0);
            ms.popPose();
        }
    }

    public record MechanicalCrafterCraftingItemRenderState(float scale, Vec3 centering, List<GridItemRenderState> before, float yRot, float zRot, float upScaling, float downScaling, List<ItemStackRenderState> states) implements MechanicalCrafterItemRenderState
    {
        public static MechanicalCrafterCraftingItemRenderState create(ItemModelResolver itemModelManager, MechanicalCrafterBlockEntity be, Level world, float tickProgress) {
            ArrayList states;
            float zRot;
            float upScaling;
            float downScaling;
            ArrayList before;
            Vec3 centering;
            float scale;
            RecipeGridHandler.GroupedItems items = be.groupedItemsBeforeCraft;
            boolean beforeEmpty = items.grid.isEmpty();
            boolean itemsEmpty = be.groupedItems.grid.isEmpty();
            if (beforeEmpty && itemsEmpty) {
                return null;
            }
            float yRot = (float)Math.PI;
            float value = (float)be.countDown - (float)be.getCountDownSpeed() * tickProgress;
            if (beforeEmpty) {
                scale = 0.0f;
                centering = null;
                before = null;
            } else {
                items.calcStats();
                float progress = Mth.clamp((float)((2000.0f - value) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = Mth.clamp((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                scale = 1.0f - Mth.clamp((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                centering = new Vec3((double)((float)(-items.minX) + (float)(-items.width + 1) / 2.0f), (double)((float)(-items.minY) + (float)(-items.height + 1) / 2.0f), 0.0).scale((double)earlyProgress).multiply(0.5, 0.5, 1.0);
                float distance = 0.5f + (-4.0f * (progress - 0.5f) * (progress - 0.5f) + 1.0f) * 0.25f;
                boolean onlyRenderFirst = be.countDown < 1000;
                before = new ArrayList(items.grid.size());
                items.grid.forEach((pair, stack) -> {
                    if (onlyRenderFirst && ((Integer)pair.getFirst() != 0 || (Integer)pair.getSecond() != 0)) {
                        return;
                    }
                    int x = (Integer)pair.getFirst();
                    int y = (Integer)pair.getSecond();
                    float offsetX = (float)x * distance;
                    float offsetY = (float)y * distance;
                    float offsetZ = (float)(x + y * 3) / 1024.0f;
                    ItemStackRenderState state = new ItemStackRenderState();
                    state.displayContext = ItemDisplayContext.FIXED;
                    itemModelManager.appendItemLayers(state, stack, state.displayContext, world, null, 0);
                    before.add(new GridItemRenderState(state, offsetX, offsetY, offsetZ));
                });
            }
            if (itemsEmpty) {
                downScaling = 0.0f;
                upScaling = 0.0f;
                zRot = 0.0f;
                states = null;
            } else {
                float progress = Mth.clamp((float)((1000.0f - value) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = Mth.clamp((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                zRot = (float)Math.PI / 180 * (earlyProgress * 2.0f * 360.0f);
                upScaling = earlyProgress * 1.125f;
                downScaling = 1.0f + (1.0f - Mth.clamp((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f)) * 0.125f;
                items = be.groupedItems;
                states = new ArrayList(items.grid.size());
                items.grid.forEach((pair, stack) -> {
                    if ((Integer)pair.getFirst() != 0 || (Integer)pair.getSecond() != 0) {
                        return;
                    }
                    ItemStackRenderState state = new ItemStackRenderState();
                    state.displayContext = ItemDisplayContext.FIXED;
                    itemModelManager.appendItemLayers(state, stack, state.displayContext, world, null, 0);
                    states.add(state);
                });
            }
            return new MechanicalCrafterCraftingItemRenderState(scale, centering, before, yRot, zRot, upScaling, downScaling, states);
        }

        @Override
        public void render(SubmitNodeCollector queue, PoseStack ms, int light) {
            if (this.before != null) {
                ms.pushPose();
                ms.scale(this.scale, this.scale, this.scale);
                ms.translate(this.centering);
                for (GridItemRenderState gridItemRenderState : this.before) {
                    gridItemRenderState.render(queue, ms, this.yRot, light);
                }
                ms.popPose();
            }
            if (this.states != null) {
                ms.mulPose((Quaternionfc)Axis.ZP.rotation(this.zRot));
                ms.scale(this.upScaling, this.upScaling, this.upScaling);
                ms.scale(this.downScaling, this.downScaling, this.downScaling);
                for (ItemStackRenderState itemStackRenderState : this.states) {
                    ms.pushPose();
                    ms.mulPose((Quaternionfc)Axis.YP.rotation(this.yRot));
                    itemStackRenderState.submit(ms, queue, light, OverlayTexture.NO_OVERLAY, 0);
                    ms.popPose();
                }
            }
        }
    }

    public record MechanicalCrafterPhaseItemRenderState(List<GridItemRenderState> states, float yRot) implements MechanicalCrafterItemRenderState
    {
        public static MechanicalCrafterPhaseItemRenderState create(ItemModelResolver itemModelManager, MechanicalCrafterBlockEntity be, Level world, BlockState blockState, MechanicalCrafterBlockEntity.Phase phase) {
            Map<Pair<Integer, Integer>, ItemStack> grid = be.groupedItems.grid;
            if (grid.isEmpty()) {
                return null;
            }
            float distance = 0.5f;
            boolean onlyRenderFirst = phase == MechanicalCrafterBlockEntity.Phase.INSERTING;
            boolean isExporting = phase == MechanicalCrafterBlockEntity.Phase.EXPORTING && blockState.hasProperty(MechanicalCrafterBlock.POINTING);
            Pointing pointing = isExporting ? (Pointing)((Object)blockState.getValue(MechanicalCrafterBlock.POINTING)) : null;
            float yRot = (float)Math.PI;
            ArrayList<GridItemRenderState> states = new ArrayList<GridItemRenderState>(grid.size());
            grid.forEach((pair, stack) -> {
                if (onlyRenderFirst && ((Integer)pair.getFirst() != 0 || (Integer)pair.getSecond() != 0)) {
                    return;
                }
                int x = (Integer)pair.getFirst();
                int y = (Integer)pair.getSecond();
                float offsetX = (float)x * distance;
                float offsetY = (float)y * distance;
                int value = x + y * 3;
                if (pointing != null) {
                    switch (pointing) {
                        case UP: {
                            value -= 9;
                            break;
                        }
                        case LEFT: {
                            value += 18;
                            break;
                        }
                        case RIGHT: {
                            value -= 18;
                            break;
                        }
                        case DOWN: {
                            value += 9;
                        }
                    }
                }
                float offsetZ = (float)value / 1024.0f;
                ItemStackRenderState state = new ItemStackRenderState();
                state.displayContext = ItemDisplayContext.FIXED;
                itemModelManager.appendItemLayers(state, stack, state.displayContext, world, null, 0);
                states.add(new GridItemRenderState(state, offsetX, offsetY, offsetZ));
            });
            return new MechanicalCrafterPhaseItemRenderState(states, yRot);
        }

        @Override
        public void render(SubmitNodeCollector queue, PoseStack ms, int light) {
            for (GridItemRenderState state : this.states) {
                state.render(queue, ms, this.yRot, light);
            }
        }
    }

    public record GridItemRenderState(ItemStackRenderState state, float offsetX, float offsetY, float offsetZ) {
        public void render(SubmitNodeCollector queue, PoseStack ms, float yRot, int light) {
            ms.pushPose();
            ms.translate(this.offsetX, this.offsetY, 0.0f);
            ms.mulPose((Quaternionfc)Axis.YP.rotation(yRot));
            ms.translate(0.0f, 0.0f, this.offsetZ);
            this.state.submit(ms, queue, light, OverlayTexture.NO_OVERLAY, 0);
            ms.popPose();
        }
    }
}

