/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.crank;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.crank.ValveHandleRenderer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.kinetics.crank.ValveHandleBlock;
import com.zurrtum.create.content.kinetics.crank.ValveHandleBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ValveHandleVisual
extends KineticBlockEntityVisual<ValveHandleBlockEntity>
implements SimpleDynamicVisual {
    private final TransformedInstance crank;

    public ValveHandleVisual(VisualizationContext modelManager, ValveHandleBlockEntity blockEntity, float partialTick) {
        super(modelManager, blockEntity, partialTick);
        Block block;
        BlockState state = blockEntity.getBlockState();
        DyeColor color = null;
        if (state != null && (block = state.getBlock()) instanceof ValveHandleBlock) {
            ValveHandleBlock vhb = (ValveHandleBlock)block;
            color = vhb.color;
        }
        this.crank = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(color == null ? AllPartialModels.VALVE_HANDLE : AllPartialModels.DYED_VALVE_HANDLES.get(color))).createInstance();
        this.rotateCrank(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.rotateCrank(ctx.partialTick());
    }

    private void rotateCrank(float pt) {
        Direction facing = (Direction)this.blockState.getValue((Property)BlockStateProperties.FACING);
        float angle = ValveHandleRenderer.getValveHandleIndependentAngle((ValveHandleBlockEntity)this.blockEntity, pt);
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.crank.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).center()).rotate(angle, Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)facing.getAxis()))).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, 1.0f, 0.0f, (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ())).uncenter()).setChanged();
    }

    @Override
    protected void _delete() {
        this.crank.delete();
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.crank);
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept(this.crank);
    }
}

