/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.deployer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class DeployerRenderer
implements BlockEntityRenderer<DeployerBlockEntity, DeployerRenderState> {
    protected final ItemModelResolver itemModelManager;

    public DeployerRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public DeployerRenderState createRenderState() {
        return new DeployerRenderState();
    }

    public void extractRenderState(DeployerBlockEntity be, DeployerRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        Level world = be.getLevel();
        DeployerRenderer.updateItemRenderState(be, state, this.itemModelManager, world, tickProgress);
        state.filter = FilteringRenderer.getFilterRenderState(be, state.blockState, this.itemModelManager, be.isVirtual() ? -1.0 : cameraPos.distanceToSqr(VecHelper.getCenterOf((Vec3i)state.blockPos)));
        DeployerRenderer.updateComponentsRenderState(be, state, world, tickProgress);
    }

    public static void updateItemRenderState(DeployerBlockEntity be, DeployerRenderState state, ItemModelResolver itemModelManager, Level world, float tickProgress) {
        boolean isBlockItem;
        ItemStack heldItem = be.heldItem;
        if (heldItem.isEmpty()) {
            return;
        }
        DeployerItemRenderState data = state.item = new DeployerItemRenderState();
        data.offset = DeployerRenderer.getHandOffset(state, be, tickProgress, state.blockState).add(VecHelper.getCenterOf((Vec3i)BlockPos.ZERO));
        Direction facing = (Direction)state.blockState.getValue(DirectionalKineticBlock.FACING);
        data.punching = be.mode == DeployerBlockEntity.Mode.PUNCH;
        data.yRot = (float)Math.PI / 180 * (AngleHelper.horizontalAngle(facing) + 180.0f);
        data.xRot = (float)Math.PI / 180 * (float)(facing == Direction.UP ? 90 : (facing == Direction.DOWN ? 270 : 0));
        data.displayMode = facing == Direction.UP && be.getSpeed() == 0.0f && !data.punching;
        ItemStackRenderState renderState = data.state = new ItemStackRenderState();
        renderState.displayContext = data.displayMode ? ItemDisplayContext.GROUND : (data.punching ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.FIXED);
        itemModelManager.appendItemLayers(renderState, heldItem, renderState.displayContext, world, null, 0);
        boolean bl = isBlockItem = heldItem.getItem() instanceof BlockItem && renderState.usesBlockLight();
        if (data.displayMode) {
            data.translateY = isBlockItem ? 0.5625f : 0.6875f;
            data.scale = isBlockItem ? 1.25f : 1.0f;
            data.yRot2 = (float)Math.PI / 180 * AnimationTickHolder.getRenderTime((LevelAccessor)world);
        } else {
            data.scale = data.punching ? 0.75f : (isBlockItem ? 0.734375f : 0.5f);
        }
    }

    public static void updateComponentsRenderState(DeployerBlockEntity be, DeployerRenderState state, Level world, float tickProgress) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)world)) {
            return;
        }
        ComponentsRenderState components = state.components = new ComponentsRenderState();
        components.layer = RenderTypes.solidMovingBlock();
        components.light = state.lightCoords;
        Direction.Axis axis = ((IRotate)state.blockState.getBlock()).getRotationAxis(state.blockState);
        components.shaft = CachedBuffers.block(KineticBlockEntityRenderer.KINETIC_BLOCK, KineticBlockEntityRenderer.shaft(axis));
        components.angle = KineticBlockEntityRenderer.getAngleForBe(be, state.blockPos, axis);
        components.direction = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        components.color = KineticBlockEntityRenderer.getColor(be);
        components.offset = DeployerRenderer.getHandOffset(state, be, tickProgress, state.blockState);
        components.pole = CachedBuffers.partial(AllPartialModels.DEPLOYER_POLE, state.blockState);
        components.hand = CachedBuffers.partial(DeployerRenderer.getHandPose(be), state.blockState);
        Direction facing = (Direction)state.blockState.getValue(DirectionalKineticBlock.FACING);
        components.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        components.xRot = (float)Math.PI / 180 * (float)(facing == Direction.UP ? 270 : (facing == Direction.DOWN ? 90 : 0));
        components.zRot = (float)Math.PI / 180 * (float)((Boolean)state.blockState.getValue((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ facing.getAxis() == Direction.Axis.Z ? 90 : 0);
    }

    public void submit(DeployerRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.item != null) {
            state.item.render(matrices, queue, state.lightCoords);
        }
        if (state.filter != null) {
            state.filter.render(state.blockState, queue, matrices, state.lightCoords);
        }
        if (state.components != null) {
            queue.submitCustomGeometry(matrices, state.components.layer, (SubmitNodeCollector.CustomGeometryRenderer)state.components);
        }
    }

    public static PartialModel getHandPose(DeployerBlockEntity be) {
        return be.mode == DeployerBlockEntity.Mode.PUNCH ? AllPartialModels.DEPLOYER_HAND_PUNCHING : (be.heldItem.isEmpty() ? AllPartialModels.DEPLOYER_HAND_POINTING : AllPartialModels.DEPLOYER_HAND_HOLDING);
    }

    public static Vec3 getHandOffset(DeployerRenderState state, DeployerBlockEntity be, float partialTicks, BlockState blockState) {
        if (state.offset != null) {
            return state.offset;
        }
        state.offset = DeployerRenderer.getHandOffset(be, partialTicks, blockState);
        return state.offset;
    }

    public static Vec3 getHandOffset(DeployerBlockEntity be, float partialTicks, BlockState blockState) {
        float distance = DeployerRenderer.getHandOffset(be, partialTicks);
        return Vec3.atLowerCornerOf((Vec3i)((Direction)blockState.getValue(DirectionalKineticBlock.FACING)).getUnitVec3i()).scale((double)distance);
    }

    public static float getHandOffset(DeployerBlockEntity be, float partialTicks) {
        if (be.isVirtual()) {
            return be.animatedOffset.getValue(partialTicks);
        }
        float progress = 0.0f;
        int timerSpeed = be.getTimerSpeed();
        PartialModel handPose = DeployerRenderer.getHandPose(be);
        if (be.state == DeployerBlockEntity.State.EXPANDING) {
            progress = 1.0f - ((float)be.timer - partialTicks * (float)timerSpeed) / 1000.0f;
            if (be.fistBump) {
                progress *= progress;
            }
        }
        if (be.state == DeployerBlockEntity.State.RETRACTING) {
            progress = ((float)be.timer - partialTicks * (float)timerSpeed) / 1000.0f;
        }
        float handLength = handPose == AllPartialModels.DEPLOYER_HAND_POINTING ? 0.0f : (handPose == AllPartialModels.DEPLOYER_HAND_HOLDING ? 0.25f : 0.1875f);
        return Math.min(Mth.clamp((float)progress, (float)0.0f, (float)1.0f) * (be.reach + handLength), 1.3125f);
    }

    private static SuperByteBuffer transform(SuperByteBuffer buffer, BlockState deployerState, boolean axisDirectionMatters) {
        float xRot;
        Direction facing = (Direction)deployerState.getValue(DirectionalKineticBlock.FACING);
        float yRot = AngleHelper.horizontalAngle(facing);
        float f = facing == Direction.UP ? 270.0f : (xRot = facing == Direction.DOWN ? 90.0f : 0.0f);
        float zRot = axisDirectionMatters && (Boolean)deployerState.getValue((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ facing.getAxis() == Direction.Axis.Z ? 90.0f : 0.0f;
        buffer.rotateCentered((float)((double)(yRot / 180.0f) * Math.PI), Direction.UP);
        buffer.rotateCentered((float)((double)(xRot / 180.0f) * Math.PI), Direction.EAST);
        buffer.rotateCentered((float)((double)(zRot / 180.0f) * Math.PI), Direction.SOUTH);
        return buffer;
    }

    static PartialModel getHandPose(DeployerBlockEntity.Mode mode) {
        return mode == DeployerBlockEntity.Mode.PUNCH ? AllPartialModels.DEPLOYER_HAND_PUNCHING : AllPartialModels.DEPLOYER_HAND_POINTING;
    }

    public static class DeployerRenderState
    extends BlockEntityRenderState {
        public Vec3 offset;
        public DeployerItemRenderState item;
        public FilteringRenderer.FilterRenderState filter;
        public ComponentsRenderState components;
    }

    public static class DeployerItemRenderState {
        public Vec3 offset;
        public boolean punching;
        public float yRot;
        public float xRot;
        public boolean displayMode;
        public ItemStackRenderState state;
        public float translateY;
        public float scale;
        public float yRot2;

        public void render(PoseStack matrices, SubmitNodeCollector queue, int light) {
            matrices.pushPose();
            matrices.translate(this.offset);
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.yRot));
            if (!this.displayMode) {
                matrices.mulPose((Quaternionfc)Axis.XP.rotation(this.xRot));
                matrices.translate(0.0f, 0.0f, -0.6875f);
            }
            if (this.punching) {
                matrices.translate(0.0f, 0.125f, -0.0625f);
            }
            if (this.displayMode) {
                matrices.translate(0.0f, this.translateY, 0.0f);
                matrices.scale(this.scale, this.scale, this.scale);
                matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.yRot2));
            } else {
                matrices.scale(this.scale, this.scale, this.scale);
            }
            this.state.submit(matrices, queue, light, OverlayTexture.NO_OVERLAY, 0);
            matrices.popPose();
        }
    }

    public static class ComponentsRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public int light;
        public SuperByteBuffer shaft;
        public float angle;
        public Direction direction;
        public Color color;
        public Vec3 offset;
        public SuperByteBuffer pole;
        public SuperByteBuffer hand;
        public float yRot;
        public float xRot;
        public float zRot;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)this.shaft.light(this.light).rotateCentered(this.angle, this.direction)).color(this.color).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.pole.translate(this.offset)).rotateCentered(this.yRot, Direction.UP)).rotateCentered(this.xRot, Direction.EAST)).rotateCentered(this.zRot, Direction.SOUTH)).light(this.light).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.hand.translate(this.offset)).rotateCentered(this.yRot, Direction.UP)).rotateCentered(this.xRot, Direction.EAST)).light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

