/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.drill;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.drill.DrillBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DrillActorVisual
extends ActorVisual {
    TransformedInstance drillHead;
    private final Direction facing;
    private double rotation;
    private double previousRotation;

    public DrillActorVisual(VisualizationContext visualizationContext, VirtualRenderWorld contraption, MovementContext context) {
        super(visualizationContext, (BlockAndTintGetter)contraption, context);
        BlockState state = context.state;
        this.facing = (Direction)state.getValue((Property)DrillBlock.FACING);
        this.drillHead = this.instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.DRILL_HEAD)).createInstance();
    }

    @Override
    public void tick() {
        this.previousRotation = this.rotation;
        if (this.context.disabled || VecHelper.isVecPointingTowards(this.context.relativeMotion, this.facing.getOpposite())) {
            return;
        }
        float deg = this.context.getAnimationSpeed();
        this.rotation += (double)(deg / 20.0f);
        this.rotation %= 360.0;
    }

    @Override
    public void beginFrame() {
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.drillHead.setIdentityTransform().translate((Vec3i)this.context.localPos)).center()).rotateToFace(this.facing.getOpposite())).rotateZDegrees((float)this.getRotation())).uncenter()).setChanged();
    }

    protected double getRotation() {
        return AngleHelper.angleLerp(AnimationTickHolder.getPartialTicks(), this.previousRotation, this.rotation);
    }

    @Override
    protected void _delete() {
        this.drillHead.delete();
    }
}

