/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.fan;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.fan.EncasedFanBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EncasedFanRenderer
implements BlockEntityRenderer<EncasedFanBlockEntity, EncasedFanRenderState> {
    public EncasedFanRenderer(BlockEntityRendererProvider.Context context) {
    }

    public EncasedFanRenderState createRenderState() {
        return new EncasedFanRenderState();
    }

    public void extractRenderState(EncasedFanBlockEntity be, EncasedFanRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        state.blockPos = be.getBlockPos();
        state.blockState = be.getBlockState();
        state.blockEntityType = be.getType();
        state.breakProgress = crumblingOverlay;
        state.layer = RenderTypes.cutoutMovingBlock();
        Direction direction = (Direction)state.blockState.getValue((Property)BlockStateProperties.FACING);
        Direction opposite = direction.getOpposite();
        Level world = be.getLevel();
        if (world != null) {
            state.lightBehind = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos.relative(opposite));
            state.lightInFront = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos.relative(direction));
        } else {
            state.lightInFront = 0xF000F0;
            state.lightBehind = 0xF000F0;
        }
        state.shaftHalf = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.blockState, opposite);
        state.fanInner = CachedBuffers.partialFacing(AllPartialModels.ENCASED_FAN_INNER, state.blockState, opposite);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)world);
        float speed = be.getSpeed() * 5.0f;
        if (speed > 0.0f) {
            speed = Mth.clamp((float)speed, (float)80.0f, (float)1280.0f);
        }
        if (speed < 0.0f) {
            speed = Mth.clamp((float)speed, (float)-1280.0f, (float)-80.0f);
        }
        float angle = time * speed * 3.0f / 10.0f % 360.0f;
        Direction.Axis axis = ((IRotate)state.blockState.getBlock()).getRotationAxis(state.blockState);
        state.angle = KineticBlockEntityRenderer.getAngleForBe(be, state.blockPos, axis);
        state.direction = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        state.color = KineticBlockEntityRenderer.getColor(be);
        state.fanAngle = angle / 180.0f * (float)Math.PI;
    }

    public void submit(EncasedFanRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    public static class EncasedFanRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public int lightBehind;
        public int lightInFront;
        public SuperByteBuffer shaftHalf;
        public float angle;
        public Direction direction;
        public Color color;
        public SuperByteBuffer fanInner;
        public float fanAngle;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.shaftHalf.light(this.lightBehind);
            this.shaftHalf.rotateCentered(this.angle, this.direction);
            this.shaftHalf.color(this.color);
            this.shaftHalf.renderInto(matricesEntry, vertexConsumer);
            this.fanInner.light(this.lightInFront);
            this.fanInner.rotateCentered(this.fanAngle, this.direction);
            this.fanInner.color(this.color);
            this.fanInner.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

