/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.fan;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.fan.EncasedFanBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FanVisual
extends KineticBlockEntityVisual<EncasedFanBlockEntity> {
    protected final RotatingInstance shaft;
    protected final RotatingInstance fan;
    final Direction direction;
    private final Direction opposite;

    public FanVisual(VisualizationContext context, EncasedFanBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        this.direction = (Direction)this.blockState.getValue((Property)BlockStateProperties.FACING);
        this.opposite = this.direction.getOpposite();
        this.shaft = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial(AllPartialModels.SHAFT_HALF)).createInstance();
        this.fan = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial(AllPartialModels.ENCASED_FAN_INNER)).createInstance();
        this.shaft.setup(blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, this.opposite).setChanged();
        this.fan.setup((KineticBlockEntity)blockEntity, this.getFanSpeed()).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, this.opposite).setChanged();
    }

    private float getFanSpeed() {
        float speed = ((EncasedFanBlockEntity)this.blockEntity).getSpeed() * 5.0f;
        if (speed > 0.0f) {
            speed = Mth.clamp((float)speed, (float)80.0f, (float)1280.0f);
        }
        if (speed < 0.0f) {
            speed = Mth.clamp((float)speed, (float)-1280.0f, (float)-80.0f);
        }
        return speed;
    }

    @Override
    public void update(float pt) {
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        this.fan.setup((KineticBlockEntity)this.blockEntity, this.getFanSpeed()).setChanged();
    }

    @Override
    public void updateLight(float partialTick) {
        BlockPos behind = this.pos.relative(this.opposite);
        this.relight(behind, this.shaft);
        BlockPos inFront = this.pos.relative(this.direction);
        this.relight(inFront, this.fan);
    }

    @Override
    protected void _delete() {
        this.shaft.delete();
        this.fan.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept(this.shaft);
        consumer.accept(this.fan);
    }
}

