/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.gauge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.kinetics.base.ShaftVisual;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.Instancer;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.kinetics.gauge.GaugeBlock;
import com.zurrtum.create.content.kinetics.gauge.GaugeBlockEntity;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;

public abstract class GaugeVisual
extends ShaftVisual<GaugeBlockEntity>
implements SimpleDynamicVisual {
    protected final ArrayList<DialFace> faces = new ArrayList(2);
    protected final PoseStack ms = new PoseStack();

    protected GaugeVisual(VisualizationContext context, GaugeBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        GaugeBlock gaugeBlock = (GaugeBlock)this.blockState.getBlock();
        Instancer<TransformedInstance> dialModel = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.GAUGE_DIAL));
        Instancer<TransformedInstance> headModel = this.getHeadModel();
        PoseTransformStack msr = TransformStack.of(this.ms);
        msr.translate((Vec3i)this.getVisualPosition());
        float progress = Mth.lerp((float)AnimationTickHolder.getPartialTicks(), (float)blockEntity.prevDialState, (float)blockEntity.dialState);
        for (Direction facing : Iterate.directions) {
            if (!gaugeBlock.shouldRenderHeadOnFace(this.level, this.pos, this.blockState, facing)) continue;
            DialFace face = this.makeFace(facing, dialModel, headModel);
            this.faces.add(face);
            face.setupTransform(msr, progress);
        }
    }

    private DialFace makeFace(Direction face, Instancer<TransformedInstance> dialModel, Instancer<TransformedInstance> headModel) {
        return new DialFace(face, dialModel.createInstance(), headModel.createInstance());
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        if (Mth.equal((float)((GaugeBlockEntity)this.blockEntity).prevDialState, (float)((GaugeBlockEntity)this.blockEntity).dialState)) {
            return;
        }
        float progress = Mth.lerp((float)ctx.partialTick(), (float)((GaugeBlockEntity)this.blockEntity).prevDialState, (float)((GaugeBlockEntity)this.blockEntity).dialState);
        PoseTransformStack msr = TransformStack.of(this.ms);
        for (DialFace faceEntry : this.faces) {
            faceEntry.updateTransform(msr, progress);
        }
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight((FlatLit[])this.faces.stream().flatMap(Couple::stream).toArray(FlatLit[]::new));
    }

    @Override
    protected void _delete() {
        super._delete();
        this.faces.forEach(DialFace::delete);
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        for (DialFace face : this.faces) {
            face.forEach(consumer);
        }
    }

    protected abstract Instancer<TransformedInstance> getHeadModel();

    protected class DialFace
    extends Couple<TransformedInstance> {
        Direction face;

        public DialFace(Direction face, TransformedInstance first, TransformedInstance second) {
            super(first, second);
            this.face = face;
        }

        private void setupTransform(TransformStack<?> msr, float progress) {
            float dialPivot = 0.359375f;
            msr.pushPose();
            this.rotateToFace(msr);
            ((TransformedInstance)this.getSecond()).setTransform(GaugeVisual.this.ms).setChanged();
            ((TransformStack)((TransformStack)msr.translate(0.0f, dialPivot, dialPivot)).rotate((float)(1.5707963267948966 * (double)(-progress)), Direction.EAST)).translate(0.0f, -dialPivot, -dialPivot);
            ((TransformedInstance)this.getFirst()).setTransform(GaugeVisual.this.ms).setChanged();
            msr.popPose();
        }

        private void updateTransform(TransformStack<?> msr, float progress) {
            float dialPivot = 0.359375f;
            msr.pushPose();
            ((TransformStack)((TransformStack)this.rotateToFace(msr).translate(0.0f, dialPivot, dialPivot)).rotate((float)(1.5707963267948966 * (double)(-progress)), Direction.EAST)).translate(0.0f, -dialPivot, -dialPivot);
            ((TransformedInstance)this.getFirst()).setTransform(GaugeVisual.this.ms).setChanged();
            msr.popPose();
        }

        protected TransformStack<?> rotateToFace(TransformStack<?> msr) {
            return (TransformStack)((TransformStack)((TransformStack)msr.center()).rotate((float)((double)((-this.face.toYRot() - 90.0f) / 180.0f) * Math.PI), Direction.UP)).uncenter();
        }

        private void delete() {
            ((TransformedInstance)this.getFirst()).delete();
            ((TransformedInstance)this.getSecond()).delete();
        }
    }

    public static class Stress
    extends GaugeVisual {
        public Stress(VisualizationContext context, GaugeBlockEntity blockEntity, float partialTick) {
            super(context, blockEntity, partialTick);
        }

        @Override
        protected Instancer<TransformedInstance> getHeadModel() {
            return this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.GAUGE_HEAD_STRESS));
        }
    }

    public static class Speed
    extends GaugeVisual {
        public Speed(VisualizationContext context, GaugeBlockEntity blockEntity, float partialTick) {
            super(context, blockEntity, partialTick);
        }

        @Override
        protected Instancer<TransformedInstance> getHeadModel() {
            return this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.GAUGE_HEAD_SPEED));
        }
    }
}

