/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.gearbox;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.gearbox.GearboxBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GearboxRenderer
implements BlockEntityRenderer<GearboxBlockEntity, GearboxRenderState> {
    public GearboxRenderer(BlockEntityRendererProvider.Context context) {
    }

    public GearboxRenderState createRenderState() {
        return new GearboxRenderState();
    }

    public void extractRenderState(GearboxBlockEntity be, GearboxRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        float offset;
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        state.layer = RenderTypes.solidMovingBlock();
        Direction.Axis boxAxis = (Direction.Axis)state.blockState.getValue((Property)BlockStateProperties.AXIS);
        BlockPos pos = state.blockPos;
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        float speed = be.getSpeed();
        BlockPos source = null;
        Direction sourceFacing = null;
        if (speed != 0.0f && be.source != null) {
            source = be.source.subtract((Vec3i)state.blockPos);
            sourceFacing = Direction.getApproximateNearest((float)source.getX(), (float)source.getY(), (float)source.getZ());
        }
        state.color = KineticBlockEntityRenderer.getColor(be);
        float angle = time * speed * 3.0f / 10.0f % 360.0f;
        if (boxAxis != Direction.Axis.Y) {
            offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, Direction.Axis.Y);
            state.down = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.blockState, Direction.DOWN);
            state.downAngle = GearboxRenderer.getAngle(angle, offset, Direction.DOWN, source, sourceFacing);
            state.up = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.blockState, Direction.UP);
            state.upAngle = GearboxRenderer.getAngle(angle, offset, Direction.UP, source, sourceFacing);
        }
        if (boxAxis != Direction.Axis.Z) {
            offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, Direction.Axis.Z);
            state.north = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.blockState, Direction.NORTH);
            state.northAngle = GearboxRenderer.getAngle(angle, offset, Direction.NORTH, source, sourceFacing);
            state.south = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.blockState, Direction.SOUTH);
            state.southAngle = GearboxRenderer.getAngle(angle, offset, Direction.SOUTH, source, sourceFacing);
        }
        if (boxAxis != Direction.Axis.X) {
            offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, Direction.Axis.X);
            state.west = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.blockState, Direction.WEST);
            state.westAngle = GearboxRenderer.getAngle(angle, offset, Direction.WEST, source, sourceFacing);
            state.east = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.blockState, Direction.EAST);
            state.eastAngle = GearboxRenderer.getAngle(angle, offset, Direction.EAST, source, sourceFacing);
        }
    }

    private static float getAngle(float angle, float offset, Direction direction, BlockPos source, Direction sourceFacing) {
        if (source != null) {
            if (sourceFacing.getAxis() == direction.getAxis()) {
                angle *= sourceFacing == direction ? 1.0f : -1.0f;
            } else if (sourceFacing.getAxisDirection() == direction.getAxisDirection()) {
                angle *= -1.0f;
            }
        }
        return (angle += offset) / 180.0f * (float)Math.PI;
    }

    public void submit(GearboxRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    public static class GearboxRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public Color color;
        public SuperByteBuffer down;
        public float downAngle;
        public SuperByteBuffer up;
        public float upAngle;
        public SuperByteBuffer north;
        public float northAngle;
        public SuperByteBuffer south;
        public float southAngle;
        public SuperByteBuffer west;
        public float westAngle;
        public SuperByteBuffer east;
        public float eastAngle;

        private void render(SuperByteBuffer model, float angle, Direction axis, PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            model.light(this.lightCoords);
            model.rotateCentered(angle, axis);
            model.color(this.color);
            model.renderInto(matricesEntry, vertexConsumer);
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            if (this.down != null) {
                this.render(this.down, this.downAngle, Direction.UP, matricesEntry, vertexConsumer);
                this.render(this.up, this.upAngle, Direction.UP, matricesEntry, vertexConsumer);
            }
            if (this.north != null) {
                this.render(this.north, this.northAngle, Direction.SOUTH, matricesEntry, vertexConsumer);
                this.render(this.south, this.southAngle, Direction.SOUTH, matricesEntry, vertexConsumer);
            }
            if (this.west != null) {
                this.render(this.west, this.westAngle, Direction.EAST, matricesEntry, vertexConsumer);
                this.render(this.east, this.eastAngle, Direction.EAST, matricesEntry, vertexConsumer);
            }
        }
    }
}

