/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.mechanicalArm;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.zurrtum.create.infrastructure.packet.c2s.ArmPlacementPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ArmInteractionPointHandler {
    static List<ArmInteractionPoint> currentSelection = new ArrayList<ArmInteractionPoint>();
    static ItemStack currentItem;
    static long lastBlockPos;

    public static InteractionResult rightClickingBlocksSelectsThem(Level world, LocalPlayer player, InteractionHand hand, BlockHitResult hit) {
        if (currentItem == null) {
            return null;
        }
        if (player != null && player.isSpectator()) {
            return null;
        }
        BlockPos pos = hit.getBlockPos();
        ArmInteractionPoint selected = ArmInteractionPointHandler.getSelected(pos);
        BlockState state = world.getBlockState(pos);
        if (selected == null) {
            ArmInteractionPoint point = ArmInteractionPoint.create(world, pos, state);
            if (point == null) {
                return null;
            }
            selected = point;
            ArmInteractionPointHandler.put(point);
        }
        selected.cycleMode();
        if (player != null) {
            ArmInteractionPoint.Mode mode = selected.getMode();
            MutableComponent text = Component.translatable((String)mode.getTranslationKey(), (Object[])new Object[]{CreateLang.blockName(state).style(ChatFormatting.WHITE).component()}).withColor(mode.getColor());
            player.displayClientMessage((Component)text, true);
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean leftClickingBlocksDeselectsThem(BlockPos pos) {
        if (currentItem == null) {
            return false;
        }
        return ArmInteractionPointHandler.remove(pos);
    }

    public static void flushSettings(LocalPlayer player, BlockPos pos) {
        if (currentSelection == null) {
            return;
        }
        int removed = 0;
        Iterator<ArmInteractionPoint> iterator = currentSelection.iterator();
        while (iterator.hasNext()) {
            ArmInteractionPoint point = iterator.next();
            if (point.getPos().closerThan((Vec3i)pos, (double)ArmBlockEntity.getRange())) continue;
            iterator.remove();
            ++removed;
        }
        if (removed > 0) {
            CreateLang.builder().translate("mechanical_arm.points_outside_range", removed).style(ChatFormatting.RED).sendStatus((Player)player);
        } else {
            int inputs = 0;
            int outputs = 0;
            for (ArmInteractionPoint armInteractionPoint : currentSelection) {
                if (armInteractionPoint.getMode() == ArmInteractionPoint.Mode.DEPOSIT) {
                    ++outputs;
                    continue;
                }
                ++inputs;
            }
            if (inputs + outputs > 0) {
                CreateLang.builder().translate("mechanical_arm.summary", inputs, outputs).style(ChatFormatting.WHITE).sendStatus((Player)player);
            }
        }
        player.connection.send((Packet)new ArmPlacementPacket(currentSelection, pos));
        currentSelection.clear();
        currentItem = null;
    }

    public static void tick(Minecraft mc) {
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack heldItemMainhand = player.getMainHandItem();
        if (!heldItemMainhand.is((Item)AllItems.MECHANICAL_ARM)) {
            currentItem = null;
        } else {
            if (heldItemMainhand != currentItem) {
                currentSelection.clear();
                currentItem = heldItemMainhand;
            }
            ArmInteractionPointHandler.drawOutlines(currentSelection);
        }
        ArmInteractionPointHandler.checkForWrench(mc, heldItemMainhand);
    }

    private static void checkForWrench(Minecraft mc, ItemStack heldItem) {
        if (!heldItem.is((Item)AllItems.WRENCH)) {
            return;
        }
        HitResult objectMouseOver = mc.hitResult;
        if (!(objectMouseOver instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)objectMouseOver;
        BlockPos pos = result.getBlockPos();
        BlockEntity be = mc.level.getBlockEntity(pos);
        if (!(be instanceof ArmBlockEntity)) {
            lastBlockPos = -1L;
            currentSelection.clear();
            return;
        }
        if (lastBlockPos == -1L || lastBlockPos != pos.asLong()) {
            currentSelection.clear();
            ArmBlockEntity arm = (ArmBlockEntity)be;
            arm.inputs.forEach(ArmInteractionPointHandler::put);
            arm.outputs.forEach(ArmInteractionPointHandler::put);
            lastBlockPos = pos.asLong();
        }
        if (lastBlockPos != -1L) {
            ArmInteractionPointHandler.drawOutlines(currentSelection);
        }
    }

    private static void drawOutlines(Collection<ArmInteractionPoint> selection) {
        Iterator<ArmInteractionPoint> iterator = selection.iterator();
        while (iterator.hasNext()) {
            BlockPos pos;
            ArmInteractionPoint point = iterator.next();
            if (!point.isValid()) {
                iterator.remove();
                continue;
            }
            Level level = point.getLevel();
            BlockState state = level.getBlockState(pos = point.getPos());
            VoxelShape shape = state.getShape((BlockGetter)level, pos);
            if (shape.isEmpty()) continue;
            int color = point.getMode().getColor();
            Outliner.getInstance().showAABB(point, shape.bounds().move(pos)).colored(color).lineWidth(0.0625f);
        }
    }

    private static void put(ArmInteractionPoint point) {
        currentSelection.add(point);
    }

    private static boolean remove(BlockPos pos) {
        ArmInteractionPoint result = ArmInteractionPointHandler.getSelected(pos);
        if (result != null) {
            currentSelection.remove(result);
            return true;
        }
        return false;
    }

    private static ArmInteractionPoint getSelected(BlockPos pos) {
        for (ArmInteractionPoint point : currentSelection) {
            if (!point.getPos().equals((Object)pos)) continue;
            return point;
        }
        return null;
    }

    static {
        lastBlockPos = -1L;
    }
}

