/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.mechanicalArm;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlock;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class ArmRenderer
extends KineticBlockEntityRenderer<ArmBlockEntity, ArmRenderState> {
    protected static ItemModelResolver itemModelManager;

    public ArmRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        itemModelManager = context.itemModelResolver();
    }

    @Override
    public ArmRenderState createRenderState() {
        return new ArmRenderState();
    }

    @Override
    public void extractRenderState(ArmBlockEntity be, ArmRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        boolean rave;
        boolean isBlockItem;
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        ItemStack item = be.heldItem;
        boolean empty = item.isEmpty();
        if (state.support) {
            if (empty) {
                return;
            }
            BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        }
        Level world = be.getLevel();
        if (empty) {
            isBlockItem = false;
        } else {
            ArmItemData data = state.item = new ArmItemData();
            ItemStackRenderState renderState = new ItemStackRenderState();
            renderState.displayContext = ItemDisplayContext.FIXED;
            itemModelManager.appendItemLayers(renderState, item, renderState.displayContext, world, null, 0);
            isBlockItem = item.getItem() instanceof BlockItem && renderState.usesBlockLight();
            data.state = renderState;
            data.xRot = 1.5707964f;
            if (isBlockItem) {
                data.offset = -0.5625f;
                data.scale = 0.5f;
            } else {
                data.offset = -0.625f;
                data.scale = 0.625f;
            }
        }
        boolean inverted = (Boolean)state.blockState.getValue((Property)ArmBlock.CEILING);
        if (inverted) {
            state.rotate = (float)Math.PI;
        }
        boolean bl = rave = be.phase == ArmBlockEntity.Phase.DANCING && be.getSpeed() != 0.0f;
        if (rave) {
            float renderTick = AnimationTickHolder.getRenderTime((LevelAccessor)world) + (float)(be.hashCode() % 64);
            state.baseAngle = (float)Math.PI / 180 * (renderTick * 10.0f % 360.0f);
            state.lowerArmAngle = (float)Math.PI / 180 * (float)(Mth.lerpInt((float)((Mth.sin((double)(renderTick / 4.0f)) + 1.0f) / 2.0f), (int)-45, (int)15) - 135);
            state.upperArmAngle = (float)Math.PI / 180 * (float)(Mth.lerpInt((float)((Mth.sin((double)(renderTick / 8.0f)) + 1.0f) / 4.0f), (int)-45, (int)95) - 90);
            state.headAngle = (float)Math.PI / 180 * (-state.lowerArmAngle - 45.0f);
        } else {
            state.baseAngle = (float)Math.PI / 180 * be.baseAngle.getValue(tickProgress);
            state.lowerArmAngle = (float)Math.PI / 180 * be.lowerArmAngle.getValue(tickProgress);
            state.upperArmAngle = (float)Math.PI / 180 * (be.upperArmAngle.getValue(tickProgress) - 180.0f);
            state.headAngle = (float)Math.PI / 180 * (be.headAngle.getValue(tickProgress) - 45.0f);
        }
        if (!state.support) {
            ArmRenderData data = state.arm = new ArmRenderData();
            boolean goggles = be.goggles;
            data.base = CachedBuffers.partial(AllPartialModels.ARM_BASE, state.blockState);
            data.lower = CachedBuffers.partial(AllPartialModels.ARM_LOWER_BODY, state.blockState);
            data.upper = CachedBuffers.partial(AllPartialModels.ARM_UPPER_BODY, state.blockState);
            data.claw = CachedBuffers.partial(goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE, state.blockState);
            data.clawUpper = CachedBuffers.partial(AllPartialModels.ARM_CLAW_GRIP_UPPER, state.blockState);
            data.clawLower = CachedBuffers.partial(AllPartialModels.ARM_CLAW_GRIP_LOWER, state.blockState);
            data.light = state.lightCoords;
            data.color = rave ? Color.rainbowColor(AnimationTickHolder.getTicks() * 100).getRGB() : 0xFFFFFF;
            boolean bl2 = data.inverted = inverted && goggles;
            data.clawOffset = empty ? 0.0625f : (isBlockItem ? 0.1875f : 0.078125f);
        }
    }

    @Override
    public void submit(ArmRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        super.submit(state, matrices, queue, cameraState);
        matrices.translate(0.5f, 0.5f, 0.5f);
        if (state.rotate != 0.0f) {
            matrices.mulPose((Quaternionfc)Axis.XP.rotation(state.rotate));
        }
        matrices.translate(0.0f, 0.25f, 0.0f);
        matrices.mulPose((Quaternionfc)Axis.YP.rotation(state.baseAngle));
        if (state.support) {
            matrices.translate(0.0f, 0.125f, 0.0f);
            matrices.mulPose((Quaternionfc)Axis.XP.rotation(state.lowerArmAngle));
            matrices.translate(0.0f, 0.0f, -0.875f);
            matrices.mulPose((Quaternionfc)Axis.XP.rotation(state.upperArmAngle));
            matrices.translate(0.0f, 0.0f, -0.9375f);
            matrices.mulPose((Quaternionfc)Axis.XP.rotation(state.headAngle));
            state.item.render(matrices, queue, state.lightCoords);
        } else {
            queue.submitCustomGeometry(matrices, state.layer, state.arm::renderBase);
            matrices.translate(0.0f, 0.125f, 0.0f);
            matrices.mulPose((Quaternionfc)Axis.XP.rotation(state.lowerArmAngle));
            queue.submitCustomGeometry(matrices, state.layer, state.arm::renderLower);
            matrices.translate(0.0f, 0.0f, -0.875f);
            matrices.mulPose((Quaternionfc)Axis.XP.rotation(state.upperArmAngle));
            queue.submitCustomGeometry(matrices, state.layer, state.arm::renderUpper);
            matrices.translate(0.0f, 0.0f, -0.9375f);
            matrices.mulPose((Quaternionfc)Axis.XP.rotation(state.headAngle));
            if (state.arm.inverted) {
                matrices.mulPose((Quaternionfc)Axis.ZP.rotation(state.rotate));
                queue.submitCustomGeometry(matrices, state.layer, state.arm::renderClaw);
                matrices.mulPose((Quaternionfc)Axis.ZP.rotation(state.rotate));
            } else {
                queue.submitCustomGeometry(matrices, state.layer, state.arm::renderClaw);
            }
            matrices.pushPose();
            matrices.translate(0.0f, -state.arm.clawOffset, -0.375f);
            queue.submitCustomGeometry(matrices, state.layer, state.arm::renderClawLower);
            matrices.popPose();
            matrices.pushPose();
            matrices.translate(0.0f, state.arm.clawOffset, -0.375f);
            queue.submitCustomGeometry(matrices, state.layer, state.arm::renderClawUpper);
            matrices.popPose();
            if (state.item != null) {
                state.item.render(matrices, queue, state.lightCoords);
            }
        }
    }

    @Override
    protected RenderType getRenderType(ArmBlockEntity be, BlockState state) {
        return be.goggles ? RenderTypes.cutoutMovingBlock() : RenderTypes.solidMovingBlock();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(ArmBlockEntity be, ArmRenderState state) {
        return CachedBuffers.partial(AllPartialModels.ARM_COG, state.blockState);
    }

    public static void transformClawHalf(TransformStack<?> msr, boolean hasItem, boolean isBlockItem, int flip) {
        msr.translate(0.0, (double)((float)(-flip) * (hasItem ? (isBlockItem ? 0.1875f : 0.078125f) : 0.0625f)), -0.375);
    }

    public static void transformHead(TransformStack<?> msr, float headAngle) {
        msr.translate(0.0, 0.0, -0.9375);
        msr.rotateXDegrees(headAngle - 45.0f);
    }

    public static void transformUpperArm(TransformStack<?> msr, float upperArmAngle) {
        msr.translate(0.0, 0.0, -0.875);
        msr.rotateXDegrees(upperArmAngle - 90.0f);
    }

    public static void transformLowerArm(TransformStack<?> msr, float lowerArmAngle) {
        msr.translate(0.0, 0.125, 0.0);
        msr.rotateXDegrees(lowerArmAngle + 135.0f);
    }

    public static void transformBase(TransformStack<?> msr, float baseAngle) {
        msr.translate(0.0, 0.25, 0.0);
        msr.rotateYDegrees(baseAngle);
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public static class ArmRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public float rotate;
        public float baseAngle;
        public float lowerArmAngle;
        public float upperArmAngle;
        public float headAngle;
        public ArmRenderData arm;
        public ArmItemData item;
    }

    public static class ArmItemData {
        public ItemStackRenderState state;
        public float xRot;
        public float offset;
        public float scale;

        public void render(PoseStack matrices, SubmitNodeCollector queue, int light) {
            matrices.mulPose((Quaternionfc)Axis.XP.rotation(this.xRot));
            matrices.translate(0.0f, this.offset, 0.0f);
            matrices.scale(this.scale, this.scale, this.scale);
            this.state.submit(matrices, queue, light, OverlayTexture.NO_OVERLAY, 0);
        }
    }

    public static class ArmRenderData {
        public SuperByteBuffer base;
        public SuperByteBuffer lower;
        public SuperByteBuffer upper;
        public SuperByteBuffer claw;
        public SuperByteBuffer clawUpper;
        public SuperByteBuffer clawLower;
        public int light;
        public int color;
        public boolean inverted;
        public float clawOffset;

        public void renderBase(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.base.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderClaw(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.claw.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderClawLower(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.clawLower.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderClawUpper(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.clawUpper.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderLower(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.lower.light(this.light).color(this.color).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderUpper(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.upper.light(this.light).color(this.color).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

