/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.motor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.kinetics.motor.CreativeMotorBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class MotorValueBox
extends ValueBoxTransform.Sided {
    @Override
    protected Vec3 getSouthLocation() {
        return VecHelper.voxelSpace(8.0, 8.0, 12.5);
    }

    @Override
    public Vec3 getLocalOffset(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)CreativeMotorBlock.FACING);
        return super.getLocalOffset(state).add(Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i()).scale(-0.0625));
    }

    @Override
    public void rotate(BlockState state, PoseStack ms) {
        super.rotate(state, ms);
        Direction facing = (Direction)state.getValue((Property)CreativeMotorBlock.FACING);
        if (facing.getAxis() == Direction.Axis.Y) {
            return;
        }
        if (this.getSide() != Direction.UP) {
            return;
        }
        TransformStack.of(ms).rotateZDegrees(-AngleHelper.horizontalAngle(facing) + 180.0f);
    }

    @Override
    protected boolean isSideActive(BlockState state, Direction direction) {
        Direction facing = (Direction)state.getValue((Property)CreativeMotorBlock.FACING);
        if (facing.getAxis() != Direction.Axis.Y && direction == Direction.DOWN) {
            return false;
        }
        return direction.getAxis() != facing.getAxis();
    }
}

