/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.press;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.zurrtum.create.content.kinetics.press.PressingBehaviour;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MechanicalPressRenderer
extends KineticBlockEntityRenderer<MechanicalPressBlockEntity, MechanicalPressRenderState> {
    public MechanicalPressRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public MechanicalPressRenderState createRenderState() {
        return new MechanicalPressRenderState();
    }

    @Override
    public void extractRenderState(MechanicalPressBlockEntity be, MechanicalPressRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        BlockState blockState = be.getBlockState();
        PressingBehaviour pressingBehaviour = be.getPressingBehaviour();
        state.head = CachedBuffers.partialFacing(AllPartialModels.MECHANICAL_PRESS_HEAD, blockState, (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
        state.offset = -(pressingBehaviour.getRenderedHeadOffset(tickProgress) * pressingBehaviour.mode.headOffset);
    }

    @Override
    protected RenderType getRenderType(MechanicalPressBlockEntity be, BlockState state) {
        return RenderTypes.solidMovingBlock();
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    @Override
    protected BlockState getRenderedBlockState(MechanicalPressBlockEntity be) {
        return MechanicalPressRenderer.shaft(MechanicalPressRenderer.getRotationAxisOf(be));
    }

    public static class MechanicalPressRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        SuperByteBuffer head;
        public float offset;

        @Override
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            this.head.translate(0.0f, this.offset, 0.0f);
            this.head.light(this.lightCoords);
            this.head.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

