/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.press;

import com.mojang.math.Axis;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.ShaftVisual;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.OrientedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.kinetics.press.MechanicalPressBlock;
import com.zurrtum.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.zurrtum.create.content.kinetics.press.PressingBehaviour;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class PressVisual
extends ShaftVisual<MechanicalPressBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance pressHead = this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial(AllPartialModels.MECHANICAL_PRESS_HEAD)).createInstance();

    public PressVisual(VisualizationContext context, MechanicalPressBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        Quaternionf q = Axis.YP.rotationDegrees(AngleHelper.horizontalAngle((Direction)this.blockState.getValue((Property)MechanicalPressBlock.HORIZONTAL_FACING)));
        this.pressHead.rotation((Quaternionfc)q);
        this.transformModels(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.transformModels(ctx.partialTick());
    }

    private void transformModels(float pt) {
        float renderedHeadOffset = this.getRenderedHeadOffset(pt);
        this.pressHead.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
    }

    private float getRenderedHeadOffset(float pt) {
        PressingBehaviour pressingBehaviour = ((MechanicalPressBlockEntity)this.blockEntity).getPressingBehaviour();
        return pressingBehaviour.getRenderedHeadOffset(pt) * pressingBehaviour.mode.headOffset;
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(this.pressHead);
    }

    @Override
    protected void _delete() {
        super._delete();
        this.pressHead.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept(this.pressHead);
    }
}

