/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.saw;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.saw.SawActorVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class SawMovementRenderBehaviour
implements MovementRenderBehaviour {
    @Override
    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new SawActorVisual(visualizationContext, simulationWorld, movementContext);
    }

    @Override
    public MovementRenderState getRenderState(Vec3 camera, Font textRenderer, MovementContext context, VirtualRenderWorld renderWorld, Matrix4f worldMatrix4f) {
        SawMovementRenderState state = new SawMovementRenderState(context.localPos);
        BlockState blockState = context.state;
        Direction facing = (Direction)blockState.getValue((Property)SawBlock.FACING);
        Vec3 facingVec = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i());
        facingVec = (Vec3)context.rotation.apply(facingVec);
        Direction closestToFacing = Direction.getApproximateNearest((double)facingVec.x, (double)facingVec.y, (double)facingVec.z);
        boolean horizontal = closestToFacing.getAxis().isHorizontal();
        boolean backwards = VecHelper.isVecPointingTowards(context.relativeMotion, facing.getOpposite());
        boolean moving = context.getAnimationSpeed() != 0.0f;
        boolean shouldAnimate = context.contraption.stalled && horizontal || !context.contraption.stalled && !backwards && moving;
        state.layer = RenderTypes.cutoutMovingBlock();
        if (SawBlock.isHorizontal(blockState)) {
            state.saw = CachedBuffers.partial(shouldAnimate ? AllPartialModels.SAW_BLADE_HORIZONTAL_ACTIVE : AllPartialModels.SAW_BLADE_HORIZONTAL_INACTIVE, blockState);
        } else {
            state.saw = CachedBuffers.partial(shouldAnimate ? AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE : AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE, blockState);
            if (((Boolean)blockState.getValue((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
                state.zRot = 1.5707964f;
            }
        }
        state.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        state.xRot = (float)Math.PI / 180 * AngleHelper.verticalAngle(facing);
        state.light = LevelRenderer.getLightColor((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        if (!VisualizationManager.supportsVisualization((LevelAccessor)context.world)) {
            Direction.Axis axis = facing.getAxis();
            if (axis.isHorizontal()) {
                state.shaft = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, blockState.getBlock().rotate(blockState, Rotation.CLOCKWISE_180));
            } else {
                boolean alongFirst = (Boolean)blockState.getValue((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
                if (axis == Direction.Axis.X) {
                    axis = alongFirst ? Direction.Axis.Y : Direction.Axis.Z;
                } else if (axis == Direction.Axis.Y) {
                    axis = alongFirst ? Direction.Axis.X : Direction.Axis.Z;
                } else if (axis == Direction.Axis.Z) {
                    axis = alongFirst ? Direction.Axis.X : Direction.Axis.Y;
                }
                state.shaft = CachedBuffers.block(KineticBlockEntityRenderer.KINETIC_BLOCK, KineticBlockEntityRenderer.shaft(axis));
            }
            state.angle = (float)Math.PI / 180 * KineticBlockEntityVisual.rotationOffset(blockState, axis, (Vec3i)context.localPos);
            state.direction = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        }
        return state;
    }

    public static class SawMovementRenderState
    extends MovementRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public Level world;
        public SuperByteBuffer saw;
        public Matrix4f worldMatrix4f;
        public float yRot;
        public float xRot;
        public float zRot;
        public int light;
        public SuperByteBuffer shaft;
        public float angle;
        public Direction direction;

        public SawMovementRenderState(BlockPos pos) {
            super(pos);
        }

        @Override
        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            queue.submitCustomGeometry(matrices, this.layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.saw.center()).rotateY(this.yRot)).rotateX(this.xRot)).rotateZ(this.zRot)).uncenter()).light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            if (this.shaft != null) {
                ((SuperByteBuffer)this.shaft.light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).rotateCentered(this.angle, this.direction)).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}

