/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.simpleRelays;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BracketedKineticBlockEntityRenderer
extends KineticBlockEntityRenderer<BracketedKineticBlockEntity, BracketedKineticRenderState> {
    public BracketedKineticBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public BracketedKineticRenderState createRenderState() {
        return new BracketedKineticRenderState();
    }

    @Override
    public void extractRenderState(BracketedKineticBlockEntity be, BracketedKineticRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        state.large = be.getBlockState().is((Block)AllBlocks.LARGE_COGWHEEL);
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.large) {
            state.shaft = CachedBuffers.partialFacingVertical(AllPartialModels.COGWHEEL_SHAFT, state.blockState, state.direction);
            state.shaftAngle = BracketedKineticBlockEntityRenderer.getAngleForLargeCogShaft(be, state.axis);
        }
    }

    @Override
    protected RenderType getRenderType(BracketedKineticBlockEntity be, BlockState state) {
        return RenderTypes.solidMovingBlock();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(BracketedKineticBlockEntity be, BracketedKineticRenderState state) {
        if (state.large) {
            return CachedBuffers.partialFacingVertical(AllPartialModels.SHAFTLESS_LARGE_COGWHEEL, state.blockState, state.direction);
        }
        return super.getRotatedModel(be, state);
    }

    public static float getAngleForLargeCogShaft(SimpleKineticBlockEntity be, Direction.Axis axis) {
        BlockPos pos = be.getBlockPos();
        float offset = BracketedKineticBlockEntityRenderer.getShaftAngleOffset(axis, pos);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        return (time * be.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
    }

    public static float getShaftAngleOffset(Direction.Axis axis, BlockPos pos) {
        if (KineticBlockEntityVisual.shouldOffset(axis, (Vec3i)pos)) {
            return 22.5f;
        }
        return 0.0f;
    }

    public static class BracketedKineticRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public boolean large;
        public SuperByteBuffer shaft;
        public float shaftAngle;

        @Override
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            if (this.shaft != null) {
                this.shaft.light(this.lightCoords);
                this.shaft.rotateCentered(this.shaftAngle, this.direction);
                this.shaft.color(this.color);
                this.shaft.renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}

