/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.simpleRelays.encased;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EncasedCogRenderer
extends KineticBlockEntityRenderer<SimpleKineticBlockEntity, EncasedCogRenderState> {
    private final boolean large;

    public static EncasedCogRenderer small(BlockEntityRendererProvider.Context context) {
        return new EncasedCogRenderer(context, false);
    }

    public static EncasedCogRenderer large(BlockEntityRendererProvider.Context context) {
        return new EncasedCogRenderer(context, true);
    }

    public EncasedCogRenderer(BlockEntityRendererProvider.Context context, boolean large) {
        super(context);
        this.large = large;
    }

    @Override
    public EncasedCogRenderState createRenderState() {
        return new EncasedCogRenderState();
    }

    @Override
    public void extractRenderState(SimpleKineticBlockEntity be, EncasedCogRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        float f = state.shaftAngle = this.large ? BracketedKineticBlockEntityRenderer.getAngleForLargeCogShaft(be, state.axis) : state.angle;
        if (((Boolean)state.blockState.getValueOrElse((Property)EncasedCogwheelBlock.TOP_SHAFT, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockState blockState = state.blockState;
            state.top = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, blockState, switch (state.axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.Y -> Direction.UP;
                case Direction.Axis.Z -> Direction.SOUTH;
                case Direction.Axis.X -> Direction.EAST;
            });
        }
        if (((Boolean)state.blockState.getValueOrElse((Property)EncasedCogwheelBlock.BOTTOM_SHAFT, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockState blockState = state.blockState;
            state.bottom = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, blockState, switch (state.axis) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.Y -> Direction.DOWN;
                case Direction.Axis.Z -> Direction.NORTH;
                case Direction.Axis.X -> Direction.WEST;
            });
        }
    }

    @Override
    protected RenderType getRenderType(SimpleKineticBlockEntity be, BlockState state) {
        return RenderTypes.solidMovingBlock();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(SimpleKineticBlockEntity be, EncasedCogRenderState state) {
        return CachedBuffers.partialFacingVertical(this.large ? AllPartialModels.SHAFTLESS_LARGE_COGWHEEL : AllPartialModels.SHAFTLESS_COGWHEEL, state.blockState, state.direction);
    }

    public static class EncasedCogRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public float shaftAngle;
        public SuperByteBuffer top;
        public SuperByteBuffer bottom;

        @Override
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            if (this.top != null) {
                this.top.light(this.lightCoords);
                this.top.rotateCentered(this.shaftAngle, this.direction);
                this.top.color(this.color);
                this.top.renderInto(matricesEntry, vertexConsumer);
            }
            if (this.bottom != null) {
                this.bottom.light(this.lightCoords);
                this.bottom.rotateCentered(this.shaftAngle, this.direction);
                this.bottom.color(this.color);
                this.bottom.renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}

