/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.steamEngine;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SteamEngineRenderer
implements BlockEntityRenderer<SteamEngineBlockEntity, SteamEngineRenderState> {
    public SteamEngineRenderer(BlockEntityRendererProvider.Context context) {
    }

    public SteamEngineRenderState createRenderState() {
        return new SteamEngineRenderState();
    }

    public void extractRenderState(SteamEngineBlockEntity be, SteamEngineRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        Float angle = SteamEngineRenderer.getTargetAngle(be);
        if (angle == null) {
            return;
        }
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        state.layer = RenderTypes.solidMovingBlock();
        Direction facing = SteamEngineBlock.getFacing(state.blockState);
        Direction.Axis facingAxis = facing.getAxis();
        Direction.Axis axis = Direction.Axis.Y;
        PoweredShaftBlockEntity shaft = be.getShaft();
        if (shaft != null) {
            axis = KineticBlockEntityRenderer.getRotationAxisOf(shaft);
        }
        boolean roll90 = facingAxis.isHorizontal() && axis == Direction.Axis.Y || facingAxis.isVertical() && axis == Direction.Axis.Z;
        float sinAngle = Mth.sin((double)angle.floatValue());
        float cosAngle = Mth.cos((double)angle.floatValue());
        float piston = 0.375f * sinAngle - Mth.sqrt((float)(Mth.square((float)0.875f) - Mth.square((float)0.375f) * Mth.square((float)cosAngle)));
        float distance = Mth.sqrt((float)Mth.square((float)(piston - 0.375f * sinAngle)));
        state.piston = CachedBuffers.partial(AllPartialModels.ENGINE_PISTON, state.blockState);
        state.linkage = CachedBuffers.partial(AllPartialModels.ENGINE_LINKAGE, state.blockState);
        state.connector = CachedBuffers.partial(AllPartialModels.ENGINE_CONNECTOR, state.blockState);
        state.yRot = AngleHelper.horizontalAngle(facing);
        state.xRot = AngleHelper.verticalAngle(facing) + 90.0f;
        state.roll = roll90 ? -90 : 0;
        state.linkageRotate = (float)Math.acos(distance / 0.875f) * (cosAngle >= 0.0f ? 1.0f : -1.0f);
        state.pistonTranslate = piston + 1.25f;
        state.connectorRotate = -(angle.floatValue() + 1.5707964f);
    }

    public void submit(SteamEngineRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.layer != null) {
            queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
        }
    }

    public int getViewDistance() {
        return 128;
    }

    @Nullable
    public static Float getTargetAngle(SteamEngineBlockEntity be) {
        BlockState blockState = be.getBlockState();
        if (!blockState.is((Block)AllBlocks.STEAM_ENGINE)) {
            return null;
        }
        Direction facing = SteamEngineBlock.getFacing(blockState);
        PoweredShaftBlockEntity shaft = be.getShaft();
        Direction.Axis facingAxis = facing.getAxis();
        if (shaft == null) {
            return null;
        }
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf(shaft);
        float angle = KineticBlockEntityRenderer.getAngleForBe(shaft, shaft.getBlockPos(), axis);
        if (axis == facingAxis) {
            return null;
        }
        if (axis.isHorizontal() && facingAxis == Direction.Axis.X ^ facing.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            angle *= -1.0f;
        }
        if (axis == Direction.Axis.X && facing == Direction.DOWN) {
            angle *= -1.0f;
        }
        return Float.valueOf(angle);
    }

    public static class SteamEngineRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer piston;
        public SuperByteBuffer linkage;
        public SuperByteBuffer connector;
        public float yRot;
        public float xRot;
        public int roll;
        public float linkageRotate;
        public float pistonTranslate;
        public float connectorRotate;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.piston.center()).rotateYDegrees(this.yRot)).rotateXDegrees(this.xRot)).rotateYDegrees(this.roll)).uncenter()).translate(0.0f, this.pistonTranslate, 0.0f)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.linkage.center()).rotateYDegrees(this.yRot)).rotateXDegrees(this.xRot)).rotateYDegrees(this.roll)).translate(0.0f, 1.0f, 0.0f)).uncenter()).translate(0.0f, this.pistonTranslate, 0.0f)).translate(0.0f, 0.25f, 0.5f)).rotateX(this.linkageRotate)).translate(0.0f, -0.25f, -0.5f)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.connector.center()).rotateYDegrees(this.yRot)).rotateXDegrees(this.xRot)).rotateYDegrees(this.roll)).uncenter()).translate(0.0f, 2.0f, 0.0f)).center()).rotateX(this.connectorRotate)).uncenter()).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

