/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstancerProvider;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import java.util.function.Consumer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class FlapStuffs {
    public static final int FLAP_COUNT = 4;
    public static final float X_OFFSET = 0.0046875f;
    public static final float SEGMENT_STEP = -0.190625f;
    public static final Vec3 TUNNEL_PIVOT = VecHelper.voxelSpace(0.0, 10.0, 1.0);
    public static final Vec3 FUNNEL_PIVOT = VecHelper.voxelSpace(0.0, 10.0, 9.5);

    public static FlapsRenderState getFlapsRenderState(SuperByteBuffer flapBuffer, Vec3 pivot, Direction funnelFacing, float flapness, float zOffset, int light) {
        float horizontalAngle = (float)Math.PI / 180 * AngleHelper.horizontalAngle(funnelFacing.getOpposite());
        float[] angles = new float[4];
        for (int segment = 0; segment < 4; ++segment) {
            angles[segment] = (float)Math.PI / 180 * FlapStuffs.flapAngle(flapness, segment);
        }
        PoseStack.Pose[] entries = new PoseStack.Pose[4];
        return new FlapsRenderState(flapBuffer, pivot, zOffset, light, horizontalAngle, angles, entries);
    }

    public static float flapAngle(float flapness, int segment) {
        float intensity = segment == 3 ? 1.5f : (float)(segment + 1);
        float abs = Math.abs(flapness);
        float flapAngle = Mth.sin((double)((float)((double)(1.0f - abs) * Math.PI * (double)intensity))) * 30.0f * flapness;
        if (flapness < 0.0f) {
            flapAngle *= 0.5f;
        }
        return flapAngle;
    }

    public static Matrix4f commonTransform(BlockPos visualPosition, Direction side, float baseZOffset) {
        float horizontalAngle = AngleHelper.horizontalAngle(side.getOpposite());
        return new Matrix4f().translate((float)visualPosition.getX(), (float)visualPosition.getY(), (float)visualPosition.getZ()).translate(0.5f, 0.5f, 0.5f).rotateY((float)Math.PI / 180 * horizontalAngle).translate(-0.5f, -0.5f, -0.5f).translate(0.0046875f, 0.0f, baseZOffset);
    }

    public record FlapsRenderState(SuperByteBuffer model, Vec3 pivot, float zOffset, int light, float horizontalAngle, float[] angles, PoseStack.Pose[] entries) implements SubmitNodeCollector.CustomGeometryRenderer
    {
        public void render(RenderType layer, PoseStack matrices, SubmitNodeCollector queue) {
            matrices.pushPose();
            matrices.translate(0.5f, 0.5f, 0.5f);
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.horizontalAngle));
            matrices.translate(-0.5f, -0.5f, -0.5f);
            matrices.translate(0.0046875f, 0.0f, this.zOffset);
            for (int segment = 0; segment < 4; ++segment) {
                matrices.pushPose();
                matrices.translate(this.pivot.x, this.pivot.y, this.pivot.z);
                matrices.mulPose((Quaternionfc)Axis.XP.rotation(this.angles[segment]));
                matrices.translate(-this.pivot.x, -this.pivot.y, -this.pivot.z);
                this.entries[segment] = matrices.last().copy();
                matrices.popPose();
                matrices.translate(-0.190625f, 0.0f, 0.0f);
            }
            matrices.popPose();
            queue.submitCustomGeometry(matrices, layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            for (int segment = 0; segment < 4; ++segment) {
                this.model.light(this.light).renderInto(this.entries[segment], vertexConsumer);
            }
        }
    }

    public static class Visual {
        private final TransformedInstance[] flaps;
        private final Matrix4f commonTransform = new Matrix4f();
        private final Vec3 pivot;

        public Visual(InstancerProvider instancerProvider, Matrix4fc commonTransform, Vec3 pivot, Model flapModel) {
            this.pivot = pivot;
            this.commonTransform.set(commonTransform).translate((float)pivot.x, (float)pivot.y, (float)pivot.z);
            this.flaps = new TransformedInstance[4];
            instancerProvider.instancer(InstanceTypes.TRANSFORMED, flapModel).createInstances(this.flaps);
        }

        public void update(float f) {
            for (int segment = 0; segment < 4; ++segment) {
                TransformedInstance flap = this.flaps[segment];
                ((TransformedInstance)((TransformedInstance)flap.setTransform((Matrix4fc)this.commonTransform).rotateXDegrees(FlapStuffs.flapAngle(f, segment))).translateBack(this.pivot)).translate((float)segment * -0.190625f, 0.0f, 0.0f).setChanged();
            }
        }

        public void delete() {
            for (TransformedInstance flap : this.flaps) {
                flap.delete();
            }
        }

        public void updateLight(int light) {
            for (TransformedInstance flap : this.flaps) {
                flap.light(light).setChanged();
            }
        }

        public void collectCrumblingInstances(Consumer<Instance> consumer) {
            for (TransformedInstance flap : this.flaps) {
                consumer.accept(flap);
            }
        }
    }
}

