/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.box;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class PackageRenderer
extends EntityRenderer<PackageEntity, PackageState> {
    public PackageRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.shadowRadius = 0.5f;
    }

    public PackageState createRenderState() {
        return new PackageState();
    }

    public void extractRenderState(PackageEntity entity, PackageState state, float tickProgress) {
        PartialModel model;
        super.extractRenderState((Entity)entity, (EntityRenderState)state, tickProgress);
        if (VisualizationManager.supportsVisualization((LevelAccessor)entity.level())) {
            return;
        }
        ItemStack box = entity.box;
        if (box.isEmpty() || !PackageItem.isPackage(box)) {
            box = AllItems.CARDBOARD_BLOCK.getDefaultInstance();
        }
        if ((model = AllPartialModels.PACKAGES.get(BuiltInRegistries.ITEM.getKey((Object)box.getItem()))) == null) {
            return;
        }
        int id = entity.getId();
        float yaw = entity.getYRot(tickProgress);
        state.box = PackageRenderer.getBoxRenderState(id, yaw, state.lightCoords, model);
    }

    public void submit(PackageState state, PoseStack ms, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.box != null) {
            state.box.render(ms, queue);
        }
        super.submit((EntityRenderState)state, ms, queue, cameraState);
    }

    public static BoxRenderState getBoxRenderState(int id, float yaw, int light, PartialModel model) {
        BoxRenderState state = new BoxRenderState();
        state.layer = RenderTypes.solidMovingBlock();
        state.model = CachedBuffers.partial(model, Blocks.AIR.defaultBlockState());
        state.angle = -AngleHelper.rad(yaw + 90.0f);
        state.nudge = id;
        state.light = light;
        return state;
    }

    public static class PackageState
    extends EntityRenderState {
        public BoxRenderState box;
    }

    public static class BoxRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer model;
        public float angle;
        public int nudge;
        public int light;

        public void render(PoseStack ms, SubmitNodeCollector queue) {
            queue.submitCustomGeometry(ms, this.layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.model.translate(-0.5, 0.0, -0.5)).rotateCentered(this.angle, Direction.UP)).light(this.light).nudge(this.nudge)).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

