/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.depot;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.content.logistics.depot.EjectorItemEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ItemClusterRenderState;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class EjectorItemEntityRenderer
extends ItemEntityRenderer {
    public EjectorItemEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ItemEntityRenderState createRenderState() {
        return new RenderState();
    }

    protected float getShadowRadius(ItemEntityRenderState state) {
        if (((RenderState)state).alive) {
            return super.getShadowRadius((EntityRenderState)state);
        }
        return 0.0f;
    }

    public void extractRenderState(ItemEntity itemEntity, ItemEntityRenderState itemEntityRenderState, float f) {
        super.extractRenderState(itemEntity, itemEntityRenderState, f);
        EjectorItemEntity entity = (EjectorItemEntity)itemEntity;
        RenderState state = (RenderState)itemEntityRenderState;
        state.alive = entity.isAlive();
        if (state.alive) {
            itemEntityRenderState.ageInTicks = entity.data.initAge == -1 ? 0.0f : ((float)(entity.age - entity.data.initAge) + f) / 10.0f;
        } else {
            state.rotateY = entity.data.rotateY;
            float time = (float)entity.progress + f;
            state.rotateX = (float)Math.PI / 180 * time * 40.0f;
            state.location = entity.getLaunchedItemLocation(time).subtract(entity.position());
        }
        itemEntityRenderState.bobOffset = entity.data.animateOffset;
    }

    public AABB getBoundingBoxForCulling(ItemEntity itemEntity) {
        EjectorItemEntity entity = (EjectorItemEntity)itemEntity;
        if (entity.isAlive()) {
            return entity.getBoundingBox();
        }
        return entity.data.renderBox;
    }

    public void submit(ItemEntityRenderState itemEntityRenderState, PoseStack matrixStack, SubmitNodeCollector queue, CameraRenderState cameraRenderState) {
        if (!itemEntityRenderState.item.isEmpty()) {
            RenderState state = (RenderState)itemEntityRenderState;
            AABB box = state.item.getModelBoundingBox();
            matrixStack.pushPose();
            float f = -((float)box.minY) + 0.0625f;
            matrixStack.translate(0.0f, state.bobOffset + f, -0.0625f);
            if (!state.alive) {
                matrixStack.translate(state.location);
                matrixStack.translate(0.0f, 0.25f, 0.0f);
                if (state.rotateY != 0.0f) {
                    matrixStack.mulPose((Quaternionfc)Axis.YP.rotation(state.rotateY));
                }
                matrixStack.mulPose((Quaternionfc)Axis.XP.rotation(state.rotateX));
                matrixStack.translate(0.0f, -0.25f, 0.0f);
            } else if (state.ageInTicks > 0.0f) {
                float g = Mth.sin((double)state.ageInTicks) * 0.1f + 0.1f;
                matrixStack.translate(0.0f, g, 0.0f);
                matrixStack.mulPose((Quaternionfc)Axis.YP.rotation(state.ageInTicks / 2.0f));
            }
            EjectorItemEntityRenderer.submitMultipleFromCount((PoseStack)matrixStack, (SubmitNodeCollector)queue, (int)state.lightCoords, (ItemClusterRenderState)state, (RandomSource)this.random, (AABB)box);
            matrixStack.popPose();
            if (state.alive) {
                if (state.leashStates != null) {
                    for (EntityRenderState.LeashState leashData : state.leashStates) {
                        queue.submitLeash(matrixStack, leashData);
                    }
                }
                this.submitNameTag((EntityRenderState)state, matrixStack, queue, cameraRenderState);
            }
        }
    }

    public static class RenderState
    extends ItemEntityRenderState {
        public boolean alive;
        public float rotateY;
        public float rotateX;
        public Vec3 location;
    }
}

