/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.depot;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.base.ShaftRenderer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer;
import com.zurrtum.create.client.flywheel.lib.transform.Rotate;
import com.zurrtum.create.client.flywheel.lib.transform.Translate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.content.logistics.depot.EjectorBlock;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import java.util.List;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class EjectorRenderer
extends ShaftRenderer<EjectorBlockEntity, EjectorRenderState> {
    static final Vec3 pivot = VecHelper.voxelSpace(0.0, 11.25, 0.75);
    protected final ItemModelResolver itemModelManager;

    public EjectorRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.itemModelManager = context.itemModelResolver();
    }

    @Override
    public EjectorRenderState createRenderState() {
        return new EjectorRenderState();
    }

    @Override
    public void extractRenderState(EjectorBlockEntity be, EjectorRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        DepotBehaviour behaviour;
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        BlockState blockState = be.getBlockState();
        if (!state.support) {
            state.top = CachedBuffers.partial(AllPartialModels.EJECTOR_TOP, blockState);
            state.lidAngle = (float)Math.PI / 180 * (be.getLidProgress(tickProgress) * -70.0f);
            state.yRot = (float)Math.PI / 180 * (180.0f + AngleHelper.horizontalAngle((Direction)blockState.getValue((Property)EjectorBlock.HORIZONTAL_FACING)));
        }
        if ((behaviour = be.getBehaviour(DepotBehaviour.TYPE)) == null || behaviour.isEmpty()) {
            return;
        }
        Level world = be.getLevel();
        state.incoming = DepotRenderer.createIncomingStateList(behaviour, this.itemModelManager, tickProgress, world);
        state.outputs = DepotRenderer.createOutputStateList(behaviour, this.itemModelManager, world);
        if (state.support && (state.incoming != null || state.outputs != null)) {
            state.blockPos = be.getBlockPos();
            state.blockEntityType = be.getType();
            state.lightCoords = world != null ? LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos) : 0xF000F0;
            state.lidAngle = (float)Math.PI / 180 * (be.getLidProgress(tickProgress) * -70.0f);
            state.yRot = (float)Math.PI / 180 * (180.0f + AngleHelper.horizontalAngle((Direction)blockState.getValue((Property)EjectorBlock.HORIZONTAL_FACING)));
        }
    }

    @Override
    public void submit(EjectorRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.incoming != null || state.outputs != null) {
            matrices.translate(0.5f, 0.5f, 0.5f);
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(state.yRot));
            matrices.translate(-0.5f, -0.5f, -0.5f);
            matrices.translate(EjectorRenderer.pivot.x, EjectorRenderer.pivot.y, EjectorRenderer.pivot.z);
            matrices.mulPose((Quaternionfc)Axis.XP.rotation(state.lidAngle));
            matrices.translate(-EjectorRenderer.pivot.x, -EjectorRenderer.pivot.y, -EjectorRenderer.pivot.z);
            matrices.translate(0.5f, 0.5f, 0.5f);
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(-state.yRot));
            matrices.translate(-0.5f, -0.5f, -0.5f);
            DepotRenderer.renderItemsOf(state.incoming, state.outputs, state.blockPos, cameraState.pos, queue, matrices, state.lightCoords);
        }
    }

    @Override
    protected RenderType getRenderType(EjectorBlockEntity be, BlockState state) {
        return RenderTypes.solidMovingBlock();
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    static <T extends Translate<T> & Rotate<T>> void applyLidAngle(KineticBlockEntity be, float angle, T tr) {
        ((Translate)((Rotate)((Translate)((Rotate)tr.center()).rotateYDegrees(180.0f + AngleHelper.horizontalAngle((Direction)be.getBlockState().getValue((Property)EjectorBlock.HORIZONTAL_FACING)))).uncenter().translate(pivot)).rotateXDegrees(-angle)).translateBack(pivot);
    }

    public static class EjectorRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public SuperByteBuffer top;
        public float lidAngle;
        public float yRot;
        public DepotRenderer.DepotItemState[] incoming;
        public List<DepotRenderer.DepotOutputItemState> outputs;

        @Override
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)this.top.center()).rotateY(this.yRot)).uncenter();
            ((SuperByteBuffer)((SuperByteBuffer)this.top.translate(pivot)).rotateX(this.lidAngle)).translateBack(pivot);
            this.top.light(this.lightCoords);
            this.top.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

