/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.filter;

import com.zurrtum.create.client.content.logistics.AddressEditBox;
import com.zurrtum.create.client.content.logistics.filter.AbstractFilterScreen;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.content.logistics.box.PackageStyles;
import com.zurrtum.create.content.logistics.filter.PackageFilterMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.FilterScreenPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class PackageFilterScreen
extends AbstractFilterScreen<PackageFilterMenu> {
    private AddressEditBox addressBox;
    private boolean deferFocus;

    public PackageFilterScreen(PackageFilterMenu menu, Inventory inv, Component title) {
        super(menu, inv, title, AllGuiTextures.PACKAGE_FILTER);
    }

    public static PackageFilterScreen create(Minecraft mc, MenuType<ItemStack> type, int syncId, Inventory inventory, Component title, RegistryFriendlyByteBuf extraData) {
        return (PackageFilterScreen)((Object)type.create(PackageFilterScreen::new, syncId, inventory, title, PackageFilterScreen.getStack(extraData)));
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        if (this.deferFocus) {
            this.deferFocus = false;
            this.setFocused((GuiEventListener)this.addressBox);
        }
        this.addressBox.tick();
    }

    @Override
    protected void init() {
        this.setWindowOffset(-11, 7);
        super.init();
        this.addressBox = new AddressEditBox((Screen)this, this.font, this.leftPos + 44, this.topPos + 28, 129, 9, false);
        this.addressBox.setTextColor(-1);
        this.addressBox.setValue(((PackageFilterMenu)this.menu).address);
        this.addressBox.setResponder(this::onAddressEdited);
        this.addRenderableWidget((GuiEventListener)this.addressBox);
        this.setFocused((GuiEventListener)this.addressBox);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.renderItem(PackageStyles.getDefaultBox(), this.leftPos + 16, this.topPos + 23);
    }

    public void onAddressEdited(String s) {
        ((PackageFilterMenu)this.menu).address = s;
        CompoundTag tag = new CompoundTag();
        tag.putString("Address", s);
        this.minecraft.player.connection.send((Packet)new FilterScreenPacket(FilterScreenPacket.Option.UPDATE_ADDRESS, tag));
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.addressBox.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean keyPressed(KeyEvent input) {
        if (input.key() == 257) {
            this.setFocused(null);
        }
        return super.keyPressed(input);
    }

    @Override
    protected void contentsCleared() {
        this.addressBox.setValue("");
        this.deferFocus = true;
    }

    @Override
    protected boolean isButtonEnabled(IconButton button) {
        return false;
    }

    @Override
    protected int getTitleColor() {
        return -12764088;
    }
}

