/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.funnel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.logistics.funnel.AbstractFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FunnelFilterSlotPositioning
extends ValueBoxTransform.Sided {
    @Override
    public Vec3 getLocalOffset(BlockState state) {
        Direction side = this.getSide();
        float horizontalAngle = AngleHelper.horizontalAngle(side);
        Direction funnelFacing = FunnelBlock.getFunnelFacing(state);
        float stateAngle = AngleHelper.horizontalAngle(funnelFacing);
        if (state.getBlock() instanceof BeltFunnelBlock) {
            switch ((BeltFunnelBlock.Shape)((Object)state.getValue(BeltFunnelBlock.SHAPE))) {
                case EXTENDED: {
                    return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, 15.5, 13.0), stateAngle, Direction.Axis.Y);
                }
                case PULLING: 
                case PUSHING: {
                    return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, 12.0, 8.675f), horizontalAngle, Direction.Axis.Y);
                }
            }
            return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, 13.0, 7.5), horizontalAngle, Direction.Axis.Y);
        }
        if (!funnelFacing.getAxis().isHorizontal()) {
            Vec3 southLocation = VecHelper.voxelSpace(8.0, funnelFacing == Direction.DOWN ? 14.0 : 2.0, 15.5);
            return VecHelper.rotateCentered(southLocation, horizontalAngle, Direction.Axis.Y);
        }
        return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, 12.2, 8.55f), horizontalAngle, Direction.Axis.Y);
    }

    @Override
    public void rotate(BlockState state, PoseStack ms) {
        Direction facing = FunnelBlock.getFunnelFacing(state);
        if (facing.getAxis().isVertical()) {
            super.rotate(state, ms);
            return;
        }
        boolean isBeltFunnel = state.getBlock() instanceof BeltFunnelBlock;
        if (isBeltFunnel && state.getValue(BeltFunnelBlock.SHAPE) != BeltFunnelBlock.Shape.EXTENDED) {
            BeltFunnelBlock.Shape shape = (BeltFunnelBlock.Shape)((Object)state.getValue(BeltFunnelBlock.SHAPE));
            super.rotate(state, ms);
            if (shape == BeltFunnelBlock.Shape.PULLING || shape == BeltFunnelBlock.Shape.PUSHING) {
                TransformStack.of(ms).rotateXDegrees(-22.5f);
            }
            return;
        }
        if (state.getBlock() instanceof FunnelBlock) {
            super.rotate(state, ms);
            TransformStack.of(ms).rotateXDegrees(-22.5f);
            return;
        }
        float yRot = AngleHelper.horizontalAngle(AbstractFunnelBlock.getFunnelFacing(state)) + (float)(facing == Direction.DOWN ? 180 : 0);
        ((PoseTransformStack)TransformStack.of(ms).rotateYDegrees(yRot)).rotateXDegrees(facing == Direction.DOWN ? -90.0f : 90.0f);
    }

    @Override
    protected boolean isSideActive(BlockState state, Direction direction) {
        Direction facing = FunnelBlock.getFunnelFacing(state);
        if (facing == null) {
            return false;
        }
        if (facing.getAxis().isVertical()) {
            return direction.getAxis().isHorizontal();
        }
        if (state.getBlock() instanceof BeltFunnelBlock && state.getValue(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED) {
            return direction == Direction.UP;
        }
        return direction == facing;
    }

    @Override
    protected Vec3 getSouthLocation() {
        return Vec3.ZERO;
    }
}

