/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.packagePort;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.trains.station.NoShadowFontWrapper;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.content.logistics.packagePort.PackagePortMenu;
import com.zurrtum.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.PackagePortConfigurationPacket;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PackagePortScreen
extends AbstractSimiContainerScreen<PackagePortMenu> {
    private final boolean frogMode;
    private final AllGuiTextures background;
    private EditBox addressBox;
    private IconButton confirmButton;
    private IconButton dontAcceptPackages;
    private IconButton acceptPackages;
    private ElementWidget renderedItem;
    private final ItemStack icon;
    private List<Rect2i> extraAreas = Collections.emptyList();

    public PackagePortScreen(PackagePortMenu container, Inventory inv, Component title) {
        super(container, inv, title);
        this.background = AllGuiTextures.FROGPORT_BG;
        this.frogMode = container.contentHolder instanceof FrogportBlockEntity;
        this.icon = new ItemStack((ItemLike)((PackagePortBlockEntity)container.contentHolder).getBlockState().getBlock().asItem());
    }

    public static PackagePortScreen create(Minecraft mc, MenuType<PackagePortBlockEntity> type, int syncId, Inventory inventory, Component title, RegistryFriendlyByteBuf extraData) {
        return (PackagePortScreen)((Object)type.create(PackagePortScreen::new, syncId, inventory, title, (PackagePortBlockEntity)PackagePortScreen.getBlockEntity(mc, extraData)));
    }

    @Override
    protected void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight() + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        super.init();
        this.clearWidgets();
        Consumer<String> onTextChanged = s -> this.addressBox.setX(this.nameBoxX((String)s, this.addressBox));
        this.addressBox = new EditBox((Font)new NoShadowFontWrapper(this.font), this.leftPos + 23, this.topPos - 11, this.background.getWidth() - 20, 10, (Component)Component.empty());
        this.addressBox.setBordered(false);
        this.addressBox.setMaxLength(25);
        this.addressBox.setTextColor(-12764088);
        this.addressBox.setValue(((PackagePortBlockEntity)((PackagePortMenu)this.menu).contentHolder).addressFilter);
        this.addressBox.setFocused(false);
        this.addressBox.mouseClicked(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(0, 0)), false);
        this.addressBox.setResponder(onTextChanged);
        this.addressBox.setX(this.nameBoxX(this.addressBox.getValue(), this.addressBox));
        this.addRenderableWidget((GuiEventListener)this.addressBox);
        this.confirmButton = new IconButton(this.leftPos + this.background.getWidth() - 33, this.topPos + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.minecraft.player.closeContainer());
        this.addRenderableWidget(this.confirmButton);
        this.acceptPackages = new IconButton(this.leftPos + 37, this.topPos + this.background.getHeight() - 24, AllIcons.I_SEND_AND_RECEIVE);
        this.acceptPackages.withCallback(() -> {
            this.acceptPackages.green = true;
            this.dontAcceptPackages.green = false;
        });
        this.acceptPackages.green = ((PackagePortBlockEntity)((PackagePortMenu)this.menu).contentHolder).acceptsPackages;
        this.acceptPackages.setToolTip((Component)CreateLang.translateDirect("gui.package_port.send_and_receive", new Object[0]));
        this.addRenderableWidget(this.acceptPackages);
        this.dontAcceptPackages = new IconButton(this.leftPos + 37 + 18, this.topPos + this.background.getHeight() - 24, AllIcons.I_SEND_ONLY);
        this.dontAcceptPackages.withCallback(() -> {
            this.acceptPackages.green = false;
            this.dontAcceptPackages.green = true;
        });
        this.dontAcceptPackages.green = !((PackagePortBlockEntity)((PackagePortMenu)this.menu).contentHolder).acceptsPackages;
        this.dontAcceptPackages.setToolTip((Component)CreateLang.translateDirect("gui.package_port.send_only", new Object[0]));
        this.addRenderableWidget(this.dontAcceptPackages);
        this.containerTick();
        this.extraAreas = ImmutableList.of((Object)new Rect2i(this.leftPos + this.background.getWidth(), this.topPos + this.background.getHeight() - 50, 70, 60));
        this.renderedItem = new ElementWidget(this.leftPos + this.background.getWidth() + 6, this.topPos + this.background.getHeight() - 56).showingElement(GuiGameElement.of(this.icon).scale(4.0f));
        this.addRenderableWidget(this.renderedItem);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
    }

    private int nameBoxX(String s, EditBox nameBox) {
        return this.leftPos + this.background.getWidth() / 2 - (Math.min(this.font.width(s), nameBox.getWidth()) + 10) / 2;
    }

    @Override
    protected void containerTick() {
        this.acceptPackages.visible = ((PackagePortBlockEntity)((PackagePortMenu)this.menu).contentHolder).target != null;
        this.dontAcceptPackages.visible = ((PackagePortBlockEntity)((PackagePortMenu)this.menu).contentHolder).target != null;
        super.containerTick();
    }

    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        AllGuiTextures header = this.frogMode ? AllGuiTextures.FROGPORT_HEADER : AllGuiTextures.POSTBOX_HEADER;
        int x = this.leftPos;
        int y = this.topPos;
        header.render(graphics, x, y - header.getHeight());
        this.background.render(graphics, x, y);
        String text = this.addressBox.getValue();
        if (!this.addressBox.isFocused()) {
            if (text.isEmpty()) {
                text = this.icon.getHoverName().getString();
                graphics.drawString(this.font, text, this.nameBoxX(text, this.addressBox), y - 11, -12764088, false);
            }
            AllGuiTextures.FROGPORT_EDIT_NAME.render(graphics, this.nameBoxX(text, this.addressBox) + this.font.width(text) + 5, y - 14);
        }
        int invX = x + 30;
        int invY = y + 8 + this.imageHeight - AllGuiTextures.PLAYER_INVENTORY.getHeight();
        this.renderPlayerInventory(graphics, invX, invY);
        if (((PackagePortBlockEntity)((PackagePortMenu)this.menu).contentHolder).target == null) {
            return;
        }
        AllGuiTextures.FROGPORT_SLOT.render(graphics, x += 13, y += 58);
        graphics.renderItem(((PackagePortBlockEntity)((PackagePortMenu)this.menu).contentHolder).target.getIcon(), x + 1, y + 1);
        if (this.addressBox.isHovered()) {
            graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate("gui.package_port.catch_packages", new Object[0]).color(AbstractSimiWidget.HEADER_RGB).component(), CreateLang.translate("gui.package_port.catch_packages_empty", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.package_port.catch_packages_wildcard", new Object[0]).style(ChatFormatting.GRAY).component()), pMouseX, pMouseY);
        }
    }

    @Override
    public boolean keyPressed(KeyEvent input) {
        boolean hitEnter;
        int pKeyCode = input.key();
        boolean bl = hitEnter = this.getFocused() instanceof EditBox && (pKeyCode == 257 || pKeyCode == 335);
        if (hitEnter && this.addressBox.isFocused()) {
            this.addressBox.setFocused(false);
            return true;
        }
        return super.keyPressed(input);
    }

    public void removed() {
        this.minecraft.player.connection.send((Packet)new PackagePortConfigurationPacket(((PackagePortBlockEntity)((PackagePortMenu)this.menu).contentHolder).getBlockPos(), this.addressBox.getValue(), this.acceptPackages.green));
        super.removed();
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

