/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.packagePort.frogport;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FrogportRenderer
implements BlockEntityRenderer<FrogportBlockEntity, FrogportRenderState> {
    public FrogportRenderer(BlockEntityRendererProvider.Context context) {
    }

    public FrogportRenderState createRenderState() {
        return new FrogportRenderState();
    }

    public void extractRenderState(FrogportBlockEntity be, FrogportRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        float headPitchModifier;
        float tongueLength;
        Vec3 diff;
        boolean name;
        Level world = be.getLevel();
        String filter = be.addressFilter;
        boolean support = VisualizationManager.supportsVisualization((LevelAccessor)world);
        boolean bl = name = filter != null && !filter.isBlank();
        if (support && !name) {
            return;
        }
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        if (name) {
            state.name = SmartBlockEntityRenderer.getNameplateRenderState(be, state.blockPos, cameraPos, (Component)Component.literal((String)filter), 1.0f, state.lightCoords);
        }
        if (support) {
            return;
        }
        FrogportRenderData data = state.data = new FrogportRenderData();
        data.layer = RenderTypes.cutoutMovingBlock();
        data.body = CachedBuffers.partial(AllPartialModels.FROGPORT_BODY, state.blockState);
        boolean animating = be.isAnimationInProgress();
        boolean depositing = be.currentlyDepositing;
        if (be.target != null) {
            diff = be.target.getExactTargetLocation(be, (LevelAccessor)world, state.blockPos).subtract(0.0, animating && depositing ? 0.0 : 0.75, 0.0).subtract(Vec3.atCenterOf((Vec3i)state.blockPos));
            float tonguePitch = (float)Mth.atan2((double)diff.y, (double)(diff.multiply(1.0, 0.0, 1.0).length() + 0.1875)) * 57.295776f;
            tongueLength = Math.max((float)diff.length(), 1.0f);
            headPitch = Mth.clamp((float)(tonguePitch * 2.0f), (float)60.0f, (float)100.0f);
            data.tonguePitch = (float)Math.PI / 180 * tonguePitch;
        } else {
            diff = Vec3.ZERO;
            tongueLength = 0.0f;
            headPitch = 80.0f;
        }
        if (animating) {
            Identifier key;
            float scale;
            float itemDistance;
            float progress = be.animationProgress.getValue(tickProgress);
            if (depositing) {
                double modifier = Math.max(0.0, 1.0 - Math.pow(((double)progress - 0.25) * 4.0 - 1.0, 4.0));
                itemDistance = (float)Math.max((double)tongueLength * Math.min(1.0, ((double)progress - 0.25) * 3.0), (double)tongueLength * modifier);
                tongueLength *= (float)Math.max(0.0, 1.0 - Math.pow(((double)progress * 1.25 - 0.25) * 4.0 - 1.0, 4.0));
                headPitchModifier = (float)Math.max(0.0, 1.0 - Math.pow((double)progress * 1.25 * 2.0 - 1.0, 4.0));
                scale = 0.25f + progress * 3.0f / 4.0f;
            } else {
                headPitchModifier = 1.0f - (float)Math.min(1.0, Math.max(0.0, (Math.pow((double)progress * 1.5, 2.0) - 0.5) * 2.0));
                scale = (float)Math.max(0.5, 1.0 - (double)progress * 1.25);
                itemDistance = tongueLength *= (float)Math.pow(Math.max(0.0, 1.0 - (double)progress * 1.25), 5.0);
            }
            if (be.animatedPackage != null && (double)scale >= 0.45 && (key = BuiltInRegistries.ITEM.getKey((Object)be.animatedPackage.getItem())) != BuiltInRegistries.ITEM.getDefaultKey()) {
                data.box = CachedBuffers.partial(AllPartialModels.PACKAGES.get(key), state.blockState);
                data.boxOffset = diff.normalize().scale((double)itemDistance).subtract(0.0, depositing ? 0.75 : 0.0, 0.0);
                data.boxScale = scale;
                if (depositing) {
                    data.rig = CachedBuffers.partial(AllPartialModels.PACKAGE_RIGGING.get(key), state.blockState);
                }
            }
        } else {
            tongueLength = 0.0f;
            float anticipation = be.anticipationProgress.getValue(tickProgress);
            headPitchModifier = anticipation > 0.0f ? (float)Math.max(0.0, 1.0 - Math.pow((double)anticipation * 1.25 * 2.0 - 1.0, 4.0)) : 0.0f;
        }
        float openProgress = be.manualOpenAnimationProgress.getValue(tickProgress);
        data.headPitch = (float)Math.PI / 180 * Math.max(headPitch *= headPitchModifier, openProgress * 60.0f);
        tongueLength = Math.max(tongueLength, openProgress * 0.25f);
        data.yRot = (float)Math.PI / 180 * be.getYaw();
        data.head = CachedBuffers.partial(be.goggles ? AllPartialModels.FROGPORT_HEAD_GOGGLES : AllPartialModels.FROGPORT_HEAD, state.blockState);
        data.tongue = CachedBuffers.partial(AllPartialModels.FROGPORT_TONGUE, state.blockState);
        data.tongueScale = tongueLength / 0.4375f;
        data.light = state.lightCoords;
    }

    public void submit(FrogportRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.name != null) {
            state.name.render(matrices, queue, cameraState);
        }
        if (state.data != null) {
            queue.submitCustomGeometry(matrices, state.data.layer, (SubmitNodeCollector.CustomGeometryRenderer)state.data);
        }
    }

    public static class FrogportRenderState
    extends BlockEntityRenderState {
        public SmartBlockEntityRenderer.NameplateRenderState name;
        public FrogportRenderData data;
    }

    public static class FrogportRenderData
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer body;
        public float tonguePitch;
        public float yRot;
        public SuperByteBuffer head;
        public float headPitch;
        public SuperByteBuffer tongue;
        public float tongueScale;
        public SuperByteBuffer rig;
        public SuperByteBuffer box;
        public Vec3 boxOffset;
        public float boxScale;
        public int light;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.body.center()).rotateY(this.yRot)).uncenter()).light(this.light).overlay(OverlayTexture.NO_OVERLAY).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.head.center()).rotateY(this.yRot)).uncenter()).translate(0.5f, 0.625f, 0.6875f)).rotateX(this.headPitch)).translate(-0.5f, -0.625f, -0.6875f)).light(this.light).overlay(OverlayTexture.NO_OVERLAY).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.tongue.center()).rotateY(this.yRot)).uncenter()).translate(0.5f, 0.625f, 0.6875f)).rotateX(this.tonguePitch)).scale(1.0f, 1.0f, this.tongueScale)).translate(-0.5f, -0.625f, -0.6875f)).light(this.light).overlay(OverlayTexture.NO_OVERLAY).renderInto(matricesEntry, vertexConsumer);
            if (this.box != null) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.box.translate(0.0f, 0.1875f, 0.0f)).translate(this.boxOffset)).center()).scale(this.boxScale)).uncenter()).light(this.light).overlay(OverlayTexture.NO_OVERLAY).renderInto(matricesEntry, vertexConsumer);
            }
            if (this.rig != null) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.rig.translate(0.0f, 0.1875f, 0.0f)).translate(this.boxOffset)).center()).scale(this.boxScale)).uncenter()).light(this.light).overlay(OverlayTexture.NO_OVERLAY).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}

