/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.packagePort.postbox;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.logistics.packagePort.postbox.PostboxBlock;
import com.zurrtum.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PostboxRenderer
implements BlockEntityRenderer<PostboxBlockEntity, PostboxRenderState> {
    public PostboxRenderer(BlockEntityRendererProvider.Context context) {
    }

    public PostboxRenderState createRenderState() {
        return new PostboxRenderState();
    }

    public void extractRenderState(PostboxBlockEntity be, PostboxRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        state.layer = RenderTypes.cutoutMovingBlock();
        state.flag = CachedBuffers.partial(AllPartialModels.POSTBOX_FLAG, state.blockState);
        state.angle = (float)Math.PI / 180 * (180.0f - ((Direction)state.blockState.getValue((Property)PostboxBlock.FACING)).toYRot());
        LerpedFloat flag = be.flag;
        float value = flag.getValue(tickProgress);
        float progress = (float)Math.pow(Math.min(value * 5.0f, 1.0f), 2.0);
        if (flag.getChaseTarget() > 0.0f && !flag.settled() && progress == 1.0f) {
            float wiggleProgress = (value - 0.2f) / 0.8f;
            progress += (float)(Math.sin(wiggleProgress * ((float)Math.PI * 2) * 4.0f) / 8.0 / (double)Math.max(1.0f, 8.0f * wiggleProgress));
        }
        state.xRot = (float)Math.PI / 180 * (-progress * 90.0f);
        String filter = be.addressFilter;
        if (filter != null && !filter.isBlank()) {
            state.name = SmartBlockEntityRenderer.getNameplateRenderState(be, state.blockPos, cameraPos, (Component)Component.literal((String)filter), 1.0f, state.lightCoords);
        }
    }

    public void submit(PostboxRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
        if (state.name != null) {
            state.name.render(matrices, queue, cameraState);
        }
    }

    public static class PostboxRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer flag;
        public float angle;
        public float xRot;
        public SmartBlockEntityRenderer.NameplateRenderState name;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.flag.light(this.lightCoords).overlay(OverlayTexture.NO_OVERLAY).rotateYCentered(this.angle)).translate(0.0f, 0.625f, 0.125f)).rotateX(this.xRot)).translate(0.0f, -0.625f, -0.125f)).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

