/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.redstoneRequester;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.logistics.AddressEditBox;
import com.zurrtum.create.client.content.trains.station.NoShadowFontWrapper;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import com.zurrtum.create.content.logistics.redstoneRequester.RedstoneRequesterMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.RedstoneRequesterConfigurationPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class RedstoneRequesterScreen
extends AbstractSimiContainerScreen<RedstoneRequesterMenu> {
    private AddressEditBox addressBox;
    private IconButton confirmButton;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private List<Integer> amounts = new ArrayList<Integer>();
    private IconButton dontAllowPartial;
    private IconButton allowPartial;
    private ElementWidget renderedItem;

    public RedstoneRequesterScreen(RedstoneRequesterMenu container, Inventory inv, Component title) {
        super(container, inv, title);
        for (int i = 0; i < 9; ++i) {
            this.amounts.add(1);
        }
        List<BigItemStack> stacks = ((RedstoneRequesterBlockEntity)((RedstoneRequesterMenu)this.menu).contentHolder).encodedRequest.stacks();
        for (int i = 0; i < stacks.size(); ++i) {
            this.amounts.set(i, Math.max(1, stacks.get((int)i).count));
        }
    }

    public static RedstoneRequesterScreen create(Minecraft mc, MenuType<RedstoneRequesterBlockEntity> type, int syncId, Inventory inventory, Component title, RegistryFriendlyByteBuf extraData) {
        return (RedstoneRequesterScreen)((Object)type.create(RedstoneRequesterScreen::new, syncId, inventory, title, (RedstoneRequesterBlockEntity)RedstoneRequesterScreen.getBlockEntity(mc, extraData)));
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        this.addressBox.tick();
        for (int i = 0; i < this.amounts.size(); ++i) {
            if (!((RedstoneRequesterMenu)this.menu).ghostInventory.getItem(i).isEmpty()) continue;
            this.amounts.set(i, 1);
        }
    }

    @Override
    protected void init() {
        int bgHeight = AllGuiTextures.REDSTONE_REQUESTER.getHeight();
        int bgWidth = AllGuiTextures.REDSTONE_REQUESTER.getWidth();
        this.setWindowSize(bgWidth, bgHeight + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        super.init();
        this.clearWidgets();
        if (this.addressBox == null) {
            this.addressBox = new AddressEditBox((Screen)this, new NoShadowFontWrapper(this.font), this.leftPos + 55, this.topPos + 68, 110, 10, false);
            this.addressBox.setValue(((RedstoneRequesterBlockEntity)((RedstoneRequesterMenu)this.menu).contentHolder).encodedTargetAdress);
            this.addressBox.setTextColor(-11184811);
        }
        this.addRenderableWidget((GuiEventListener)this.addressBox);
        this.confirmButton = new IconButton(this.leftPos + bgWidth - 30, this.topPos + bgHeight - 25, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.minecraft.player.closeContainer());
        this.addRenderableWidget(this.confirmButton);
        this.allowPartial = new IconButton(this.leftPos + 12, this.topPos + bgHeight - 25, AllIcons.I_PARTIAL_REQUESTS);
        this.allowPartial.withCallback(() -> {
            this.allowPartial.green = true;
            this.dontAllowPartial.green = false;
        });
        this.allowPartial.green = ((RedstoneRequesterBlockEntity)((RedstoneRequesterMenu)this.menu).contentHolder).allowPartialRequests;
        this.allowPartial.setToolTip((Component)CreateLang.translate("gui.redstone_requester.allow_partial", new Object[0]).component());
        this.addRenderableWidget(this.allowPartial);
        this.dontAllowPartial = new IconButton(this.leftPos + 12 + 18, this.topPos + bgHeight - 25, AllIcons.I_FULL_REQUESTS);
        this.dontAllowPartial.withCallback(() -> {
            this.allowPartial.green = false;
            this.dontAllowPartial.green = true;
        });
        this.dontAllowPartial.green = !((RedstoneRequesterBlockEntity)((RedstoneRequesterMenu)this.menu).contentHolder).allowPartialRequests;
        this.dontAllowPartial.setToolTip((Component)CreateLang.translate("gui.redstone_requester.dont_allow_partial", new Object[0]).component());
        this.addRenderableWidget(this.dontAllowPartial);
        this.extraAreas = List.of(new Rect2i(this.leftPos + bgWidth, this.topPos + bgHeight - 50, 70, 60));
        this.renderedItem = new ElementWidget(this.leftPos + 245, this.topPos + 80).showingElement(GuiGameElement.of(AllItems.REDSTONE_REQUESTER.getDefaultInstance()).scale(3.0f));
        this.addRenderableWidget(this.renderedItem);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        AllGuiTextures.REDSTONE_REQUESTER.render(pGuiGraphics, this.leftPos + 3, this.topPos);
        this.renderPlayerInventory(pGuiGraphics, this.leftPos - 3, this.topPos + 124);
        ItemStack stack = AllItems.REDSTONE_REQUESTER.getDefaultInstance();
        Component title = stack.getHoverName();
        pGuiGraphics.drawString(this.font, title, this.leftPos + 117 - this.font.width((FormattedText)title) / 2, this.topPos + 4, -12764088, false);
    }

    @Override
    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        for (int i = 0; i < this.amounts.size(); ++i) {
            int inputX = this.leftPos + 27 + i * 20;
            int inputY = this.topPos + 28;
            ItemStack itemStack = ((RedstoneRequesterMenu)this.menu).ghostInventory.getItem(i);
            if (itemStack.isEmpty()) continue;
            graphics.renderItemDecorations(this.font, itemStack, inputX, inputY, String.valueOf(this.amounts.get(i)));
        }
        if (this.addressBox.isHovered() && !this.addressBox.isFocused()) {
            if (this.addressBox.getValue().isBlank()) {
                graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate("gui.redstone_requester.requester_address", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.redstone_requester.requester_address_tip", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.redstone_requester.requester_address_tip_1", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.schedule.lmb_edit", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
            } else {
                graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate("gui.redstone_requester.requester_address_given", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.text("'" + this.addressBox.getValue() + "'").style(ChatFormatting.GRAY).component()), mouseX, mouseY);
            }
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.addressBox.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        for (int i = 0; i < this.amounts.size(); ++i) {
            int inputX = this.leftPos + 27 + i * 20;
            int inputY = this.topPos + 28;
            if (!(mouseX >= (double)inputX) || !(mouseX < (double)(inputX + 16)) || !(mouseY >= (double)inputY) || !(mouseY < (double)(inputY + 16))) continue;
            ItemStack itemStack = ((RedstoneRequesterMenu)this.menu).ghostInventory.getItem(i);
            if (itemStack.isEmpty()) {
                return true;
            }
            this.amounts.set(i, Mth.clamp((int)((int)((double)this.amounts.get(i).intValue() + Math.signum(scrollY) * (double)(AllKeys.hasShiftDown() ? 10 : 1))), (int)1, (int)256));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    protected List<Component> getTooltipFromContainerItem(ItemStack pStack) {
        List tooltip = super.getTooltipFromContainerItem(pStack);
        if (this.hoveredSlot == null || this.hoveredSlot.container != ((RedstoneRequesterMenu)this.menu).ghostInventory) {
            return tooltip;
        }
        int slotIndex = this.hoveredSlot.getContainerSlot();
        if (slotIndex >= this.amounts.size()) {
            return tooltip;
        }
        return List.of(CreateLang.translate("gui.factory_panel.send_item", CreateLang.itemName(pStack).add(CreateLang.text(" x" + String.valueOf(this.amounts.get(slotIndex))))).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.scroll_to_change_amount", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component(), CreateLang.translate("gui.scrollInput.shiftScrollsFaster", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component());
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }

    public void removed() {
        this.minecraft.player.connection.send((Packet)new RedstoneRequesterConfigurationPacket(((RedstoneRequesterBlockEntity)((RedstoneRequesterMenu)this.menu).contentHolder).getBlockPos(), this.addressBox.getValue(), this.allowPartial.green, this.amounts));
        super.removed();
    }
}

