/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.stockTicker;

import com.mojang.blaze3d.platform.Window;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.content.logistics.AddressEditBox;
import com.zurrtum.create.client.content.trains.station.NoShadowFontWrapper;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.render.BlazeBurnerRenderState;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.packet.c2s.LogisticalStockRequestPacket;
import com.zurrtum.create.infrastructure.packet.c2s.PackageOrderRequestPacket;
import com.zurrtum.create.infrastructure.packet.c2s.StockKeeperCategoryHidingPacket;
import com.zurrtum.create.infrastructure.packet.c2s.StockKeeperLockPacket;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.lwjgl.glfw.GLFW;

public class StockKeeperRequestScreen
extends AbstractSimiContainerScreen<StockKeeperRequestMenu> {
    private static final AllGuiTextures NUMBERS = AllGuiTextures.NUMBERS;
    private static final AllGuiTextures HEADER = AllGuiTextures.STOCK_KEEPER_REQUEST_HEADER;
    private static final AllGuiTextures BODY = AllGuiTextures.STOCK_KEEPER_REQUEST_BODY;
    private static final AllGuiTextures FOOTER = AllGuiTextures.STOCK_KEEPER_REQUEST_FOOTER;
    StockTickerBlockEntity blockEntity;
    public LerpedFloat itemScroll = LerpedFloat.linear().startWithValue(0.0);
    final int rows = 9;
    final int cols = 9;
    final int rowHeight = 20;
    final int colWidth = 20;
    final Couple<Integer> noneHovered = Couple.create(-1, -1);
    int itemsX;
    int itemsY;
    int orderY;
    int lockX;
    int lockY;
    int windowWidth;
    int windowHeight;
    public EditBox searchBox;
    public AddressEditBox addressBox;
    int emptyTicks = 0;
    int successTicks = 0;
    public List<List<BigItemStack>> currentItemSource;
    public List<List<BigItemStack>> displayedItems = new ArrayList<List<BigItemStack>>();
    public List<CategoryEntry> categories = new ArrayList<CategoryEntry>();
    public List<BigItemStack> itemsToOrder = new ArrayList<BigItemStack>();
    WeakReference<LivingEntity> stockKeeper = new WeakReference<Object>(null);
    WeakReference<BlazeBurnerBlockEntity> blaze = new WeakReference<Object>(null);
    boolean encodeRequester;
    ItemStack itemToProgram;
    List<List<ClipboardEntry>> clipboardItem;
    private boolean isAdmin;
    private boolean isLocked;
    private boolean scrollHandleActive;
    private boolean ignoreTextInput;
    public boolean refreshSearchNextTick = false;
    public boolean moveToTopNextTick = false;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private final Set<Integer> hiddenCategories;
    private InventorySummary forcedEntries = new InventorySummary();
    private boolean canRequestCraftingPackage = false;

    public StockKeeperRequestScreen(StockKeeperRequestMenu container, Inventory inv, Component title) {
        super(container, inv, title);
        this.blockEntity = (StockTickerBlockEntity)container.contentHolder;
        this.blockEntity.lastClientsideStockSnapshot = null;
        this.blockEntity.ticksSinceLastUpdate = 15;
        ((StockKeeperRequestMenu)this.menu).screenReference = this;
        this.hiddenCategories = new HashSet<Integer>(this.blockEntity.hiddenCategoriesByPlayer.getOrDefault(((StockKeeperRequestMenu)this.menu).player.getUUID(), List.of()));
        this.itemToProgram = ((StockKeeperRequestMenu)this.menu).player.getMainHandItem();
        boolean bl = this.encodeRequester = this.itemToProgram.is(AllItemTags.TABLE_CLOTHS) || this.itemToProgram.is((Item)AllItems.REDSTONE_REQUESTER);
        if (this.itemToProgram.is((Item)AllItems.CLIPBOARD)) {
            this.clipboardItem = ClipboardEntry.readAll(this.itemToProgram);
            boolean anyItems = false;
            block0: for (List<ClipboardEntry> list : this.clipboardItem) {
                for (ClipboardEntry entry : list) {
                    if (entry.icon.isEmpty()) continue;
                    anyItems = true;
                    continue block0;
                }
            }
            if (!anyItems) {
                this.clipboardItem = null;
            }
        }
        for (int yOffset : Iterate.zeroAndOne) {
            for (Direction side : Iterate.horizontalDirections) {
                BlockEntity blockEntity;
                BlockPos seatPos = this.blockEntity.getBlockPos().below(yOffset).relative(side);
                for (SeatEntity seatEntity : this.blockEntity.getLevel().getEntitiesOfClass(SeatEntity.class, new AABB(seatPos))) {
                    Object e;
                    if (seatEntity.getPassengers().isEmpty() || !((e = seatEntity.getPassengers().getFirst()) instanceof LivingEntity)) continue;
                    LivingEntity keeper = (LivingEntity)e;
                    this.stockKeeper = new WeakReference<LivingEntity>(keeper);
                }
                if (yOffset != 0 || !((blockEntity = this.blockEntity.getLevel().getBlockEntity(seatPos)) instanceof BlazeBurnerBlockEntity)) continue;
                BlazeBurnerBlockEntity bbbe = (BlazeBurnerBlockEntity)blockEntity;
                this.blaze = new WeakReference<BlazeBurnerBlockEntity>(bbbe);
                return;
            }
        }
    }

    public static StockKeeperRequestScreen create(Minecraft mc, MenuType<StockTickerBlockEntity> type, int syncId, Inventory inventory, Component title, RegistryFriendlyByteBuf extraData) {
        StockKeeperRequestScreen screen = (StockKeeperRequestScreen)((Object)type.create(StockKeeperRequestScreen::new, syncId, inventory, title, (StockTickerBlockEntity)StockKeeperRequestScreen.getBlockEntity(mc, extraData)));
        if (screen == null) {
            return null;
        }
        screen.isAdmin = extraData.readBoolean();
        screen.isLocked = extraData.readBoolean();
        return screen;
    }

    @Override
    protected void init() {
        int appropriateHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight() - 10;
        appropriateHeight -= Mth.positiveModulo((int)(appropriateHeight - HEADER.getHeight() - FOOTER.getHeight()), (int)BODY.getHeight());
        appropriateHeight = Math.min(appropriateHeight, HEADER.getHeight() + FOOTER.getHeight() + BODY.getHeight() * 17);
        this.windowWidth = 226;
        this.windowHeight = appropriateHeight;
        this.setWindowSize(226, this.windowHeight);
        super.init();
        this.clearWidgets();
        this.itemsX = this.leftPos + (this.windowWidth - 180) / 2 + 1;
        this.itemsY = this.topPos + 33;
        this.orderY = this.topPos + this.windowHeight - 72;
        this.lockX = this.leftPos + 186;
        this.lockY = this.topPos + 18;
        MutableComponent searchLabel = CreateLang.translateDirect("gui.stock_keeper.search_items", new Object[0]);
        this.searchBox = new EditBox((Font)new NoShadowFontWrapper(this.font), this.leftPos + 71, this.topPos + 22, 100, 9, (Component)searchLabel);
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(false);
        this.searchBox.setTextColor(-11915983);
        this.addWidget((GuiEventListener)this.searchBox);
        boolean initial = this.addressBox == null;
        String previouslyUsedAddress = initial ? this.blockEntity.previouslyUsedAddress : this.addressBox.getValue();
        this.addressBox = new AddressEditBox((Screen)this, new NoShadowFontWrapper(this.font), this.leftPos + 27, this.topPos + this.windowHeight - 36, 92, 10, true);
        this.addressBox.setTextColor(-9352640);
        this.addressBox.setValue(previouslyUsedAddress);
        this.addRenderableWidget((GuiEventListener)this.addressBox);
        this.extraAreas = new ArrayList<Rect2i>();
        int leftHeight = 40;
        int rightHeight = 50;
        LivingEntity keeper = (LivingEntity)this.stockKeeper.get();
        if (keeper != null && keeper.isAlive()) {
            leftHeight = (int)(Math.max(0.0, keeper.getBoundingBox().getYsize()) * 50.0);
        }
        this.extraAreas.add(new Rect2i(0, this.topPos + this.windowHeight - 15 - leftHeight, this.leftPos, this.height));
        if (this.encodeRequester) {
            this.extraAreas.add(new Rect2i(this.leftPos + this.windowWidth, this.topPos + this.windowHeight - 15 - rightHeight, rightHeight + 10, rightHeight));
        }
        if (initial) {
            this.playUiSound(SoundEvents.WOOD_HIT, 0.5f, 1.5f);
            this.playUiSound(SoundEvents.BOOK_PAGE_TURN, 1.0f, 1.0f);
        }
    }

    private void refreshSearchResults(boolean scrollBackUp) {
        this.displayedItems = Collections.emptyList();
        if (scrollBackUp) {
            this.itemScroll.startWithValue(0.0);
        }
        if (this.currentItemSource == null) {
            this.clampScrollBar();
            return;
        }
        if (this.isSchematicListMode()) {
            this.clampScrollBar();
            this.requestSchematicList();
            return;
        }
        this.categories = new ArrayList<CategoryEntry>();
        for (int i = 0; i < this.blockEntity.categories.size(); ++i) {
            ItemStack stack = this.blockEntity.categories.get(i);
            CategoryEntry entry = new CategoryEntry(i, stack.isEmpty() ? "" : stack.getHoverName().getString(), 0);
            entry.hidden = this.hiddenCategories.contains(i);
            this.categories.add(entry);
        }
        CategoryEntry unsorted = new CategoryEntry(-1, CreateLang.translate("gui.stock_keeper.unsorted_category", new Object[0]).string(), 0);
        unsorted.hidden = this.hiddenCategories.contains(-1);
        this.categories.add(unsorted);
        String valueWithPrefix = this.searchBox.getValue();
        boolean anyItemsInCategory = false;
        if (valueWithPrefix.isBlank()) {
            this.displayedItems = new ArrayList<List<BigItemStack>>(this.currentItemSource);
            int categoryY = 0;
            for (int categoryIndex = 0; categoryIndex < this.currentItemSource.size(); ++categoryIndex) {
                this.categories.get((int)categoryIndex).y = categoryY;
                List<BigItemStack> displayedItemsInCategory = this.displayedItems.get(categoryIndex);
                if (displayedItemsInCategory.isEmpty()) continue;
                if (categoryIndex < this.currentItemSource.size() - 1) {
                    anyItemsInCategory = true;
                }
                categoryY += 20;
                if (this.categories.get((int)categoryIndex).hidden) continue;
                categoryY = (int)((double)categoryY + Math.ceil((float)displayedItemsInCategory.size() / 9.0f) * 20.0);
            }
            if (!anyItemsInCategory) {
                this.categories.clear();
            }
            this.clampScrollBar();
            return;
        }
        boolean modSearch = false;
        boolean tagSearch = false;
        modSearch = valueWithPrefix.startsWith("@");
        if (modSearch || (tagSearch = valueWithPrefix.startsWith("#"))) {
            valueWithPrefix = valueWithPrefix.substring(1);
        }
        String value = valueWithPrefix.toLowerCase(Locale.ROOT);
        this.displayedItems = new ArrayList<List<BigItemStack>>();
        this.currentItemSource.forEach($ -> this.displayedItems.add(new ArrayList()));
        int categoryY = 0;
        for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
            List<BigItemStack> category = this.currentItemSource.get(categoryIndex);
            this.categories.get((int)categoryIndex).y = categoryY;
            if (this.displayedItems.size() <= categoryIndex) break;
            List<BigItemStack> displayedItemsInCategory = this.displayedItems.get(categoryIndex);
            for (BigItemStack entry : category) {
                ItemStack stack = entry.stack;
                if (modSearch) {
                    if (!BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace().contains(value)) continue;
                    displayedItemsInCategory.add(entry);
                    continue;
                }
                if (tagSearch) {
                    if (!stack.getTags().anyMatch(key -> key.location().toString().contains(value))) continue;
                    displayedItemsInCategory.add(entry);
                    continue;
                }
                if (!stack.getHoverName().getString().toLowerCase(Locale.ROOT).contains(value) && !BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath().contains(value)) continue;
                displayedItemsInCategory.add(entry);
            }
            if (displayedItemsInCategory.isEmpty()) continue;
            if (categoryIndex < this.currentItemSource.size() - 1) {
                anyItemsInCategory = true;
            }
            categoryY += 20;
            if (this.categories.get((int)categoryIndex).hidden) continue;
            categoryY = (int)((double)categoryY + Math.ceil((float)displayedItemsInCategory.size() / 9.0f) * 20.0);
        }
        if (!anyItemsInCategory) {
            this.categories.clear();
        }
        this.clampScrollBar();
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        this.addressBox.tick();
        if (!this.forcedEntries.isEmpty()) {
            InventorySummary summary = this.blockEntity.getLastClientsideStockSnapshotAsSummary();
            for (BigItemStack bigItemStack : this.forcedEntries.getStacks()) {
                int limitedAmount = -bigItemStack.count - 1;
                int actualAmount = summary.getCountOf(bigItemStack.stack);
                if (actualAmount > limitedAmount) continue;
                this.forcedEntries.erase(bigItemStack.stack);
            }
        }
        boolean allEmpty = true;
        for (List list : this.displayedItems) {
            allEmpty &= list.isEmpty();
        }
        this.emptyTicks = allEmpty ? ++this.emptyTicks : 0;
        this.successTicks = this.successTicks > 0 && this.itemsToOrder.isEmpty() ? ++this.successTicks : 0;
        List<List<BigItemStack>> clientStockSnapshot = this.blockEntity.getClientStockSnapshot();
        if (clientStockSnapshot != this.currentItemSource) {
            this.currentItemSource = clientStockSnapshot;
            this.refreshSearchResults(false);
            this.revalidateOrders();
        }
        if (this.refreshSearchNextTick) {
            this.refreshSearchNextTick = false;
            this.refreshSearchResults(this.moveToTopNextTick);
        }
        this.itemScroll.tickChaser();
        if (Math.abs(this.itemScroll.getValue() - this.itemScroll.getChaseTarget()) < 0.0625f) {
            this.itemScroll.setValue(this.itemScroll.getChaseTarget());
        }
        if (this.blockEntity.ticksSinceLastUpdate > 15) {
            this.blockEntity.resetTicksSinceLastUpdate();
            this.minecraft.player.connection.send((Packet)new LogisticalStockRequestPacket(this.blockEntity.getBlockPos()));
        }
        LivingEntity livingEntity = (LivingEntity)this.stockKeeper.get();
        BlazeBurnerBlockEntity blazeKeeper = (BlazeBurnerBlockEntity)this.blaze.get();
        if (!(livingEntity != null && livingEntity.isAlive() || blazeKeeper != null && !blazeKeeper.isRemoved())) {
            this.minecraft.player.closeContainer();
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        boolean justSent;
        BlazeBurnerBlockEntity keeperBE;
        int entityY;
        int entityX;
        if (this != this.minecraft.screen) {
            return;
        }
        partialTicks = AnimationTickHolder.getPartialTicksUI(this.minecraft.getDeltaTracker());
        Matrix3x2fStack ms = graphics.pose();
        float currentScroll = this.itemScroll.getValue(partialTicks);
        Couple<Integer> hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        int x = this.leftPos;
        int y = this.topPos;
        HEADER.render(graphics, x - 15, y);
        y += HEADER.getHeight();
        for (int i = 0; i < (this.windowHeight - HEADER.getHeight() - FOOTER.getHeight()) / BODY.getHeight(); ++i) {
            BODY.render(graphics, x - 15, y);
            y += BODY.getHeight();
        }
        FOOTER.render(graphics, x - 15, y);
        y = this.topPos;
        if (this.addressBox.getValue().isBlank() && !this.addressBox.isFocused()) {
            graphics.drawString(this.font, (Component)CreateLang.translate("gui.stock_keeper.package_adress", new Object[0]).style(ChatFormatting.ITALIC).component(), this.addressBox.getX(), this.addressBox.getY(), -3294040, false);
        }
        int entitySizeOffset = 0;
        LivingEntity keeper = (LivingEntity)this.stockKeeper.get();
        if (keeper != null && keeper.isAlive()) {
            ms.pushMatrix();
            entitySizeOffset = (int)(Math.max(0.0, keeper.getBoundingBox().getXsize() - 1.0) * 50.0);
            int entitySizeOffsetY = (int)(Math.max(0.0, keeper.getBoundingBox().getYsize() - 1.0) * 25.0);
            entityX = x - 35 - entitySizeOffset;
            entityY = y + this.windowHeight - 47 - entitySizeOffsetY;
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(entityX - 100), (int)(entityY - 100), (int)(entityX + 100), (int)(entityY + 100), (int)50, (float)0.0f, (float)mouseX, (float)Mth.clamp((int)mouseY, (int)(entityY - 50), (int)(entityY + 10)), (LivingEntity)keeper);
            ms.popMatrix();
        }
        if ((keeperBE = (BlazeBurnerBlockEntity)this.blaze.get()) != null && !keeperBE.isRemoved()) {
            entityX = x - 69;
            entityY = y + this.windowHeight - 85;
            ClientLevel world = this.minecraft.level;
            BlockState block = keeperBE.getBlockState();
            BlazeBurnerBlock.HeatLevel heatLevel = keeperBE.getHeatLevelForRender();
            float animation = keeperBE.headAnimation.getValue(partialTicks) * 0.175f;
            boolean drawGoggles = keeperBE.goggles;
            int hashCode = keeperBE.hashCode();
            graphics.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)new BlazeBurnerRenderState(new Matrix3x2f((Matrix3x2fc)ms), entityX, entityY, (Level)world, block, heatLevel, animation, drawGoggles, hashCode));
        }
        if (this.encodeRequester) {
            ms.pushMatrix();
            ms.scale(3.5f, 3.5f);
            graphics.renderItem(this.itemToProgram, x + this.windowWidth + 5, y + this.windowHeight - 70);
            ms.popMatrix();
        }
        for (int index = 0; index < 9 && this.itemsToOrder.size() > index; ++index) {
            BigItemStack entry = this.itemsToOrder.get(index);
            boolean isStackHovered = index == (Integer)hoveredSlot.getSecond() && (Integer)hoveredSlot.getFirst() == -1;
            ms.pushMatrix();
            ms.translate((float)(this.itemsX + index * 20), (float)this.orderY);
            this.renderItemEntry(graphics, entry, isStackHovered, true);
            ms.popMatrix();
        }
        if (this.itemsToOrder.size() > 9) {
            graphics.drawString(this.font, (Component)Component.literal((String)("[+" + (this.itemsToOrder.size() - 9) + "]")), x + this.windowWidth - 40, this.orderY + 21, -460564, true);
        }
        boolean bl = justSent = this.itemsToOrder.isEmpty() && this.successTicks > 0;
        if (this.isConfirmHovered(mouseX, mouseY) && !justSent) {
            AllGuiTextures.STOCK_KEEPER_REQUEST_SEND_HOVER.render(graphics, x + this.windowWidth - 81, y + this.windowHeight - 41);
        }
        MutableComponent headerTitle = CreateLang.translate("gui.stock_keeper.title", new Object[0]).component();
        graphics.drawString(this.font, (Component)headerTitle, x + this.windowWidth / 2 - this.font.width((FormattedText)headerTitle) / 2, y + 4, -9352640, false);
        MutableComponent component = CreateLang.translate(this.encodeRequester ? "gui.stock_keeper.configure" : "gui.stock_keeper.send", new Object[0]).component();
        if (justSent) {
            float alpha = Mth.clamp((float)(((float)this.successTicks + partialTicks - 5.0f) / 5.0f), (float)0.0f, (float)1.0f);
            ms.pushMatrix();
            ms.translate(alpha * alpha * 50.0f, 0.0f);
            if (this.successTicks < 10) {
                graphics.drawString(this.font, (Component)component, x + this.windowWidth - 42 - this.font.width((FormattedText)component) / 2, y + this.windowHeight - 35, new Color(0x252525).setAlpha(1.0f - alpha * alpha).getRGB(), false);
            }
            ms.popMatrix();
        } else {
            graphics.drawString(this.font, (Component)component, x + this.windowWidth - 42 - this.font.width((FormattedText)component) / 2, y + this.windowHeight - 35, -14342875, false);
        }
        if (justSent) {
            MutableComponent msg = CreateLang.translateDirect("gui.stock_keeper.request_sent", new Object[0]);
            float alpha = Mth.clamp((float)(((float)this.successTicks + partialTicks - 10.0f) / 5.0f), (float)0.0f, (float)1.0f);
            int msgX = x + this.windowWidth / 2 - (this.font.width((FormattedText)msg) + 10) / 2;
            int msgY = this.orderY + 5;
            if (alpha > 0.0f) {
                int c3 = new Color(9198923).setAlpha(alpha).getRGB();
                int w = this.font.width((FormattedText)msg) + 14;
                AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_L.render(graphics, msgX - 8, msgY - 4);
                UIRenderHelper.drawStretched(graphics, msgX, msgY - 4, w, 16, AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_M);
                AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_R.render(graphics, msgX + this.font.width((FormattedText)msg) + 10, msgY - 4);
                graphics.drawString(this.font, (Component)msg, msgX + 5, msgY, c3, false);
            }
        }
        int itemWindowX = x + 21;
        int itemWindowX2 = itemWindowX + 184;
        int itemWindowY = y + 17;
        int itemWindowY2 = y + this.windowHeight - 80;
        graphics.enableScissor(itemWindowX - 5, itemWindowY, itemWindowX2 + 10, itemWindowY2);
        ms.pushMatrix();
        ms.translate(0.0f, -currentScroll * 20.0f);
        for (int sliceY = -2; sliceY < this.getMaxScroll() * 20 + this.windowHeight - 72; sliceY += AllGuiTextures.STOCK_KEEPER_REQUEST_BG.getHeight()) {
            if ((float)sliceY - currentScroll * 20.0f < -20.0f || (float)sliceY - currentScroll * 20.0f > (float)(this.windowHeight - 72)) continue;
            AllGuiTextures.STOCK_KEEPER_REQUEST_BG.render(graphics, x + 22, y + sliceY + 18);
        }
        AllGuiTextures.STOCK_KEEPER_REQUEST_SEARCH.render(graphics, x + 42, this.searchBox.getY() - 5);
        this.searchBox.render(graphics, mouseX, mouseY, partialTicks);
        if (this.searchBox.getValue().isBlank() && !this.searchBox.isFocused()) {
            graphics.drawString(this.font, this.searchBox.getMessage(), x + this.windowWidth / 2 - this.font.width((FormattedText)this.searchBox.getMessage()) / 2, this.searchBox.getY(), -11915983, false);
        }
        boolean allEmpty = true;
        for (List<BigItemStack> list : this.displayedItems) {
            allEmpty &= list.isEmpty();
        }
        if (allEmpty) {
            Component msg = this.getTroubleshootingMessage();
            float alpha = Mth.clamp((float)(((float)this.emptyTicks - 10.0f) / 5.0f), (float)0.0f, (float)1.0f);
            if (alpha > 0.0f) {
                List split = this.font.split((FormattedText)msg, 160);
                for (int i = 0; i < split.size(); ++i) {
                    FormattedCharSequence sequence = (FormattedCharSequence)split.get(i);
                    int lineWidth = this.font.width(sequence);
                    int n = x + this.windowWidth / 2 - lineWidth / 2 + 1;
                    Objects.requireNonNull(this.font);
                    graphics.drawString(this.font, sequence, n, this.itemsY + 20 + 1 + i * (9 + 1), new Color(4861233).setAlpha(alpha).getRGB(), false);
                    int n2 = x + this.windowWidth / 2 - lineWidth / 2;
                    Objects.requireNonNull(this.font);
                    graphics.drawString(this.font, sequence, n2, this.itemsY + 20 + i * (9 + 1), new Color(16316652).setAlpha(alpha).getRGB(), false);
                }
            }
        }
        block5: for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
            int categoryY;
            List<BigItemStack> category = this.displayedItems.get(categoryIndex);
            CategoryEntry categoryEntry = this.categories.isEmpty() ? null : this.categories.get(categoryIndex);
            int n = categoryY = this.categories.isEmpty() ? 0 : categoryEntry.y;
            if (category.isEmpty()) continue;
            if (!this.categories.isEmpty()) {
                (categoryEntry.hidden ? AllGuiTextures.STOCK_KEEPER_CATEGORY_HIDDEN : AllGuiTextures.STOCK_KEEPER_CATEGORY_SHOWN).render(graphics, this.itemsX, this.itemsY + categoryY + 6);
                graphics.drawString(this.font, categoryEntry.name, this.itemsX + 10, this.itemsY + categoryY + 8, -11915983, false);
                graphics.drawString(this.font, categoryEntry.name, this.itemsX + 9, this.itemsY + categoryY + 7, -460564, false);
                if (categoryEntry.hidden) continue;
            }
            for (int index = 0; index < category.size(); ++index) {
                int pY = this.itemsY + categoryY + (this.categories.isEmpty() ? 4 : 20) + index / 9 * 20;
                float cullY = (float)pY - currentScroll * 20.0f;
                if (cullY < (float)y) continue;
                if (cullY > (float)(y + this.windowHeight - 72)) continue block5;
                boolean isStackHovered = index == (Integer)hoveredSlot.getSecond() && categoryIndex == (Integer)hoveredSlot.getFirst();
                BigItemStack entry = category.get(index);
                ms.pushMatrix();
                ms.translate((float)(this.itemsX + index % 9 * 20), (float)pY);
                this.renderItemEntry(graphics, entry, isStackHovered, false);
                ms.popMatrix();
            }
        }
        if (this.isAdmin) {
            (this.isLocked ? AllGuiTextures.STOCK_KEEPER_REQUEST_LOCKED : AllGuiTextures.STOCK_KEEPER_REQUEST_UNLOCKED).render(graphics, this.lockX, this.lockY);
        }
        ms.popMatrix();
        graphics.disableScissor();
        int windowH = this.windowHeight - 92;
        int totalH = this.getMaxScroll() * 20 + windowH;
        int barSize = Math.max(5, Mth.floor((float)((float)windowH / (float)totalH * (float)(windowH - 2))));
        if (barSize < windowH - 2) {
            int barX = this.itemsX + 180;
            int barY = y + 15;
            ms.pushMatrix();
            ms.translate(0.0f, currentScroll * 20.0f / (float)totalH * (float)(windowH - 2));
            AllGuiTextures pad = AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_PAD;
            graphics.blit(RenderPipelines.GUI_TEXTURED, pad.location, barX, barY, (float)pad.getStartX(), (float)pad.getStartY(), pad.getWidth(), barSize, pad.getWidth(), pad.getHeight(), 256, 256);
            AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_TOP.render(graphics, barX, barY);
            if (barSize > 16) {
                AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_MID.render(graphics, barX, barY + barSize / 2 - 4);
            }
            AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_BOT.render(graphics, barX, barY + barSize - 5);
            ms.popMatrix();
        }
    }

    @Override
    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        float currentScroll = this.itemScroll.getValue(partialTicks);
        Couple<Integer> hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        if (hoveredSlot != this.noneHovered) {
            int slot = (Integer)hoveredSlot.getSecond();
            boolean orderHovered = (Integer)hoveredSlot.getFirst() == -1;
            BigItemStack entry = orderHovered ? this.itemsToOrder.get(slot) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get(slot);
            graphics.setTooltipForNextFrame(this.font, entry.stack, mouseX, mouseY);
        }
        if (currentScroll < 1.0f && this.isAdmin && mouseX > this.lockX && mouseX <= this.lockX + 15 && mouseY > this.lockY && mouseY <= this.lockY + 15) {
            graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate(this.isLocked ? "gui.stock_keeper.network_locked" : "gui.stock_keeper.network_open", new Object[0]).component(), CreateLang.translate("gui.stock_keeper.network_lock_tip", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.stock_keeper.network_lock_tip_1", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.stock_keeper.network_lock_tip_2", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
        }
        if (this.addressBox.getValue().isBlank() && !this.addressBox.isFocused() && this.addressBox.isHovered()) {
            graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate("gui.factory_panel.restocker_address", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.schedule.lmb_edit", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
        }
    }

    private void renderItemEntry(GuiGraphics graphics, BigItemStack entry, boolean isStackHovered, boolean isRenderingOrders) {
        int customCount = entry.count;
        if (!isRenderingOrders) {
            BigItemStack order = this.getOrderForItem(entry.stack);
            if (entry.count < 1000000000) {
                int forcedCount = this.forcedEntries.getCountOf(entry.stack);
                if (forcedCount != 0) {
                    customCount = Math.min(customCount, -forcedCount - 1);
                }
                if (order != null) {
                    customCount -= order.count;
                }
                customCount = Math.max(0, customCount);
            }
            AllGuiTextures.STOCK_KEEPER_REQUEST_SLOT.render(graphics, 0, 0);
        }
        boolean craftable = false;
        Matrix3x2fStack ms = graphics.pose();
        ms.pushMatrix();
        float scaleFromHover = 1.0f;
        if (isStackHovered) {
            scaleFromHover += 0.075f;
        }
        ms.translate(1.0f, 1.0f);
        ms.translate(9.0f, 9.0f);
        ms.scale(scaleFromHover, scaleFromHover);
        ms.translate(-9.0f, -9.0f);
        if (customCount != 0 || craftable) {
            graphics.renderItem(entry.stack, 0, 0);
        }
        ms.popMatrix();
        ms.pushMatrix();
        if (customCount != 0 || craftable) {
            graphics.renderItemDecorations(this.font, entry.stack, 1, 1, "");
        }
        if (customCount > 1 || craftable) {
            this.drawItemCount(graphics, customCount);
        }
        ms.popMatrix();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawItemCount(GuiGraphics graphics, int customCount) {
        Object text;
        Object object = customCount >= 1000000 ? customCount / 1000000 + "m" : (customCount >= 10000 ? customCount / 1000 + "k" : (customCount >= 1000 ? (float)(customCount * 10 / 1000) / 10.0f + "k" : (text = customCount >= 100 ? "" + customCount : " " + customCount)));
        if (customCount >= 1000000000) {
            text = "+";
        }
        if (((String)text).isBlank()) {
            return;
        }
        int x = (int)Math.floor((double)(-((String)text).length()) * 2.5);
        char[] cArray = ((String)text).toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (true) {
            block11: {
                if (n2 >= n) {
                    return;
                }
                char c = cArray[n2];
                int index = c - 48;
                int xOffset = index * 6;
                int spriteWidth = NUMBERS.getWidth();
                switch (c) {
                    case ' ': {
                        x += 4;
                        break block11;
                    }
                    case '.': {
                        spriteWidth = 3;
                        xOffset = 60;
                        break;
                    }
                    case 'k': {
                        xOffset = 64;
                        break;
                    }
                    case 'm': {
                        spriteWidth = 7;
                        xOffset = 70;
                        break;
                    }
                    case '+': {
                        spriteWidth = 9;
                        xOffset = 84;
                    }
                }
                graphics.blit(RenderPipelines.GUI_TEXTURED, StockKeeperRequestScreen.NUMBERS.location, 14 + x, 10, (float)(NUMBERS.getStartX() + xOffset), (float)NUMBERS.getStartY(), spriteWidth, NUMBERS.getHeight(), 256, 256);
                x += spriteWidth - 1;
            }
            ++n2;
        }
    }

    @Nullable
    private BigItemStack getOrderForItem(ItemStack stack) {
        for (BigItemStack entry : this.itemsToOrder) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)entry.stack)) continue;
            return entry;
        }
        return null;
    }

    private void revalidateOrders() {
        HashSet<BigItemStack> invalid = new HashSet<BigItemStack>(this.itemsToOrder);
        InventorySummary summary = this.blockEntity.getLastClientsideStockSnapshotAsSummary();
        if (this.currentItemSource == null || summary == null) {
            this.itemsToOrder.removeAll(invalid);
            return;
        }
        for (BigItemStack entry : this.itemsToOrder) {
            entry.count = Math.min(summary.getCountOf(entry.stack), entry.count);
            if (entry.count <= 0) continue;
            invalid.remove(entry);
        }
        this.itemsToOrder.removeAll(invalid);
    }

    private Couple<Integer> getHoveredSlot(int x, int y) {
        if (++x < this.itemsX || x >= this.itemsX + 180 || this.isSchematicListMode()) {
            return this.noneHovered;
        }
        if (y >= this.orderY && y < this.orderY + 20) {
            int col = (x - this.itemsX) / 20;
            if (this.itemsToOrder.size() <= col || col < 0) {
                return this.noneHovered;
            }
            return Couple.create(-1, col);
        }
        if (y < this.topPos + 16 || y > this.topPos + this.windowHeight - 80) {
            return this.noneHovered;
        }
        if (!this.itemScroll.settled()) {
            return this.noneHovered;
        }
        int localY = y - this.itemsY;
        for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
            int col;
            CategoryEntry entry;
            CategoryEntry categoryEntry = entry = this.categories.isEmpty() ? new CategoryEntry(0, "", 0) : this.categories.get(categoryIndex);
            if (entry.hidden) continue;
            int row = Mth.floor((float)((float)(localY - (this.categories.isEmpty() ? 4 : 20) - entry.y) / 20.0f + this.itemScroll.getChaseTarget()));
            int slot = row * 9 + (col = (x - this.itemsX) / 20);
            if (slot < 0) {
                return this.noneHovered;
            }
            if (this.displayedItems.get(categoryIndex).size() <= slot) continue;
            return Couple.create(categoryIndex, slot);
        }
        return this.noneHovered;
    }

    private boolean isConfirmHovered(int mouseX, int mouseY) {
        int confirmX = this.leftPos + 143;
        int confirmY = this.topPos + this.windowHeight - 39;
        int confirmW = 78;
        int confirmH = 18;
        if (mouseX < confirmX || mouseX >= confirmX + confirmW) {
            return false;
        }
        return mouseY >= confirmY && mouseY < confirmY + confirmH;
    }

    private Component getTroubleshootingMessage() {
        if (this.currentItemSource == null) {
            return CreateLang.translate("gui.stock_keeper.checking_stocks", new Object[0]).component();
        }
        if (this.blockEntity.activeLinks == 0) {
            return CreateLang.translate("gui.stock_keeper.no_packagers_linked", new Object[0]).component();
        }
        if (this.currentItemSource.isEmpty()) {
            return CreateLang.translate("gui.stock_keeper.inventories_empty", new Object[0]).component();
        }
        if (this.isSchematicListMode()) {
            return CreateLang.translate(this.itemsToOrder.isEmpty() ? "gui.stock_keeper.schematic_list.no_results" : "gui.stock_keeper.schematic_list.requesting", new Object[0]).component();
        }
        return CreateLang.translate("gui.stock_keeper.no_search_results", new Object[0]).component();
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        Object entry;
        boolean rmb;
        double pMouseX = click.x();
        double pMouseY = click.y();
        int pButton = click.button();
        boolean lmb = pButton == 0;
        boolean bl = rmb = pButton == 1;
        if (rmb && this.searchBox.isMouseOver(pMouseX, pMouseY)) {
            this.searchBox.setValue("");
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
            this.searchBox.setFocused(true);
            return true;
        }
        if (this.addressBox.isFocused()) {
            boolean result = this.addressBox.mouseClicked(click, doubled);
            if (this.addressBox.isHovered() || result) {
                return result;
            }
            this.addressBox.setFocused(false);
        }
        if (this.searchBox.isFocused()) {
            if (this.searchBox.isHovered()) {
                return this.searchBox.mouseClicked(click, doubled);
            }
            this.searchBox.setFocused(false);
        }
        int barX = this.itemsX + 180 - 1;
        if (this.getMaxScroll() > 0 && lmb && pMouseX > (double)barX && pMouseX <= (double)(barX + 8) && pMouseY > (double)(this.topPos + 15) && pMouseY < (double)(this.topPos + this.windowHeight - 82)) {
            this.scrollHandleActive = true;
            if (this.minecraft.isWindowActive()) {
                GLFW.glfwSetInputMode((long)this.minecraft.getWindow().handle(), (int)208897, (int)212994);
            }
            return true;
        }
        Couple<Integer> hoveredSlot = this.getHoveredSlot((int)pMouseX, (int)pMouseY);
        if (this.isAdmin && this.itemScroll.getChaseTarget() == 0.0f && lmb && pMouseX > (double)this.lockX && pMouseX <= (double)(this.lockX + 15) && pMouseY > (double)this.lockY && pMouseY <= (double)(this.lockY + 15)) {
            this.isLocked = !this.isLocked;
            this.minecraft.player.connection.send((Packet)new StockKeeperLockPacket(this.blockEntity.getBlockPos(), this.isLocked));
            this.playUiSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
            return true;
        }
        if (lmb && this.isConfirmHovered((int)pMouseX, (int)pMouseY)) {
            this.sendIt();
            this.playUiSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
            return true;
        }
        int localY = (int)(pMouseY - (double)this.itemsY);
        if (this.itemScroll.settled() && lmb && !this.categories.isEmpty() && pMouseX >= (double)this.itemsX && pMouseX < (double)(this.itemsX + 180) && pMouseY >= (double)(this.topPos + 16) && pMouseY <= (double)(this.topPos + this.windowHeight - 80)) {
            for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
                int indexOf;
                entry = this.categories.get(categoryIndex);
                if (Mth.floor((float)((float)(localY - ((CategoryEntry)entry).y) / 20.0f + this.itemScroll.getChaseTarget())) != 0 || this.displayedItems.get(categoryIndex).isEmpty() || (indexOf = ((CategoryEntry)entry).targetBECategory) >= this.blockEntity.categories.size()) continue;
                if (!((CategoryEntry)entry).hidden) {
                    this.hiddenCategories.add(indexOf);
                    this.playUiSound(SoundEvents.ITEM_FRAME_ROTATE_ITEM, 1.0f, 1.5f);
                } else {
                    this.hiddenCategories.remove(indexOf);
                    this.playUiSound(SoundEvents.ITEM_FRAME_ROTATE_ITEM, 1.0f, 0.675f);
                }
                this.refreshSearchNextTick = true;
                this.moveToTopNextTick = false;
                return true;
            }
        }
        if (hoveredSlot == this.noneHovered || !lmb && !rmb) {
            return super.mouseClicked(click, doubled);
        }
        boolean orderClicked = (Integer)hoveredSlot.getFirst() == -1;
        entry = orderClicked ? this.itemsToOrder.get((Integer)hoveredSlot.getSecond()) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get((Integer)hoveredSlot.getSecond());
        ItemStack itemStack = ((BigItemStack)entry).stack;
        int transfer = click.hasShiftDown() ? itemStack.getMaxStackSize() : (click.hasControlDown() ? 10 : 1);
        BigItemStack existingOrder = this.getOrderForItem(((BigItemStack)entry).stack);
        if (existingOrder == null) {
            if (this.itemsToOrder.size() >= 9 || rmb) {
                return true;
            }
            existingOrder = new BigItemStack(itemStack.copyWithCount(1), 0);
            this.itemsToOrder.add(existingOrder);
            this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.2f);
            this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 0.8f);
        }
        int current = existingOrder.count;
        if (rmb || orderClicked) {
            existingOrder.count = current - transfer;
            if (existingOrder.count <= 0) {
                this.itemsToOrder.remove(existingOrder);
                this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.8f);
                this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 1.8f);
            }
            return true;
        }
        existingOrder.count = current + Math.min(transfer, ((BigItemStack)entry).count - current);
        return true;
    }

    public boolean mouseReleased(MouseButtonEvent click) {
        if (click.button() == 0 && this.scrollHandleActive) {
            this.scrollHandleActive = false;
            if (this.minecraft.isWindowActive()) {
                GLFW.glfwSetInputMode((long)this.minecraft.getWindow().handle(), (int)208897, (int)212993);
            }
        }
        return super.mouseReleased(click);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        BigItemStack existingOrder;
        boolean noHover;
        if (this.addressBox.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        Couple<Integer> hoveredSlot = this.getHoveredSlot((int)mouseX, (int)mouseY);
        boolean bl = noHover = hoveredSlot == this.noneHovered;
        if (noHover || (Integer)hoveredSlot.getFirst() >= 0 && !AllKeys.hasShiftDown() && this.getMaxScroll() != 0) {
            int maxScroll = this.getMaxScroll();
            int direction = (int)(Math.ceil(Math.abs(scrollY)) * -Math.signum(scrollY));
            float newTarget = Mth.clamp((int)Math.round(this.itemScroll.getChaseTarget() + (float)direction), (int)0, (int)maxScroll);
            this.itemScroll.chase(newTarget, 0.5, LerpedFloat.Chaser.EXP);
            return true;
        }
        boolean orderClicked = (Integer)hoveredSlot.getFirst() == -1;
        BigItemStack entry = orderClicked ? this.itemsToOrder.get((Integer)hoveredSlot.getSecond()) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get((Integer)hoveredSlot.getSecond());
        boolean remove = scrollY < 0.0;
        int transfer = Mth.ceil((double)Math.abs(scrollY)) * (AllKeys.hasControlDown() ? 10 : 1);
        BigItemStack bigItemStack = existingOrder = orderClicked ? entry : this.getOrderForItem(entry.stack);
        if (existingOrder == null) {
            if (this.itemsToOrder.size() >= 9 || remove) {
                return true;
            }
            existingOrder = new BigItemStack(entry.stack.copyWithCount(1), 0);
            this.itemsToOrder.add(existingOrder);
            this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.2f);
            this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 0.8f);
        }
        int current = existingOrder.count;
        if (remove) {
            existingOrder.count = current - transfer;
            if (existingOrder.count <= 0) {
                this.itemsToOrder.remove(existingOrder);
                this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.8f);
                this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 1.8f);
            } else if (existingOrder.count != current) {
                this.playUiSound(AllSoundEvents.SCROLL_VALUE.getMainEvent(), 0.25f, 1.2f);
            }
            return true;
        }
        existingOrder.count = current + Math.min(transfer, this.blockEntity.getLastClientsideStockSnapshotAsSummary().getCountOf(entry.stack) - current);
        if (existingOrder.count != current && current != 0) {
            this.playUiSound(AllSoundEvents.SCROLL_VALUE.getMainEvent(), 0.25f, 1.2f);
        }
        return true;
    }

    private void clampScrollBar() {
        float newTarget;
        int maxScroll = this.getMaxScroll();
        float prevTarget = this.itemScroll.getChaseTarget();
        if (prevTarget != (newTarget = Mth.clamp((float)prevTarget, (float)0.0f, (float)maxScroll))) {
            this.itemScroll.startWithValue(newTarget);
        }
    }

    private int getMaxScroll() {
        int visibleHeight = this.windowHeight - 84;
        int totalRows = 2;
        for (int i = 0; i < this.displayedItems.size(); ++i) {
            List<BigItemStack> list = this.displayedItems.get(i);
            if (list.isEmpty()) continue;
            ++totalRows;
            if (this.categories.size() > i && this.categories.get((int)i).hidden) continue;
            totalRows = (int)((double)totalRows + Math.ceil((float)list.size() / 9.0f));
        }
        return Math.max(0, (totalRows * 20 - visibleHeight + 50) / 20);
    }

    public boolean mouseDragged(MouseButtonEvent click, double pDragX, double pDragY) {
        if (click.button() != 0 || !this.scrollHandleActive) {
            return super.mouseDragged(click, pDragX, pDragY);
        }
        Window window = this.minecraft.getWindow();
        double scaleX = (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
        double scaleY = (double)window.getGuiScaledHeight() / (double)window.getScreenHeight();
        int windowH = this.windowHeight - 92;
        int totalH = this.getMaxScroll() * 20 + windowH;
        int barSize = Math.max(5, Mth.floor((float)((float)windowH / (float)totalH * (float)(windowH - 2))));
        int minY = this.topPos + 15 + barSize / 2;
        int maxY = this.topPos + 15 + windowH - barSize / 2;
        if (barSize >= windowH - 2) {
            return true;
        }
        int barX = this.itemsX + 180;
        double target = (click.y() - (double)this.topPos - 15.0 - (double)barSize / 2.0) * (double)totalH / (double)(windowH - 2) / 20.0;
        this.itemScroll.chase(Mth.clamp((double)target, (double)0.0, (double)this.getMaxScroll()), 0.8, LerpedFloat.Chaser.EXP);
        if (this.minecraft.isWindowActive()) {
            double forceX = (double)(barX + 2) / scaleX;
            double forceY = Mth.clamp((double)click.y(), (double)minY, (double)maxY) / scaleY;
            GLFW.glfwSetCursorPos((long)window.handle(), (double)forceX, (double)forceY);
        }
        return true;
    }

    public boolean charTyped(CharacterEvent input) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (this.addressBox.isFocused() && this.addressBox.charTyped(input)) {
            return true;
        }
        String s = this.searchBox.getValue();
        if (!this.searchBox.charTyped(input)) {
            return false;
        }
        if (!Objects.equals(s, this.searchBox.getValue())) {
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
        }
        return true;
    }

    @Override
    public boolean keyPressed(KeyEvent input) {
        this.ignoreTextInput = false;
        if (!this.addressBox.isFocused() && !this.searchBox.isFocused() && this.minecraft.options.keyChat.matches(input)) {
            this.ignoreTextInput = true;
            this.searchBox.setFocused(true);
            return true;
        }
        int pKeyCode = input.key();
        if (pKeyCode == 257 && this.searchBox.isFocused()) {
            this.searchBox.setFocused(false);
            return true;
        }
        if (pKeyCode == 257 && input.hasShiftDown()) {
            this.sendIt();
            return true;
        }
        if (this.addressBox.isFocused() && this.addressBox.keyPressed(input)) {
            return true;
        }
        String s = this.searchBox.getValue();
        if (!this.searchBox.keyPressed(input)) {
            return this.searchBox.isFocused() && this.searchBox.isVisible() && pKeyCode != 256 || super.keyPressed(input);
        }
        if (!Objects.equals(s, this.searchBox.getValue())) {
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
        }
        return true;
    }

    public void removed() {
        BlockPos pos = this.blockEntity.getBlockPos();
        ClientPacketListener networkHandler = this.minecraft.player.connection;
        networkHandler.send((Packet)new PackageOrderRequestPacket(pos, PackageOrderWithCrafts.empty(), this.addressBox.getValue(), false));
        networkHandler.send((Packet)new StockKeeperCategoryHidingPacket(pos, new ArrayList<Integer>(this.hiddenCategories)));
        super.removed();
    }

    private void sendIt() {
        this.revalidateOrders();
        if (this.itemsToOrder.isEmpty()) {
            return;
        }
        this.forcedEntries = new InventorySummary();
        InventorySummary summary = this.blockEntity.getLastClientsideStockSnapshotAsSummary();
        for (BigItemStack toOrder : this.itemsToOrder) {
            int countOf = summary.getCountOf(toOrder.stack);
            if (countOf == 1000000000) continue;
            this.forcedEntries.add(toOrder.stack.copy(), -1 - Math.max(0, countOf - toOrder.count));
        }
        PackageOrderWithCrafts order = PackageOrderWithCrafts.simple(this.itemsToOrder);
        this.minecraft.player.connection.send((Packet)new PackageOrderRequestPacket(this.blockEntity.getBlockPos(), order, this.addressBox.getValue(), this.encodeRequester));
        this.itemsToOrder = new ArrayList<BigItemStack>();
        this.blockEntity.ticksSinceLastUpdate = 10;
        this.successTicks = 1;
        if (this.isSchematicListMode()) {
            this.minecraft.player.closeContainer();
        }
    }

    public boolean keyReleased(KeyEvent input) {
        this.ignoreTextInput = false;
        return super.keyReleased(input);
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }

    public boolean isSchematicListMode() {
        return this.clipboardItem != null;
    }

    public void requestSchematicList() {
        this.itemsToOrder.clear();
        InventorySummary availableItems = this.blockEntity.getLastClientsideStockSnapshotAsSummary();
        for (List<ClipboardEntry> list : this.clipboardItem) {
            for (ClipboardEntry entry : list) {
                ItemStack stack = entry.icon;
                int toOrder = Math.min(entry.itemAmount, availableItems.getCountOf(stack));
                if (toOrder == 0) continue;
                this.itemsToOrder.add(new BigItemStack(stack, toOrder));
            }
        }
    }

    private void removeLeastEssentialItemStack(List<List<BigItemStack>> validIngredients) {
        List<BigItemStack> longest = null;
        int most = 0;
        for (List<BigItemStack> list : validIngredients) {
            int count = (int)list.stream().filter(entry -> this.getOrderForItem(entry.stack) == null).count();
            if (longest != null && count <= most) continue;
            longest = list;
            most = count;
        }
        if (longest.isEmpty()) {
            return;
        }
        BigItemStack chosen = null;
        for (int i = 0; i < longest.size(); ++i) {
            BigItemStack entry2 = longest.get(longest.size() - 1 - i);
            if (this.getOrderForItem(entry2.stack) != null) continue;
            chosen = entry2;
            break;
        }
        for (List<BigItemStack> list : validIngredients) {
            list.remove(chosen);
        }
    }

    private List<List<BigItemStack>> resolveIngredientAmounts(List<List<BigItemStack>> validIngredients) {
        ArrayList<List<BigItemStack>> resolvedIngredients = new ArrayList<List<BigItemStack>>();
        for (int i = 0; i < validIngredients.size(); ++i) {
            resolvedIngredients.add(new ArrayList());
        }
        boolean everythingTaken = false;
        while (!everythingTaken) {
            everythingTaken = true;
            block2: for (int i = 0; i < validIngredients.size(); ++i) {
                List<BigItemStack> list = validIngredients.get(i);
                List resolvedList = (List)resolvedIngredients.get(i);
                for (BigItemStack bigItemStack : list) {
                    if (bigItemStack.count == 0) continue;
                    --bigItemStack.count;
                    everythingTaken = false;
                    for (BigItemStack resolvedItemStack : resolvedList) {
                        if (resolvedItemStack.stack != bigItemStack.stack) continue;
                        ++resolvedItemStack.count;
                        continue block2;
                    }
                    resolvedList.add(new BigItemStack(bigItemStack.stack, 1));
                    continue block2;
                }
            }
        }
        return resolvedIngredients;
    }

    public static class CategoryEntry {
        boolean hidden;
        String name;
        int y;
        int targetBECategory;

        public CategoryEntry(int targetBECategory, String name, int y) {
            this.targetBECategory = targetBECategory;
            this.name = name;
            this.hidden = false;
            this.y = y;
        }
    }
}

