/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.tableCloth;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import java.util.List;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class TableClothRenderer
extends SmartBlockEntityRenderer<TableClothBlockEntity, TableClothRenderState> {
    public TableClothRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public TableClothRenderState createRenderState() {
        return new TableClothRenderState();
    }

    @Override
    public void extractRenderState(TableClothBlockEntity be, TableClothRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        List<ItemStack> stacks;
        int size;
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        state.radians = (float)Math.PI / 180 * (180.0f - be.facing.toYRot());
        if (be.isShop()) {
            state.layer = RenderTypes.cutoutMovingBlock();
            state.shop = CachedBuffers.partial(be.sideOccluded ? AllPartialModels.TABLE_CLOTH_PRICE_TOP : AllPartialModels.TABLE_CLOTH_PRICE_SIDE, state.blockState);
        }
        if ((size = (stacks = be.getItemsForRender()).size()) == 0) {
            return;
        }
        state.items = new DepotRenderer.DepotOutputItemState[size];
        DepotRenderer.DepotOutputItemState[] items = state.items;
        Level world = be.getLevel();
        for (int i = 0; i < size; ++i) {
            items[i] = DepotRenderer.DepotOutputItemState.create(this.itemModelManager, stacks.get(i), world);
        }
        state.itemPosition = Vec3.atCenterOf((Vec3i)state.blockPos);
    }

    @Override
    public void submit(TableClothRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        DepotRenderer.DepotOutputItemState[] items;
        super.submit(state, matrices, queue, cameraState);
        if (state.shop != null) {
            queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
        }
        if ((items = state.items) != null) {
            matrices.rotateAround((Quaternionfc)new Quaternionf().setAngleAxis(state.radians, 0.0f, 1.0f, 0.0f), 0.5f, 0.5f, 0.5f);
            int size = items.length;
            boolean multiple = size > 1;
            for (int i = 0; i < size; ++i) {
                matrices.pushPose();
                matrices.translate(0.5f, 0.1875f, 0.5f);
                if (multiple) {
                    matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)i * (360.0f / (float)size) + 45.0f));
                    matrices.translate(0.0f, i % 2 == 0 ? -0.005f : 0.0f, 0.3125f);
                    matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(-i) * (360.0f / (float)size) - 45.0f));
                }
                DepotRenderer.DepotOutputItemState item = items[i];
                DepotRenderer.renderItem(queue, matrices, state.lightCoords, item.state(), 0, item.upright(), item.box(), item.count(), null, state.itemPosition, cameraState.pos, true, (stack, blockItem) -> {
                    if (!blockItem.booleanValue()) {
                        stack.rotate(-state.radians + (float)Math.PI, Direction.UP);
                    }
                });
                matrices.popPose();
            }
        }
    }

    public static class TableClothRenderState
    extends SmartBlockEntityRenderer.SmartRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer shop;
        public float radians;
        public DepotRenderer.DepotOutputItemState[] items;
        public Vec3 itemPosition;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.shop.rotateCentered(this.radians, Direction.UP);
            this.shop.light(this.lightCoords);
            this.shop.overlay(OverlayTexture.NO_OVERLAY);
            this.shop.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

