/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.processing.basin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinInventory;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class BasinRenderer
extends SmartBlockEntityRenderer<BasinBlockEntity, BasinRenderState> {
    public BasinRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public BasinRenderState createRenderState() {
        return new BasinRenderState();
    }

    @Override
    public void extractRenderState(BasinBlockEntity be, BasinRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        float fluidLevel = this.updateFluids(be, state, tickProgress);
        this.updateIngredients(be, state, tickProgress, fluidLevel);
        this.updateOutputs(be, state, tickProgress);
    }

    @Override
    public void submit(BasinRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.fluids != null) {
            queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
        }
        if (state.ingredients != null) {
            matrices.pushPose();
            matrices.translate(0.5, (double)0.2f, 0.5);
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(state.ingredientYRot));
            for (IngredientRenderData ingredient : state.ingredients) {
                matrices.pushPose();
                matrices.translate(ingredient.itemPosition);
                matrices.mulPose((Quaternionfc)Axis.YP.rotation(ingredient.yRot));
                matrices.mulPose((Quaternionfc)Axis.XP.rotation(state.ingredientXRot));
                for (Vec3 offset : ingredient.offsets) {
                    matrices.pushPose();
                    matrices.translate(offset);
                    ingredient.renderState.submit(matrices, queue, state.lightCoords, OverlayTexture.NO_OVERLAY, 0);
                    matrices.popPose();
                }
                matrices.popPose();
            }
            matrices.popPose();
        }
        if (state.outputs != null) {
            for (OutputItemRenderData item : state.outputs) {
                matrices.pushPose();
                matrices.translate(item.offset);
                matrices.mulPose((Quaternionfc)Axis.YP.rotation(state.outputYRot));
                matrices.mulPose((Quaternionfc)Axis.XP.rotation(item.xRot));
                item.renderState.submit(matrices, queue, state.lightCoords, OverlayTexture.NO_OVERLAY, 0);
                matrices.popPose();
            }
        }
    }

    public float updateFluids(BasinBlockEntity basin, BasinRenderState state, float partialTicks) {
        float totalUnits = basin.getTotalFluidUnits(partialTicks);
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        float xMin = 0.125f;
        float xMax = 0.125f;
        ArrayList<FluidRenderData> fluids = new ArrayList<FluidRenderData>();
        for (SmartFluidTankBehaviour behaviour : List.of(basin.getBehaviour(SmartFluidTankBehaviour.INPUT), basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT))) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                FluidStack renderedFluid = tankSegment.getRenderedFluid();
                if (renderedFluid.isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                float partial = Mth.clamp((float)(units / totalUnits), (float)0.0f, (float)1.0f);
                fluids.add(new FluidRenderData(renderedFluid.getFluid(), renderedFluid.getComponentChanges(), xMin, xMax += partial * 12.0f / 16.0f));
                xMin = xMax;
            }
        }
        if (fluids.isEmpty()) {
            return 0.0f;
        }
        float fluidLevel = Mth.clamp((float)(totalUnits / 162000.0f), (float)0.0f, (float)1.0f);
        fluidLevel = 1.0f - (1.0f - fluidLevel) * (1.0f - fluidLevel);
        state.layer = RenderTypes.translucentMovingBlock();
        state.fluids = fluids;
        state.yMin = 0.125f;
        state.yMax = state.yMin + 0.75f * fluidLevel;
        state.zMin = 0.125f;
        state.zMax = 0.875f;
        return state.yMax;
    }

    public void updateIngredients(BasinBlockEntity be, BasinRenderState state, float partialTicks, float fluidLevel) {
        BasinInventory inv = be.itemCapability;
        if (inv == null) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int size = inv.getContainerSize();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack = inv.getItem(slot);
            if (stack.isEmpty()) continue;
            stacks.add(stack);
        }
        int itemCount = stacks.size();
        if (itemCount == 0) {
            return;
        }
        float level = Mth.clamp((float)(fluidLevel - 0.3f), (float)0.125f, (float)0.6f);
        RandomSource r = RandomSource.create((long)state.blockPos.hashCode());
        Vec3 baseVector = new Vec3(itemCount == 1 ? 0.0 : 0.125, (double)level, 0.0);
        Level world = be.getLevel();
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)world);
        float anglePartition = 360.0f / (float)itemCount;
        IngredientRenderData[] ingredients = new IngredientRenderData[itemCount];
        int size2 = itemCount;
        for (int i = 0; i < size2; ++i) {
            ItemStack stack = (ItemStack)stacks.get(i);
            Vec3 itemPosition = VecHelper.rotate(baseVector, anglePartition * (float)itemCount, Direction.Axis.Y);
            if (fluidLevel > 0.0f) {
                itemPosition = itemPosition.add(0.0, (double)((Mth.sin((double)(time / 12.0f + anglePartition * (float)itemCount)) + 1.5f) * 1.0f / 32.0f), 0.0);
            }
            float yRot = (float)Math.PI / 180 * (anglePartition * (float)itemCount + 35.0f);
            ItemStackRenderState renderState = new ItemStackRenderState();
            renderState.displayContext = ItemDisplayContext.GROUND;
            this.itemModelManager.appendItemLayers(renderState, stack, renderState.displayContext, world, null, 0);
            int count = stack.getCount() / 8 + 1;
            Vec3[] offsets = new Vec3[count];
            for (int j = 0; j < count; ++j) {
                offsets[j] = VecHelper.offsetRandomly(Vec3.ZERO, r, 0.0625f);
            }
            ingredients[i] = new IngredientRenderData(renderState, itemPosition, yRot, offsets);
            --itemCount;
        }
        state.ingredientYRot = (float)Math.PI / 180 * be.ingredientRotation.getValue(partialTicks);
        state.ingredientXRot = 1.134464f;
        state.ingredients = ingredients;
    }

    private void updateOutputs(BasinBlockEntity be, BasinRenderState state, float partialTicks) {
        if (!(state.blockState.getBlock() instanceof BasinBlock)) {
            return;
        }
        Direction direction = (Direction)state.blockState.getValue(BasinBlock.FACING);
        if (direction == Direction.DOWN) {
            return;
        }
        List<IntAttached<ItemStack>> visualizedOutputItems = be.visualizedOutputItems;
        if (visualizedOutputItems.isEmpty()) {
            return;
        }
        Vec3 directionVec = Vec3.atLowerCornerOf((Vec3i)direction.getUnitVec3i());
        Vec3 outVec = VecHelper.getCenterOf((Vec3i)BlockPos.ZERO).add(directionVec.scale(0.55).subtract(0.0, 0.5, 0.0));
        Level world = be.getLevel();
        boolean outToBasin = world.getBlockState(state.blockPos.relative(direction)).getBlock() instanceof BasinBlock;
        ArrayList<OutputItemRenderData> outputs = new ArrayList<OutputItemRenderData>();
        for (IntAttached<ItemStack> intAttached : visualizedOutputItems) {
            float progress = 1.0f - ((float)((Integer)intAttached.getFirst()).intValue() - partialTicks) / 10.0f;
            if (!outToBasin && progress > 0.35f) continue;
            Vec3 offset = outVec.add(0.0, (double)Math.max(-0.55f, -(progress * progress * 2.0f)), 0.0).add(directionVec.scale((double)(progress * 0.5f)));
            float xRot = (float)Math.PI / 180 * progress * 180.0f;
            ItemStackRenderState renderState = new ItemStackRenderState();
            renderState.displayContext = ItemDisplayContext.GROUND;
            this.itemModelManager.appendItemLayers(renderState, intAttached.getValue(), renderState.displayContext, world, null, 0);
            outputs.add(new OutputItemRenderData(renderState, offset, xRot));
        }
        if (outputs.isEmpty()) {
            return;
        }
        state.outputYRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(direction);
        state.outputs = outputs;
    }

    public int getViewDistance() {
        return 16;
    }

    public static class BasinRenderState
    extends SmartBlockEntityRenderer.SmartRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public float yMin;
        public float yMax;
        public float zMin;
        public float zMax;
        public List<FluidRenderData> fluids;
        public float ingredientYRot;
        public float ingredientXRot;
        public IngredientRenderData[] ingredients;
        public float outputYRot;
        public List<OutputItemRenderData> outputs;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            for (FluidRenderData data : this.fluids) {
                FluidRenderHelper.renderFluidBox(data.fluid, data.changes, data.xMin, this.yMin, this.zMin, data.xMax, this.yMax, this.zMax, vertexConsumer, matricesEntry, this.lightCoords, false, false);
            }
        }
    }

    public record IngredientRenderData(ItemStackRenderState renderState, Vec3 itemPosition, float yRot, Vec3[] offsets) {
    }

    public record OutputItemRenderData(ItemStackRenderState renderState, Vec3 offset, float xRot) {
    }

    public record FluidRenderData(Fluid fluid, DataComponentPatch changes, float xMin, float xMax) {
    }
}

