/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.processing.burner;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.processing.burner.BlazeBurnerRenderer;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class BlazeBurnerMovementRenderBehaviour
implements MovementRenderBehaviour {
    public void tick(MovementContext context) {
        if (!this.shouldRender(context)) {
            return;
        }
        RandomSource r = context.world.getRandom();
        Vec3 c = context.position;
        Vec3 v = c.add(VecHelper.offsetRandomly(Vec3.ZERO, r, 0.125f).multiply(1.0, 0.0, 1.0));
        if (r.nextInt(3) == 0 && context.motion.length() < 0.015625) {
            context.world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, v.x, v.y, v.z, 0.0, 0.0, 0.0);
        }
        LerpedFloat headAngle = this.getHeadAngle(context);
        boolean quickTurn = this.shouldRenderHat(context) && !Mth.equal((double)context.relativeMotion.length(), (double)0.0);
        headAngle.chase(headAngle.getValue() + AngleHelper.getShortestAngleDiff(headAngle.getValue(), this.getTargetAngle(context)), 0.5, quickTurn ? LerpedFloat.Chaser.EXP : LerpedFloat.Chaser.exp(5.0));
        headAngle.tickChaser();
    }

    private boolean shouldRender(MovementContext context) {
        return context.state.getValueOrElse(BlazeBurnerBlock.HEAT_LEVEL, (Comparable)((Object)BlazeBurnerBlock.HeatLevel.NONE)) != BlazeBurnerBlock.HeatLevel.NONE;
    }

    private LerpedFloat getHeadAngle(MovementContext context) {
        if (!(context.temporaryData instanceof LerpedFloat)) {
            context.temporaryData = LerpedFloat.angular().startWithValue(this.getTargetAngle(context));
        }
        return (LerpedFloat)context.temporaryData;
    }

    private float getTargetAngle(MovementContext context) {
        AbstractContraptionEntity abstractContraptionEntity;
        if (this.shouldRenderHat(context) && !Mth.equal((double)context.relativeMotion.length(), (double)0.0) && (abstractContraptionEntity = context.contraption.entity) instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
            float angle = AngleHelper.deg(-Mth.atan2((double)context.relativeMotion.x, (double)context.relativeMotion.z));
            return cce.getInitialOrientation().getAxis() == Direction.Axis.X ? angle + 180.0f : angle;
        }
        Entity player = Minecraft.getInstance().getCameraEntity();
        if (player != null && !player.isInvisible() && context.position != null) {
            Vec3 applyRotation = context.contraption.entity.reverseRotation(player.position().subtract(context.position), 1.0f);
            double dx = applyRotation.x;
            double dz = applyRotation.z;
            return AngleHelper.deg(-Mth.atan2((double)dz, (double)dx)) - 90.0f;
        }
        return 0.0f;
    }

    private boolean shouldRenderHat(MovementContext context) {
        CarriageContraptionEntity cce;
        AbstractContraptionEntity abstractContraptionEntity;
        CompoundTag data = context.data;
        if (!data.contains("Conductor")) {
            data.putBoolean("Conductor", this.determineIfConducting(context));
        }
        return data.getBooleanOr("Conductor", false) && (abstractContraptionEntity = context.contraption.entity) instanceof CarriageContraptionEntity && (cce = (CarriageContraptionEntity)abstractContraptionEntity).hasSchedule();
    }

    private boolean determineIfConducting(MovementContext context) {
        Contraption contraption = context.contraption;
        if (!(contraption instanceof CarriageContraption)) {
            return false;
        }
        CarriageContraption carriageContraption = (CarriageContraption)contraption;
        Direction assemblyDirection = carriageContraption.getAssemblyDirection();
        for (Direction direction : Iterate.directionsInAxis(assemblyDirection.getAxis())) {
            if (!carriageContraption.inControl(context.localPos, direction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MovementRenderState getRenderState(Vec3 camera, Font textRenderer, MovementContext context, VirtualRenderWorld renderWorld, Matrix4f worldMatrix4f) {
        if (!this.shouldRender(context)) {
            return null;
        }
        BlockState blockState = context.state;
        BlazeBurnerBlock.HeatLevel heatLevel = BlazeBurnerBlock.getHeatLevelOf(blockState);
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return null;
        }
        if (!heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            heatLevel = BlazeBurnerBlock.HeatLevel.FADING;
        }
        BlazeBurnerMovementRenderState state = new BlazeBurnerMovementRenderState(context.localPos);
        Level level = context.world;
        float horizontalAngle = AngleHelper.rad(this.getHeadAngle(context).getValue(AnimationTickHolder.getPartialTicks((LevelAccessor)level)));
        boolean drawGoggles = context.blockEntityData.contains("Goggles");
        boolean drawHat = this.shouldRenderHat(context) || context.blockEntityData.contains("TrainHat");
        int hashCode = context.hashCode();
        state.data = BlazeBurnerRenderer.getBlazeBurnerRenderData(level, blockState, heatLevel, 0.0f, horizontalAngle, false, drawGoggles, drawHat ? AllPartialModels.TRAIN_HAT : null, hashCode);
        return state;
    }

    public static class BlazeBurnerMovementRenderState
    extends MovementRenderState {
        public BlazeBurnerRenderer.BlazeBurnerRenderData data;

        public BlazeBurnerMovementRenderState(BlockPos pos) {
            super(pos);
        }

        @Override
        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            this.data.render(matrices, queue);
        }
    }
}

