/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.processing.burner;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BlazeBurnerRenderer
implements BlockEntityRenderer<BlazeBurnerBlockEntity, BlazeBurnerRenderState> {
    public BlazeBurnerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public BlazeBurnerRenderState createRenderState() {
        return new BlazeBurnerRenderState();
    }

    public void extractRenderState(BlazeBurnerBlockEntity be, BlazeBurnerRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlazeBurnerBlock.HeatLevel heatLevel = be.getHeatLevelForRender();
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        Level level = be.getLevel();
        float animation = be.headAnimation.getValue(tickProgress) * 0.175f;
        float horizontalAngle = AngleHelper.rad(be.headAngle.getValue(tickProgress));
        boolean canDrawFlame = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
        boolean drawGoggles = be.goggles;
        PartialModel drawHat = be.hat ? AllPartialModels.TRAIN_HAT : (be.stockKeeper ? AllPartialModels.LOGISTICS_HAT : null);
        int hashCode = be.hashCode();
        state.data = BlazeBurnerRenderer.getBlazeBurnerRenderData(level, state.blockState, heatLevel, animation, horizontalAngle, canDrawFlame, drawGoggles, drawHat, hashCode);
    }

    public void submit(BlazeBurnerRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        state.data.render(matrices, queue);
    }

    public static PartialModel getBlazeModel(BlazeBurnerBlock.HeatLevel heatLevel, boolean blockAbove) {
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            return blockAbove ? AllPartialModels.BLAZE_SUPER_ACTIVE : AllPartialModels.BLAZE_SUPER;
        }
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            return blockAbove && heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.KINDLED) ? AllPartialModels.BLAZE_ACTIVE : AllPartialModels.BLAZE_IDLE;
        }
        return AllPartialModels.BLAZE_INERT;
    }

    public static void tickAnimation(BlazeBurnerBlockEntity be) {
        boolean active;
        boolean bl = active = be.getHeatLevelFromBlock().isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) && be.isValidBlockAbove();
        if (!active) {
            float target = 0.0f;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && !player.isInvisible()) {
                double z;
                double x;
                if (be.isVirtual()) {
                    x = -4.0;
                    z = -10.0;
                } else {
                    x = player.getX();
                    z = player.getZ();
                }
                double dx = x - ((double)be.getBlockPos().getX() + 0.5);
                double dz = z - ((double)be.getBlockPos().getZ() + 0.5);
                target = AngleHelper.deg(-Mth.atan2((double)dz, (double)dx)) - 90.0f;
            }
            target = be.headAngle.getValue() + AngleHelper.getShortestAngleDiff(be.headAngle.getValue(), target);
            be.headAngle.chase(target, 0.25, LerpedFloat.Chaser.exp(5.0));
            be.headAngle.tickChaser();
        } else {
            be.headAngle.chase((AngleHelper.horizontalAngle(be.getBlockState().getOptionalValue((Property)BlazeBurnerBlock.FACING).orElse(Direction.SOUTH)) + 180.0f) % 360.0f, 0.125, LerpedFloat.Chaser.EXP);
            be.headAngle.tickChaser();
        }
        be.headAnimation.chase(active ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.exp(0.25));
        be.headAnimation.tickChaser();
    }

    public static BlazeBurnerRenderData getBlazeBurnerRenderData(Level level, BlockState blockState, BlazeBurnerBlock.HeatLevel heatLevel, float animation, float horizontalAngle, boolean canDrawFlame, boolean drawGoggles, @Nullable PartialModel drawHat, int hashCode) {
        BlazeBurnerRenderData data = new BlazeBurnerRenderData();
        data.layer = RenderTypes.solidMovingBlock();
        data.horizontalAngle = horizontalAngle;
        boolean blockAbove = animation > 0.125f;
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)level);
        float renderTick = time / 16.0f + (float)(hashCode % 13);
        float offsetMult = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? 64.0f : 16.0f;
        float offset = Mth.sin((double)(renderTick % ((float)Math.PI * 2))) / offsetMult;
        float offset1 = Mth.sin((double)((float)(((double)renderTick + Math.PI) % 6.2831854820251465))) / offsetMult;
        float offset2 = Mth.sin((double)((renderTick + 1.5707964f) % ((float)Math.PI * 2))) / offsetMult;
        data.headY = offset - animation * 0.75f;
        PartialModel blazeModel = BlazeBurnerRenderer.getBlazeModel(heatLevel, blockAbove);
        data.blaze = CachedBuffers.partial(blazeModel, blockState);
        if (drawGoggles) {
            PartialModel gogglesModel = blazeModel == AllPartialModels.BLAZE_INERT ? AllPartialModels.BLAZE_GOGGLES_SMALL : AllPartialModels.BLAZE_GOGGLES;
            data.goggles = CachedBuffers.partial(gogglesModel, blockState);
            data.gogglesHeadY = data.headY + 0.5f;
        }
        if (drawHat != null) {
            boolean scale;
            data.hat = new HatRenderState();
            data.hat.scale = scale = blazeModel == AllPartialModels.BLAZE_INERT;
            data.hat.offset = data.headY + (scale ? 0.5f : 0.75f);
            data.hat.layer = RenderTypes.cutoutMovingBlock();
            data.hat.model = CachedBuffers.partial(drawHat, blockState);
            data.hat.angle = horizontalAngle + (float)Math.PI;
        }
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            PartialModel rodsModel = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS : AllPartialModels.BLAZE_BURNER_RODS;
            PartialModel rodsModel2 = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2;
            data.rods = CachedBuffers.partial(rodsModel, blockState);
            data.rodsY = offset1 + animation + 0.125f;
            data.rods2 = CachedBuffers.partial(rodsModel2, blockState);
            data.rods2Y = offset2 + animation - 0.1875f;
        }
        if (canDrawFlame && blockAbove) {
            data.flame = new FlameRenderState();
            data.flame.layer = RenderTypes.cutoutMovingBlock();
            data.flame.model = CachedBuffers.partial(AllPartialModels.BLAZE_BURNER_FLAME, blockState);
            data.flame.angle = horizontalAngle;
            data.flame.spriteShift = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
            TextureAtlasSprite target = data.flame.spriteShift.getTarget();
            float spriteWidth = target.getU1() - target.getU0();
            float spriteHeight = target.getV1() - target.getV0();
            float speed = 0.03125f + 0.015625f * (float)heatLevel.ordinal();
            double vScroll = speed * time;
            vScroll -= Math.floor(vScroll);
            vScroll = vScroll * (double)spriteHeight / 2.0;
            data.flame.vScroll = (float)vScroll;
            double uScroll = speed * time / 2.0f;
            uScroll -= Math.floor(uScroll);
            uScroll = uScroll * (double)spriteWidth / 2.0;
            data.flame.uScroll = (float)uScroll;
        }
        return data;
    }

    public static class BlazeBurnerRenderState
    extends BlockEntityRenderState {
        public BlazeBurnerRenderData data;
    }

    public static class BlazeBurnerRenderData
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public float headY;
        public float horizontalAngle;
        public SuperByteBuffer blaze;
        public SuperByteBuffer goggles;
        public float gogglesHeadY;
        public HatRenderState hat;
        public SuperByteBuffer rods;
        public float rodsY;
        public SuperByteBuffer rods2;
        public float rods2Y;
        public FlameRenderState flame;

        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            queue.submitCustomGeometry(matrices, this.layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
            if (this.hat != null) {
                queue.submitCustomGeometry(matrices, this.hat.layer, (SubmitNodeCollector.CustomGeometryRenderer)this.hat);
            }
            if (this.flame != null) {
                queue.submitCustomGeometry(matrices, this.flame.layer, (SubmitNodeCollector.CustomGeometryRenderer)this.flame);
            }
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.blaze.translate(0.0f, this.headY, 0.0f);
            this.blaze.rotateCentered(this.horizontalAngle, Direction.UP);
            this.blaze.light(0xF000F0);
            this.blaze.renderInto(matricesEntry, vertexConsumer);
            if (this.goggles != null) {
                this.goggles.translate(0.0f, this.gogglesHeadY, 0.0f);
                this.goggles.rotateCentered(this.horizontalAngle, Direction.UP);
                this.goggles.light(0xF000F0);
                this.goggles.renderInto(matricesEntry, vertexConsumer);
            }
            if (this.rods != null) {
                this.rods.translate(0.0f, this.rodsY, 0.0f);
                this.rods.light(0xF000F0);
                this.rods.renderInto(matricesEntry, vertexConsumer);
                this.rods2.translate(0.0f, this.rods2Y, 0.0f);
                this.rods2.light(0xF000F0);
                this.rods2.renderInto(matricesEntry, vertexConsumer);
            }
        }
    }

    public static class HatRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer model;
        public float angle;
        public boolean scale;
        public float offset;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.model.translate(0.0f, this.offset, 0.0f);
            if (this.scale) {
                this.model.scale(0.75f);
            }
            this.model.rotateCentered(this.angle, Direction.UP);
            this.model.translate(0.5f, 0.0f, 0.5f);
            this.model.light(0xF000F0);
            this.model.renderInto(matricesEntry, vertexConsumer);
        }
    }

    public static class FlameRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer model;
        public SpriteShiftEntry spriteShift;
        public float uScroll;
        public float vScroll;
        public float angle;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.model.shiftUVScrolling(this.spriteShift, this.uScroll, this.vScroll);
            this.model.rotateCentered(this.angle, Direction.UP);
            this.model.light(0xF000F0);
            this.model.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

