/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.redstone.DirectedDirectionalBlock;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FilteredDetectorFilterSlot
extends ValueBoxTransform.Sided {
    private final boolean hasSlotAtBottom;

    public FilteredDetectorFilterSlot(boolean hasSlotAtBottom) {
        this.hasSlotAtBottom = hasSlotAtBottom;
    }

    @Override
    protected boolean isSideActive(BlockState state, Direction direction) {
        Direction targetDirection = DirectedDirectionalBlock.getTargetDirection(state);
        if (direction == targetDirection) {
            return false;
        }
        if (targetDirection.getOpposite() == direction) {
            return true;
        }
        if (targetDirection.getAxis() != Direction.Axis.Y) {
            return direction == Direction.UP || direction == Direction.DOWN && this.hasSlotAtBottom;
        }
        if (targetDirection == Direction.UP) {
            direction = direction.getOpposite();
        }
        if (!this.hasSlotAtBottom) {
            return direction == state.getValue((Property)DirectedDirectionalBlock.FACING);
        }
        return direction.getAxis() == ((Direction)state.getValue((Property)DirectedDirectionalBlock.FACING)).getClockWise().getAxis();
    }

    @Override
    public void rotate(BlockState state, PoseStack ms) {
        super.rotate(state, ms);
        Direction facing = (Direction)state.getValue((Property)DirectedDirectionalBlock.FACING);
        if (facing.getAxis() == Direction.Axis.Y) {
            return;
        }
        if (this.getSide() != Direction.UP) {
            return;
        }
        TransformStack.of(ms).rotateZDegrees(-AngleHelper.horizontalAngle(facing) + 180.0f);
    }

    @Override
    protected Vec3 getSouthLocation() {
        return VecHelper.voxelSpace(8.0, 8.0, 15.5);
    }
}

