/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.analogLever;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.redstone.analogLever.AnalogLeverBlock;
import com.zurrtum.create.content.redstone.analogLever.AnalogLeverBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AnalogLeverRenderer
implements BlockEntityRenderer<AnalogLeverBlockEntity, AnalogLeverRenderState> {
    public AnalogLeverRenderer(BlockEntityRendererProvider.Context context) {
    }

    public AnalogLeverRenderState createRenderState() {
        return new AnalogLeverRenderState();
    }

    public void extractRenderState(AnalogLeverBlockEntity be, AnalogLeverRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        state.layer = RenderTypes.solidMovingBlock();
        float level = be.clientState.getValue(tickProgress);
        state.angle = (float)((double)(level / 15.0f * 90.0f / 180.0f) * Math.PI);
        state.handle = CachedBuffers.partial(AllPartialModels.ANALOG_LEVER_HANDLE, state.blockState);
        AttachFace face = (AttachFace)state.blockState.getValue((Property)AnalogLeverBlock.FACE);
        float rX = face == AttachFace.FLOOR ? 0.0f : (face == AttachFace.WALL ? 90.0f : 180.0f);
        float rY = AngleHelper.horizontalAngle((Direction)state.blockState.getValue((Property)AnalogLeverBlock.FACING));
        state.xRot = (float)Math.PI / 180 * rX;
        state.yRot = (float)Math.PI / 180 * rY;
        state.indicator = CachedBuffers.partial(AllPartialModels.ANALOG_LEVER_INDICATOR, state.blockState);
        state.color = Color.mixColors(2884352, 0xCD0000, level / 15.0f);
    }

    public void submit(AnalogLeverRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    private SuperByteBuffer transform(SuperByteBuffer buffer, BlockState leverState) {
        AttachFace face = (AttachFace)leverState.getValue((Property)AnalogLeverBlock.FACE);
        float rX = face == AttachFace.FLOOR ? 0.0f : (face == AttachFace.WALL ? 90.0f : 180.0f);
        float rY = AngleHelper.horizontalAngle((Direction)leverState.getValue((Property)AnalogLeverBlock.FACING));
        buffer.rotateCentered((float)((double)(rY / 180.0f) * Math.PI), Direction.UP);
        buffer.rotateCentered((float)((double)(rX / 180.0f) * Math.PI), Direction.EAST);
        return buffer;
    }

    public static class AnalogLeverRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public float angle;
        public SuperByteBuffer handle;
        public float xRot;
        public float yRot;
        public SuperByteBuffer indicator;
        public int color;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.handle.rotateCentered(this.yRot, Direction.UP);
            this.handle.rotateCentered(this.xRot, Direction.EAST);
            ((SuperByteBuffer)((SuperByteBuffer)this.handle.translate(0.5f, 0.0625f, 0.5f)).rotate(this.angle, Direction.EAST)).translate(-0.5f, -0.0625f, -0.5f);
            this.handle.light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            this.indicator.rotateCentered(this.yRot, Direction.UP);
            this.indicator.rotateCentered(this.xRot, Direction.EAST);
            this.indicator.light(this.lightCoords).color(this.color).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

