/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.analogLever;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.transform.Rotate;
import com.zurrtum.create.client.flywheel.lib.transform.Translate;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.redstone.analogLever.AnalogLeverBlock;
import com.zurrtum.create.content.redstone.analogLever.AnalogLeverBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;

public class AnalogLeverVisual
extends AbstractBlockEntityVisual<AnalogLeverBlockEntity>
implements SimpleDynamicVisual {
    protected final TransformedInstance handle = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ANALOG_LEVER_HANDLE)).createInstance();
    protected final TransformedInstance indicator = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.ANALOG_LEVER_INDICATOR)).createInstance();
    final float rX;
    final float rY;

    public AnalogLeverVisual(VisualizationContext context, AnalogLeverBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        AttachFace face = (AttachFace)this.blockState.getValue((Property)AnalogLeverBlock.FACE);
        this.rX = face == AttachFace.FLOOR ? 0.0f : (face == AttachFace.WALL ? 90.0f : 180.0f);
        this.rY = AngleHelper.horizontalAngle((Direction)this.blockState.getValue((Property)AnalogLeverBlock.FACING));
        this.transform(this.indicator.setIdentityTransform());
        this.animateLever(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        if (!((AnalogLeverBlockEntity)this.blockEntity).clientState.settled()) {
            this.animateLever(ctx.partialTick());
        }
    }

    protected void animateLever(float pt) {
        float state = ((AnalogLeverBlockEntity)this.blockEntity).clientState.getValue(pt);
        this.indicator.colorRgb(Color.mixColors(2884352, 0xCD0000, state / 15.0f));
        this.indicator.setChanged();
        float angle = (float)((double)(state / 15.0f * 90.0f / 180.0f) * Math.PI);
        ((TransformedInstance)this.transform(this.handle.setIdentityTransform()).translate(0.5f, 0.0625f, 0.5f).rotate(angle, Direction.EAST)).translate(-0.5f, -0.0625f, -0.5f).setChanged();
    }

    @Override
    protected void _delete() {
        this.handle.delete();
        this.indicator.delete();
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.handle, this.indicator);
    }

    private <T extends Translate<T> & Rotate<T>> T transform(T msr) {
        return (T)((Translate)((Rotate)((Object)((Translate)((Rotate)msr.translate((Vec3i)this.getVisualPosition()).center()).rotate((float)((double)(this.rY / 180.0f) * Math.PI), Direction.UP)))).rotate((float)((double)(this.rX / 180.0f) * Math.PI), Direction.EAST)).uncenter();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept(this.handle);
        consumer.accept(this.indicator);
    }
}

