/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.displayLink;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.api.behaviour.display.ClickToLinkSelection;
import com.zurrtum.create.api.behaviour.display.DisplayTarget;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.content.redstone.displayLink.ClickToLinkBlockItem;
import com.zurrtum.create.infrastructure.component.ClickToLinkData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClickToLinkHandler {
    private static BlockPos lastShownPos = null;
    private static AABB lastShownAABB = null;

    public static void clientTick(Minecraft mc) {
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack heldItemMainhand = player.getMainHandItem();
        Item item = heldItemMainhand.getItem();
        if (!(item instanceof ClickToLinkBlockItem)) {
            return;
        }
        ClickToLinkBlockItem blockItem = (ClickToLinkBlockItem)item;
        if (!heldItemMainhand.has(AllDataComponents.CLICK_TO_LINK_DATA)) {
            return;
        }
        BlockPos selectedPos = ((ClickToLinkData)heldItemMainhand.get(AllDataComponents.CLICK_TO_LINK_DATA)).selectedPos();
        if (!selectedPos.equals((Object)lastShownPos)) {
            if (blockItem instanceof ClickToLinkSelection) {
                ClickToLinkSelection item2 = (ClickToLinkSelection)((Object)blockItem);
                lastShownAABB = item2.getSelectionBounds((Level)mc.level, selectedPos);
            } else {
                lastShownAABB = ClickToLinkHandler.getSelectionBounds((Level)mc.level, selectedPos);
            }
            lastShownPos = selectedPos;
        }
        Outliner.getInstance().showAABB("target", lastShownAABB).colored(16763764).lineWidth(0.0625f);
    }

    public static AABB getSelectionBounds(Level world, BlockPos pos) {
        DisplayTarget target = DisplayTarget.get((LevelAccessor)world, pos);
        if (target != null) {
            return target.getMultiblockBounds((LevelAccessor)world, pos);
        }
        VoxelShape shape = world.getBlockState(pos).getShape((BlockGetter)world, pos);
        return shape.isEmpty() ? new AABB(BlockPos.ZERO) : shape.bounds().move(pos);
    }
}

