/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.displayLink;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.api.behaviour.display.DisplayTarget;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.api.behaviour.display.DisplaySourceRender;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.ModularGuiLine;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.ponder.AllCreatePonderTags;
import com.zurrtum.create.client.ponder.foundation.ui.PonderTagScreen;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.zurrtum.create.infrastructure.packet.c2s.DisplayLinkConfigurationPacket;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix3x2fStack;

public class DisplayLinkScreen
extends AbstractSimiScreen {
    private static final ItemStack FALLBACK = new ItemStack((ItemLike)Items.BARRIER);
    private AllGuiTextures background = AllGuiTextures.DATA_GATHERER;
    private DisplayLinkBlockEntity blockEntity;
    private IconButton confirmButton;
    private ElementWidget renderedItem;
    BlockState sourceState;
    BlockState targetState;
    List<DisplaySource> sources;
    DisplayTarget target;
    ScrollInput sourceTypeSelector;
    Label sourceTypeLabel;
    ScrollInput targetLineSelector;
    Label targetLineLabel;
    AbstractSimiWidget sourceWidget;
    AbstractSimiWidget targetWidget;
    Couple<ModularGuiLine> configWidgets;

    public DisplayLinkScreen(DisplayLinkBlockEntity be) {
        this.blockEntity = be;
        this.sources = Collections.emptyList();
        this.configWidgets = Couple.create(ModularGuiLine::new);
        this.target = null;
    }

    @Override
    protected void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        super.init();
        this.clearWidgets();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.initGathererOptions();
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::onClose);
        this.addRenderableWidget(this.confirmButton);
        this.renderedItem = new ElementWidget(x + this.background.getWidth() - 11, y + this.background.getHeight() - 55).showingElement(GuiGameElement.of(AllItems.DISPLAY_LINK.getDefaultInstance()).scale(4.0f).rotate(50.0f, 207.0f, -14.0f).padding(17));
        this.addRenderableWidget(this.renderedItem);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.sourceState != null && this.sourceState.getBlock() != this.minecraft.level.getBlockState(this.blockEntity.getSourcePosition()).getBlock() || this.targetState != null && this.targetState.getBlock() != this.minecraft.level.getBlockState(this.blockEntity.getTargetPosition()).getBlock()) {
            this.initGathererOptions();
        }
    }

    private void initGathererOptions() {
        ClientLevel level = this.minecraft.level;
        this.sourceState = level.getBlockState(this.blockEntity.getSourcePosition());
        this.targetState = level.getBlockState(this.blockEntity.getTargetPosition());
        int x = this.guiLeft;
        int y = this.guiTop;
        Block sourceBlock = this.sourceState.getBlock();
        Block targetBlock = this.targetState.getBlock();
        ItemStack asItem = this.sourceState.getCloneItemStack((LevelReader)level, this.blockEntity.getSourcePosition(), true);
        ItemStack sourceIcon = asItem == null || asItem.isEmpty() ? FALLBACK : asItem;
        asItem = this.targetState.getCloneItemStack((LevelReader)level, this.blockEntity.getTargetPosition(), true);
        ItemStack targetIcon = asItem == null || asItem.isEmpty() ? FALLBACK : asItem;
        this.sources = DisplaySource.getAll((LevelAccessor)level, this.blockEntity.getSourcePosition());
        this.target = DisplayTarget.get((LevelAccessor)level, this.blockEntity.getTargetPosition());
        this.removeWidget(this.targetLineSelector);
        this.removeWidget(this.targetLineLabel);
        this.removeWidget(this.sourceTypeSelector);
        this.removeWidget(this.sourceTypeLabel);
        this.removeWidget(this.sourceWidget);
        this.removeWidget(this.targetWidget);
        this.configWidgets.forEach(s -> s.forEach(this::removeWidget));
        this.targetLineSelector = null;
        this.sourceTypeSelector = null;
        if (this.target != null) {
            DisplayTargetStats stats = this.target.provideStats(new DisplayLinkContext((Level)level, this.blockEntity));
            int rows = stats.maxRows();
            int startIndex = Math.min(this.blockEntity.targetLine, rows);
            this.targetLineLabel = new Label(x + 65, y + 109, CommonComponents.EMPTY).withShadow();
            this.targetLineLabel.text = this.target.getLineOptionText(startIndex);
            if (rows > 1) {
                this.targetLineSelector = new ScrollInput(x + 61, y + 105, 135, 16).withRange(0, rows).titled(CreateLang.translateDirect("display_link.display_on", new Object[0])).inverted().calling(i -> {
                    this.targetLineLabel.text = this.target.getLineOptionText((int)i);
                }).setState(startIndex);
                this.addRenderableWidget(this.targetLineSelector);
            }
            this.addRenderableWidget(this.targetLineLabel);
        }
        this.sourceWidget = ((AbstractSimiWidget)new ElementWidget(x + 37, y + 26).showingElement(GuiGameElement.of(sourceIcon))).withCallback((mX, mY) -> ScreenOpener.open(new PonderTagScreen(AllCreatePonderTags.DISPLAY_SOURCES)));
        this.sourceWidget.getToolTip().addAll(List.of(CreateLang.translateDirect("display_link.reading_from", new Object[0]), this.sourceState.getBlock().getName().withStyle(s -> s.withColor(this.sources.isEmpty() ? 16157065 : 15909229)), CreateLang.translateDirect("display_link.attached_side", new Object[0]), CreateLang.translateDirect("display_link.view_compatible", new Object[0]).withStyle(ChatFormatting.GRAY)));
        this.addRenderableWidget(this.sourceWidget);
        this.targetWidget = ((AbstractSimiWidget)new ElementWidget(x + 37, y + 105).showingElement(GuiGameElement.of(targetIcon))).withCallback((mX, mY) -> ScreenOpener.open(new PonderTagScreen(AllCreatePonderTags.DISPLAY_TARGETS)));
        this.targetWidget.getToolTip().addAll(List.of(CreateLang.translateDirect("display_link.writing_to", new Object[0]), this.targetState.getBlock().getName().withStyle(s -> s.withColor(this.target == null ? 16157065 : 15909229)), CreateLang.translateDirect("display_link.targeted_location", new Object[0]), CreateLang.translateDirect("display_link.view_compatible", new Object[0]).withStyle(ChatFormatting.GRAY)));
        this.addRenderableWidget(this.targetWidget);
        if (!this.sources.isEmpty()) {
            int startIndex = Math.max(this.sources.indexOf(this.blockEntity.activeSource), 0);
            this.sourceTypeLabel = new Label(x + 65, y + 30, CommonComponents.EMPTY).withShadow();
            this.sourceTypeLabel.text = this.sources.get(startIndex).getName();
            if (this.sources.size() > 1) {
                List<Component> options = this.sources.stream().map(DisplaySource::getName).toList();
                this.sourceTypeSelector = new SelectionScrollInput(x + 61, y + 26, 135, 16).forOptions(options).writingTo(this.sourceTypeLabel).titled(CreateLang.translateDirect("display_link.information_type", new Object[0])).calling(this::initGathererSourceSubOptions).setState(startIndex);
                this.sourceTypeSelector.onChanged();
                this.addRenderableWidget(this.sourceTypeSelector);
            } else {
                this.initGathererSourceSubOptions(0);
            }
            this.addRenderableWidget(this.sourceTypeLabel);
        }
    }

    private void initGathererSourceSubOptions(int i) {
        DisplaySource source = this.sources.get(i);
        source.populateData(new DisplayLinkContext(this.blockEntity.getLevel(), this.blockEntity));
        if (this.targetLineSelector != null) {
            this.targetLineSelector.titled(source instanceof SingleLineDisplaySource ? CreateLang.translateDirect("display_link.display_on", new Object[0]) : CreateLang.translateDirect("display_link.display_on_multiline", new Object[0]));
        }
        this.configWidgets.forEach(s -> {
            s.forEach(this::removeWidget);
            s.clear();
        });
        DisplaySourceRender render = (DisplaySourceRender)source.getAttachRender();
        if (render != null) {
            DisplayLinkContext context = new DisplayLinkContext((Level)this.minecraft.level, this.blockEntity);
            this.configWidgets.forEachWithContext((s, first) -> render.initConfigurationWidgets(source, context, new ModularGuiLineBuilder(this.font, (ModularGuiLine)s, this.guiLeft + 60, this.guiTop + (first != false ? 51 : 72)), (boolean)first));
        }
        this.configWidgets.forEach(s -> s.loadValues(this.blockEntity.getSourceConfig(), x$0 -> this.addRenderableWidget((GuiEventListener)x$0), x$0 -> {
            GuiEventListener cfr_ignored_0 = (GuiEventListener)this.addRenderableOnly((Renderable)x$0);
        }));
    }

    public void onClose() {
        super.onClose();
        CompoundTag sourceData = new CompoundTag();
        if (!this.sources.isEmpty()) {
            DisplaySource source = this.sources.get(this.sourceTypeSelector == null ? 0 : this.sourceTypeSelector.getState());
            Identifier id = CreateRegistries.DISPLAY_SOURCE.getKey((Object)source);
            if (id != null) {
                sourceData.putString("Id", id.toString());
            }
            this.configWidgets.forEach(s -> s.saveValues(sourceData));
        }
        this.minecraft.player.connection.send((Packet)new DisplayLinkConfigurationPacket(this.blockEntity.getBlockPos(), sourceData, this.targetLineSelector == null ? 0 : this.targetLineSelector.getState()));
        this.renderedItem.getRenderElement().clear();
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        MutableComponent header = CreateLang.translateDirect("display_link.title", new Object[0]);
        graphics.drawString(this.font, (Component)header, x + this.background.getWidth() / 2 - this.font.width((FormattedText)header) / 2, y + 4, -10935260, false);
        if (this.sources.isEmpty()) {
            graphics.drawString(this.font, (Component)CreateLang.translateDirect("display_link.no_source", new Object[0]), x + 65, y + 30, -2894893, true);
        }
        if (this.target == null) {
            graphics.drawString(this.font, (Component)CreateLang.translateDirect("display_link.no_target", new Object[0]), x + 65, y + 109, -2894893, true);
        }
        Matrix3x2fStack ms = graphics.pose();
        ms.pushMatrix();
        ms.translate(0.0f, (float)(this.guiTop + 46));
        ((ModularGuiLine)this.configWidgets.getFirst()).renderWidgetBG(this.guiLeft, graphics);
        ms.translate(0.0f, 21.0f);
        ((ModularGuiLine)this.configWidgets.getSecond()).renderWidgetBG(this.guiLeft, graphics);
        ms.popMatrix();
    }

    protected void removeWidget(GuiEventListener p_169412_) {
        if (p_169412_ != null) {
            super.removeWidget(p_169412_);
        }
    }
}

