/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.link;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.content.redstone.link.RedstoneLinkFrequencySlot;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LinkBehaviour
extends BlockEntityBehaviour<SmartBlockEntity> {
    public static final BehaviourType<LinkBehaviour> TYPE = new BehaviourType();
    ValueBoxTransform firstSlot = new RedstoneLinkFrequencySlot(true);
    ValueBoxTransform secondSlot = new RedstoneLinkFrequencySlot(false);
    ServerLinkBehaviour behaviour;

    public LinkBehaviour(SmartBlockEntity be) {
        super(be);
    }

    @Override
    public void initialize() {
        this.behaviour = this.blockEntity.getBehaviour(ServerLinkBehaviour.TYPE);
    }

    @Override
    public void onBehaviourAdded(BehaviourType<?> type, BlockEntityBehaviour<?> behaviour) {
        if (type == ServerLinkBehaviour.TYPE) {
            this.behaviour = (ServerLinkBehaviour)behaviour;
        }
    }

    public void setFrequency(boolean first, ItemStack heldItem) {
        this.behaviour.setFrequency(first, heldItem);
    }

    public boolean testHit(Boolean first, Vec3 hit) {
        BlockState state = this.blockEntity.getBlockState();
        Vec3 localHit = hit.subtract(Vec3.atLowerCornerOf((Vec3i)this.blockEntity.getBlockPos()));
        return (first != false ? this.firstSlot : this.secondSlot).testHit((LevelAccessor)this.getLevel(), this.getPos(), state, localHit);
    }

    public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
        return this.behaviour.getNetworkKey();
    }

    public ItemStack getFirstStack() {
        return this.behaviour.frequencyFirst.getStack();
    }

    public ItemStack getLastStack() {
        return this.behaviour.frequencyLast.getStack();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public float getRenderDistance() {
        return AllConfigs.client().filterItemRenderDistance.getF();
    }
}

