/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.link.controller;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.ControlsUtil;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.redstone.link.controller.LinkedControllerMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class LinkedControllerScreen
extends AbstractSimiContainerScreen<LinkedControllerMenu> {
    protected AllGuiTextures background;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private IconButton resetButton;
    private IconButton confirmButton;
    private ElementWidget renderedItem;

    public LinkedControllerScreen(LinkedControllerMenu menu, Inventory inv, Component title) {
        super(menu, inv, title);
        this.background = AllGuiTextures.LINKED_CONTROLLER;
    }

    public static LinkedControllerScreen create(Minecraft mc, MenuType<ItemStack> type, int syncId, Inventory inventory, Component title, RegistryFriendlyByteBuf extraData) {
        return (LinkedControllerScreen)((Object)type.create(LinkedControllerScreen::new, syncId, inventory, title, LinkedControllerScreen.getStack(extraData)));
    }

    @Override
    protected void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight() + 4 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(1, 0);
        super.init();
        this.resetButton = new IconButton(this.leftPos + this.background.getWidth() - 62, this.topPos + this.background.getHeight() - 24, AllIcons.I_TRASH);
        this.resetButton.withCallback(() -> {
            ((LinkedControllerMenu)this.menu).clearContents();
            this.minecraft.player.connection.send((Packet)AllPackets.CLEAR_CONTAINER);
        });
        this.confirmButton = new IconButton(this.leftPos + this.background.getWidth() - 33, this.topPos + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.minecraft.player.closeContainer());
        this.addRenderableWidget(this.resetButton);
        this.addRenderableWidget(this.confirmButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(this.leftPos + this.background.getWidth() + 4, this.topPos + this.background.getHeight() - 44, 64, 56));
        this.renderedItem = new ElementWidget(this.leftPos + this.background.getWidth() - 4, this.topPos + this.background.getHeight() - 56).showingElement(GuiGameElement.of((ItemStack)((LinkedControllerMenu)this.menu).contentHolder).scale(5.0f));
        this.addRenderableWidget(this.renderedItem);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.topPos + this.background.getHeight() + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        this.background.render(graphics, this.leftPos, this.topPos);
        graphics.drawString(this.font, this.title, this.leftPos + 15, this.topPos + 4, -10935260, false);
    }

    @Override
    protected void containerTick() {
        if (!ItemStack.matches((ItemStack)((LinkedControllerMenu)this.menu).player.getMainHandItem(), (ItemStack)((ItemStack)((LinkedControllerMenu)this.menu).contentHolder))) {
            this.minecraft.player.closeContainer();
        }
        super.containerTick();
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        if (!((LinkedControllerMenu)this.menu).getCarried().isEmpty() || this.hoveredSlot == null || this.hoveredSlot.container == ((LinkedControllerMenu)this.menu).playerInventory) {
            super.renderTooltip(graphics, x, y);
            return;
        }
        List<Object> list = new LinkedList<Component>();
        if (this.hoveredSlot.hasItem()) {
            list = this.getTooltipFromContainerItem(this.hoveredSlot.getItem());
        }
        graphics.setComponentTooltipForNextFrame(this.font, this.addToTooltip(list, this.hoveredSlot.getContainerSlot()), x, y);
    }

    private List<Component> addToTooltip(List<Component> list, int slot) {
        if (slot < 0 || slot >= 12) {
            return list;
        }
        list.add((Component)CreateLang.translateDirect("linked_controller.frequency_slot_" + (slot % 2 + 1), ControlsUtil.getControls().get(slot / 2).getTranslatedKeyMessage().getString()).withStyle(ChatFormatting.GOLD));
        return list;
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

