/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.cannon;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.ScreenElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.catnip.lang.FontHelper;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Indicator;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.zurrtum.create.content.schematics.cannon.SchematicannonMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureSchematicannonPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;

public class SchematicannonScreen
extends AbstractSimiContainerScreen<SchematicannonMenu> {
    private static final AllGuiTextures BG_BOTTOM = AllGuiTextures.SCHEMATICANNON_BOTTOM;
    private static final AllGuiTextures BG_TOP = AllGuiTextures.SCHEMATICANNON_TOP;
    private final Component listPrinter = CreateLang.translateDirect("gui.schematicannon.listPrinter", new Object[0]);
    private final String _gunpowderLevel = "gui.schematicannon.gunpowderLevel";
    private final String _shotsRemaining = "gui.schematicannon.shotsRemaining";
    private final String _showSettings = "gui.schematicannon.showOptions";
    private final String _shotsRemainingWithBackup = "gui.schematicannon.shotsRemainingWithBackup";
    private final String _slotGunpowder = "gui.schematicannon.slot.gunpowder";
    private final String _slotListPrinter = "gui.schematicannon.slot.listPrinter";
    private final String _slotSchematic = "gui.schematicannon.slot.schematic";
    private final Component optionEnabled = CreateLang.translateDirect("gui.schematicannon.optionEnabled", new Object[0]);
    private final Component optionDisabled = CreateLang.translateDirect("gui.schematicannon.optionDisabled", new Object[0]);
    protected List<Indicator> replaceLevelIndicators;
    protected List<IconButton> replaceLevelButtons;
    protected IconButton skipMissingButton;
    protected Indicator skipMissingIndicator;
    protected IconButton skipBlockEntitiesButton;
    protected Indicator skipBlockEntitiesIndicator;
    protected IconButton playButton;
    protected Indicator playIndicator;
    protected IconButton pauseButton;
    protected Indicator pauseIndicator;
    protected IconButton resetButton;
    protected Indicator resetIndicator;
    private IconButton confirmButton;
    private IconButton showSettingsButton;
    private Indicator showSettingsIndicator;
    private ElementWidget renderedItem;
    protected List<AbstractWidget> placementSettingWidgets;
    private List<Rect2i> extraAreas = Collections.emptyList();

    public SchematicannonScreen(SchematicannonMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.placementSettingWidgets = new ArrayList<AbstractWidget>();
    }

    public static SchematicannonScreen create(Minecraft mc, MenuType<SchematicannonBlockEntity> type, int syncId, Inventory inventory, Component title, RegistryFriendlyByteBuf extraData) {
        SchematicannonBlockEntity entity = (SchematicannonBlockEntity)SchematicannonScreen.getBlockEntity(mc, extraData);
        if (entity == null) {
            return null;
        }
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(entity.problemPath(), Create.LOGGER);){
            ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)extraData.registryAccess(), (CompoundTag)extraData.readNbt());
            entity.readClient(view);
            SchematicannonScreen schematicannonScreen = (SchematicannonScreen)((Object)type.create(SchematicannonScreen::new, syncId, inventory, title, entity));
            return schematicannonScreen;
        }
    }

    @Override
    protected void init() {
        this.setWindowSize(BG_TOP.getWidth(), BG_TOP.getHeight() + BG_BOTTOM.getHeight() + 2 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(-11, 0);
        super.init();
        this.playButton = new IconButton(this.leftPos + 75, this.topPos + 85, AllIcons.I_PLAY);
        this.playButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PLAY, true));
        this.playIndicator = new Indicator(this.leftPos + 75, this.topPos + 79, CommonComponents.EMPTY);
        this.pauseButton = new IconButton(this.leftPos + 93, this.topPos + 85, AllIcons.I_PAUSE);
        this.pauseButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PAUSE, true));
        this.pauseIndicator = new Indicator(this.leftPos + 93, this.topPos + 79, CommonComponents.EMPTY);
        this.resetButton = new IconButton(this.leftPos + 111, this.topPos + 85, AllIcons.I_STOP);
        this.resetButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.STOP, true));
        this.resetIndicator = new Indicator(this.leftPos + 111, this.topPos + 79, CommonComponents.EMPTY);
        this.resetIndicator.state = Indicator.State.RED;
        this.addRenderableWidgets(new AbstractSimiWidget[]{this.playButton, this.playIndicator, this.pauseButton, this.pauseIndicator, this.resetButton, this.resetIndicator});
        this.confirmButton = new IconButton(this.leftPos + 180, this.topPos + 111, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.minecraft.player.closeContainer());
        this.addRenderableWidget(this.confirmButton);
        this.showSettingsButton = new IconButton(this.leftPos + 8, this.topPos + 111, AllIcons.I_PLACEMENT_SETTINGS);
        this.showSettingsButton.withCallback(() -> {
            this.showSettingsIndicator.state = this.placementSettingsHidden() ? Indicator.State.GREEN : Indicator.State.OFF;
            this.initPlacementSettings();
        });
        this.showSettingsButton.setToolTip((Component)CreateLang.translateDirect("gui.schematicannon.showOptions", new Object[0]));
        this.addRenderableWidget(this.showSettingsButton);
        this.showSettingsIndicator = new Indicator(this.leftPos + 9, this.topPos + 111, CommonComponents.EMPTY);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(this.leftPos + BG_TOP.getWidth(), this.topPos + BG_TOP.getHeight() + BG_BOTTOM.getHeight() - 62, 84, 92));
        this.renderedItem = new ElementWidget(this.leftPos + BG_TOP.getWidth() - 14, this.topPos + BG_TOP.getHeight() + BG_BOTTOM.getHeight() - 62).showingElement(GuiGameElement.of(AllItems.SCHEMATICANNON.getDefaultInstance()).scale(5.0f).padding(28));
        this.addRenderableWidget(this.renderedItem);
        this.tick();
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
    }

    private void initPlacementSettings() {
        this.removeWidgets(this.placementSettingWidgets);
        this.placementSettingWidgets.clear();
        if (this.placementSettingsHidden()) {
            return;
        }
        this.replaceLevelButtons = new ArrayList<IconButton>(4);
        this.replaceLevelIndicators = new ArrayList<Indicator>(4);
        ImmutableList icons = ImmutableList.of((Object)AllIcons.I_DONT_REPLACE, (Object)AllIcons.I_REPLACE_SOLID, (Object)AllIcons.I_REPLACE_ANY, (Object)AllIcons.I_REPLACE_EMPTY);
        ImmutableList toolTips = ImmutableList.of((Object)CreateLang.translateDirect("gui.schematicannon.option.dontReplaceSolid", new Object[0]), (Object)CreateLang.translateDirect("gui.schematicannon.option.replaceWithSolid", new Object[0]), (Object)CreateLang.translateDirect("gui.schematicannon.option.replaceWithAny", new Object[0]), (Object)CreateLang.translateDirect("gui.schematicannon.option.replaceWithEmpty", new Object[0]));
        for (int i = 0; i < 4; ++i) {
            this.replaceLevelIndicators.add(new Indicator(this.leftPos + 33 + i * 18, this.topPos + 111, CommonComponents.EMPTY));
            IconButton replaceLevelButton = new IconButton(this.leftPos + 33 + i * 18, this.topPos + 111, (ScreenElement)icons.get(i));
            int replaceMode = i;
            replaceLevelButton.withCallback(() -> {
                if (((SchematicannonBlockEntity)((SchematicannonMenu)this.menu).contentHolder).replaceMode != replaceMode) {
                    this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.values()[replaceMode], true);
                }
            });
            replaceLevelButton.setToolTip((Component)toolTips.get(i));
            this.replaceLevelButtons.add(replaceLevelButton);
        }
        this.placementSettingWidgets.addAll(this.replaceLevelButtons);
        this.skipMissingButton = new IconButton(this.leftPos + 111, this.topPos + 111, AllIcons.I_SKIP_MISSING);
        this.skipMissingButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_MISSING, !((SchematicannonBlockEntity)((SchematicannonMenu)this.menu).contentHolder).skipMissing));
        this.skipMissingButton.setToolTip((Component)CreateLang.translateDirect("gui.schematicannon.option.skipMissing", new Object[0]));
        this.skipMissingIndicator = new Indicator(this.leftPos + 111, this.topPos + 111, CommonComponents.EMPTY);
        Collections.addAll(this.placementSettingWidgets, this.skipMissingButton);
        this.skipBlockEntitiesButton = new IconButton(this.leftPos + 135, this.topPos + 111, AllIcons.I_SKIP_BLOCK_ENTITIES);
        this.skipBlockEntitiesButton.withCallback(() -> this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_BLOCK_ENTITIES, !((SchematicannonBlockEntity)((SchematicannonMenu)this.menu).contentHolder).replaceBlockEntities));
        this.skipBlockEntitiesButton.setToolTip((Component)CreateLang.translateDirect("gui.schematicannon.option.skipBlockEntities", new Object[0]));
        this.skipBlockEntitiesIndicator = new Indicator(this.leftPos + 129, this.topPos + 111, CommonComponents.EMPTY);
        Collections.addAll(this.placementSettingWidgets, this.skipBlockEntitiesButton);
        this.addRenderableWidgets(this.placementSettingWidgets);
    }

    protected boolean placementSettingsHidden() {
        return this.showSettingsIndicator.state == Indicator.State.OFF;
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        SchematicannonBlockEntity be = (SchematicannonBlockEntity)((SchematicannonMenu)this.menu).contentHolder;
        if (!this.placementSettingsHidden()) {
            for (int replaceMode = 0; replaceMode < this.replaceLevelButtons.size(); ++replaceMode) {
                this.replaceLevelButtons.get((int)replaceMode).green = replaceMode == be.replaceMode;
                this.replaceLevelIndicators.get((int)replaceMode).state = replaceMode == be.replaceMode ? Indicator.State.ON : Indicator.State.OFF;
            }
            this.skipMissingButton.green = be.skipMissing;
            this.skipBlockEntitiesButton.green = !be.replaceBlockEntities;
        }
        this.playIndicator.state = Indicator.State.OFF;
        this.pauseIndicator.state = Indicator.State.OFF;
        this.resetIndicator.state = Indicator.State.OFF;
        switch (be.state) {
            case PAUSED: {
                this.pauseIndicator.state = Indicator.State.YELLOW;
                this.playButton.active = true;
                this.pauseButton.active = false;
                this.resetButton.active = true;
                break;
            }
            case RUNNING: {
                this.playIndicator.state = Indicator.State.GREEN;
                this.playButton.active = false;
                this.pauseButton.active = true;
                this.resetButton.active = true;
                break;
            }
            case STOPPED: {
                this.resetIndicator.state = Indicator.State.RED;
                this.playButton.active = true;
                this.pauseButton.active = false;
                this.resetButton.active = false;
                break;
            }
        }
        this.handleTooltips();
    }

    protected void handleTooltips() {
        if (this.placementSettingsHidden()) {
            return;
        }
        boolean hasShiftDown = AllKeys.hasShiftDown();
        for (AbstractWidget w : this.placementSettingWidgets) {
            IconButton button;
            if (!(w instanceof IconButton) || (button = (IconButton)w).getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().getFirst());
            button.getToolTip().add((Component)TooltipHelper.holdShift(FontHelper.Palette.BLUE, hasShiftDown));
        }
        if (hasShiftDown) {
            this.fillToolTip(this.skipMissingButton, this.skipMissingIndicator, "skipMissing");
            this.fillToolTip(this.skipBlockEntitiesButton, this.skipBlockEntitiesIndicator, "skipBlockEntities");
            this.fillToolTip(this.replaceLevelButtons.get(0), this.replaceLevelIndicators.get(0), "dontReplaceSolid");
            this.fillToolTip(this.replaceLevelButtons.get(1), this.replaceLevelIndicators.get(1), "replaceWithSolid");
            this.fillToolTip(this.replaceLevelButtons.get(2), this.replaceLevelIndicators.get(2), "replaceWithAny");
            this.fillToolTip(this.replaceLevelButtons.get(3), this.replaceLevelIndicators.get(3), "replaceWithEmpty");
        }
    }

    private void fillToolTip(IconButton button, Indicator indicator, String tooltipKey) {
        if (!button.isHovered()) {
            return;
        }
        boolean enabled = button.green;
        List<Component> tip = button.getToolTip();
        tip.add((Component)(enabled ? this.optionEnabled : this.optionDisabled).plainCopy().withStyle(enabled ? ChatFormatting.DARK_GREEN : ChatFormatting.RED));
        tip.addAll(TooltipHelper.cutTextComponent((Component)CreateLang.translateDirect("gui.schematicannon.option." + tooltipKey + ".description", new Object[0]), FontHelper.Palette.ALL_GRAY));
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.topPos + BG_TOP.getHeight() + BG_BOTTOM.getHeight() + 2;
        this.renderPlayerInventory(graphics, invX, invY);
        BG_TOP.render(graphics, this.leftPos, this.topPos);
        BG_BOTTOM.render(graphics, this.leftPos, this.topPos + BG_TOP.getHeight());
        AllGuiTextures.SCHEMATIC_TITLE.render(graphics, this.leftPos, this.topPos - 2);
        SchematicannonBlockEntity be = (SchematicannonBlockEntity)((SchematicannonMenu)this.menu).contentHolder;
        this.renderPrintingProgress(graphics, this.leftPos, this.topPos, be.schematicProgress);
        float amount = (float)be.remainingFuel / (float)be.getShotsPerGunpowder();
        this.renderFuelBar(graphics, this.leftPos, this.topPos, amount);
        this.renderChecklistPrinterProgress(graphics, this.leftPos, this.topPos, be.bookPrintingProgress);
        if (!be.inventory.getItem(0).isEmpty()) {
            this.renderBlueprintHighlight(graphics, this.leftPos, this.topPos);
        }
        graphics.drawString(this.font, this.title, this.leftPos + (BG_TOP.getWidth() - 8 - this.font.width((FormattedText)this.title)) / 2, this.topPos + 2, -11513776, false);
        MutableComponent msg = CreateLang.translateDirect("schematicannon.status." + be.statusMsg, new Object[0]);
        int stringWidth = this.font.width((FormattedText)msg);
        if (be.missingItem != null) {
            stringWidth += 16;
            graphics.renderItem(be.missingItem, this.leftPos + 128, this.topPos + 49);
        }
        graphics.drawString(this.font, (Component)msg, this.leftPos + 103 - stringWidth / 2, this.topPos + 53, -2232577, true);
        if ("schematicErrored".equals(be.statusMsg)) {
            graphics.drawString(this.font, (Component)CreateLang.translateDirect("schematicannon.status.schematicErroredCheckLogs", new Object[0]), this.leftPos + 103 - stringWidth / 2, this.topPos + 65, -2232577, true);
        }
    }

    protected void renderBlueprintHighlight(GuiGraphics graphics, int x, int y) {
        AllGuiTextures.SCHEMATICANNON_HIGHLIGHT.render(graphics, x + 10, y + 60);
    }

    protected void renderPrintingProgress(GuiGraphics graphics, int x, int y, float progress) {
        progress = Math.min(progress, 1.0f);
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_PROGRESS;
        graphics.blit(RenderPipelines.GUI_TEXTURED, sprite.location, x + 44, y + 64, (float)sprite.getStartX(), (float)sprite.getStartY(), (int)((float)sprite.getWidth() * progress), sprite.getHeight(), 256, 256);
    }

    protected void renderChecklistPrinterProgress(GuiGraphics graphics, int x, int y, float progress) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_CHECKLIST_PROGRESS;
        graphics.blit(RenderPipelines.GUI_TEXTURED, sprite.location, x + 154, y + 20, (float)sprite.getStartX(), (float)sprite.getStartY(), (int)((float)sprite.getWidth() * progress), sprite.getHeight(), 256, 256);
    }

    protected void renderFuelBar(GuiGraphics graphics, int x, int y, float amount) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_FUEL;
        if (((SchematicannonBlockEntity)((SchematicannonMenu)this.menu).contentHolder).hasCreativeCrate) {
            AllGuiTextures.SCHEMATICANNON_FUEL_CREATIVE.render(graphics, x + 36, y + 19);
            return;
        }
        graphics.blit(RenderPipelines.GUI_TEXTURED, sprite.location, x + 36, y + 19, (float)sprite.getStartX(), (float)sprite.getStartY(), (int)((float)sprite.getWidth() * amount), sprite.getHeight(), 256, 256);
    }

    @Override
    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        SchematicannonBlockEntity be = (SchematicannonBlockEntity)((SchematicannonMenu)this.menu).contentHolder;
        int fuelX = this.leftPos + 36;
        int fuelY = this.topPos + 19;
        if (mouseX >= fuelX && mouseY >= fuelY && mouseX <= fuelX + AllGuiTextures.SCHEMATICANNON_FUEL.getWidth() && mouseY <= fuelY + AllGuiTextures.SCHEMATICANNON_FUEL.getHeight()) {
            List<Component> tooltip = this.getFuelLevelTooltip(be);
            graphics.setComponentTooltipForNextFrame(this.font, tooltip, mouseX, mouseY);
        }
        if (this.hoveredSlot != null && !this.hoveredSlot.hasItem()) {
            String tooltipKey;
            switch (this.hoveredSlot.index) {
                case 0: {
                    String string = "gui.schematicannon.slot.schematic";
                    break;
                }
                case 2: {
                    String string = "gui.schematicannon.slot.listPrinter";
                    break;
                }
                case 4: {
                    String string = "gui.schematicannon.slot.gunpowder";
                    break;
                }
                default: {
                    String string = tooltipKey = null;
                }
            }
            if (tooltipKey != null) {
                graphics.setComponentTooltipForNextFrame(this.font, TooltipHelper.cutTextComponent((Component)CreateLang.translateDirect(tooltipKey, new Object[0]), FontHelper.Palette.GRAY_AND_BLUE), mouseX, mouseY);
            }
        }
        if (be.missingItem != null) {
            int missingBlockX = this.leftPos + 128;
            int missingBlockY = this.topPos + 49;
            if (mouseX >= missingBlockX && mouseY >= missingBlockY && mouseX <= missingBlockX + 16 && mouseY <= missingBlockY + 16) {
                graphics.setTooltipForNextFrame(this.font, be.missingItem, mouseX, mouseY);
            }
        }
        int paperX = this.leftPos + 112;
        int paperY = this.topPos + 19;
        if (mouseX >= paperX && mouseY >= paperY && mouseX <= paperX + 16 && mouseY <= paperY + 16) {
            graphics.setTooltipForNextFrame(this.font, this.listPrinter, mouseX, mouseY);
        }
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
    }

    protected List<Component> getFuelLevelTooltip(SchematicannonBlockEntity be) {
        int shotsLeft = be.remainingFuel;
        int shotsLeftWithItems = shotsLeft + be.inventory.getItem(4).getCount() * be.getShotsPerGunpowder();
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (be.hasCreativeCrate) {
            tooltip.add((Component)CreateLang.translateDirect("gui.schematicannon.gunpowderLevel", "100"));
            tooltip.add((Component)Component.literal((String)"(").append(AllItems.CREATIVE_CRATE.getName()).append(")").withStyle(ChatFormatting.DARK_PURPLE));
            return tooltip;
        }
        int fillPercent = (int)((float)be.remainingFuel / (float)be.getShotsPerGunpowder() * 100.0f);
        tooltip.add((Component)CreateLang.translateDirect("gui.schematicannon.gunpowderLevel", fillPercent));
        tooltip.add((Component)CreateLang.translateDirect("gui.schematicannon.shotsRemaining", Component.literal((String)Integer.toString(shotsLeft)).withStyle(ChatFormatting.BLUE)).withStyle(ChatFormatting.GRAY));
        if (shotsLeftWithItems != shotsLeft) {
            tooltip.add((Component)CreateLang.translateDirect("gui.schematicannon.shotsRemainingWithBackup", Component.literal((String)Integer.toString(shotsLeftWithItems)).withStyle(ChatFormatting.BLUE)).withStyle(ChatFormatting.GRAY));
        }
        return tooltip;
    }

    protected void sendOptionUpdate(ConfigureSchematicannonPacket.Option option, boolean set) {
        this.minecraft.player.connection.send((Packet)new ConfigureSchematicannonPacket(option, set));
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

