/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.schematics.client.SchematicHandler;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;

public class SchematicEditScreen
extends AbstractSimiScreen {
    private final List<Component> rotationOptions = CreateLang.translatedOptions("schematic.rotation", "none", "cw90", "cw180", "cw270");
    private final List<Component> mirrorOptions = CreateLang.translatedOptions("schematic.mirror", "none", "leftRight", "frontBack");
    private final Component rotationLabel = CreateLang.translateDirect("schematic.rotation", new Object[0]);
    private final Component mirrorLabel = CreateLang.translateDirect("schematic.mirror", new Object[0]);
    private AllGuiTextures background = AllGuiTextures.SCHEMATIC;
    private EditBox xInput;
    private EditBox yInput;
    private EditBox zInput;
    private IconButton confirmButton;
    private ElementWidget renderedItem;
    private ScrollInput rotationArea;
    private ScrollInput mirrorArea;
    private SchematicHandler handler = Create.SCHEMATIC_HANDLER;

    @Override
    protected void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        this.setWindowOffset(-6, 0);
        super.init();
        int x = this.guiLeft;
        int y = this.guiTop + 2;
        this.xInput = new EditBox(this.font, x + 50, y + 26, 34, 10, CommonComponents.EMPTY);
        this.yInput = new EditBox(this.font, x + 90, y + 26, 34, 10, CommonComponents.EMPTY);
        this.zInput = new EditBox(this.font, x + 130, y + 26, 34, 10, CommonComponents.EMPTY);
        BlockPos anchor = this.handler.getTransformation().getAnchor();
        if (this.handler.isDeployed()) {
            this.xInput.setValue("" + anchor.getX());
            this.yInput.setValue("" + anchor.getY());
            this.zInput.setValue("" + anchor.getZ());
        } else {
            EditBox[] alt = this.minecraft.player.blockPosition();
            this.xInput.setValue("" + alt.getX());
            this.yInput.setValue("" + alt.getY());
            this.zInput.setValue("" + alt.getZ());
        }
        for (EditBox widget : new EditBox[]{this.xInput, this.yInput, this.zInput}) {
            widget.setMaxLength(6);
            widget.setBordered(false);
            widget.setTextColor(-1);
            widget.setFocused(false);
            widget.mouseClicked(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(0, 0)), false);
            widget.setFilter(s -> {
                if (s.isEmpty() || s.equals("-")) {
                    return true;
                }
                try {
                    Integer.parseInt(s);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
        }
        StructurePlaceSettings settings = this.handler.getTransformation().toSettings();
        Label labelR = new Label(x + 50, y + 48, CommonComponents.EMPTY).withShadow();
        this.rotationArea = new SelectionScrollInput(x + 45, y + 43, 118, 18).forOptions(this.rotationOptions).titled(this.rotationLabel.plainCopy()).setState(settings.getRotation().ordinal()).writingTo(labelR);
        Label labelM = new Label(x + 50, y + 70, CommonComponents.EMPTY).withShadow();
        this.mirrorArea = new SelectionScrollInput(x + 45, y + 65, 118, 18).forOptions(this.mirrorOptions).titled(this.mirrorLabel.plainCopy()).setState(settings.getMirror().ordinal()).writingTo(labelM);
        this.addRenderableWidgets((GuiEventListener[])new EditBox[]{this.xInput, this.yInput, this.zInput});
        this.addRenderableWidgets(new AbstractSimiWidget[]{labelR, labelM, this.rotationArea, this.mirrorArea});
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 26, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::onClose);
        this.addRenderableWidget(this.confirmButton);
        this.renderedItem = new ElementWidget(x + this.background.getWidth() + 6, y + this.background.getHeight() - 40).showingElement(GuiGameElement.of(AllItems.SCHEMATIC.getDefaultInstance()).scale(3.0f));
        this.addRenderableWidget(this.renderedItem);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
    }

    @Override
    public boolean keyPressed(KeyEvent input) {
        String coords;
        if (input.isPaste() && (coords = this.minecraft.keyboardHandler.getClipboard()) != null && !coords.isEmpty()) {
            coords.replaceAll(" ", "");
            String[] split = coords.split(",");
            if (split.length == 3) {
                boolean valid = true;
                for (String s : split) {
                    try {
                        Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        valid = false;
                    }
                }
                if (valid) {
                    this.xInput.setValue(split[0]);
                    this.yInput.setValue(split[1]);
                    this.zInput.setValue(split[2]);
                    return true;
                }
            }
        }
        return super.keyPressed(input);
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        String title = this.handler.getCurrentSchematicName();
        graphics.drawString(this.font, title, x + (this.background.getWidth() - 8 - this.font.width(title)) / 2, y + 4, -11513776, false);
    }

    public void removed() {
        boolean validCoords = true;
        BlockPos newLocation = null;
        try {
            newLocation = new BlockPos(Integer.parseInt(this.xInput.getValue()), Integer.parseInt(this.yInput.getValue()), Integer.parseInt(this.zInput.getValue()));
        }
        catch (NumberFormatException e) {
            validCoords = false;
        }
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.setRotation(Rotation.values()[this.rotationArea.getState()]);
        settings.setMirror(Mirror.values()[this.mirrorArea.getState()]);
        if (validCoords && newLocation != null) {
            ItemStack item = this.handler.getActiveSchematicItem();
            if (item != null) {
                item.set(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)true);
                item.set(AllDataComponents.SCHEMATIC_ANCHOR, (Object)newLocation);
            }
            this.handler.getTransformation().init(newLocation, settings, this.handler.getBounds());
            this.handler.markDirty();
            this.handler.deploy(this.minecraft);
        }
    }
}

