/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.ShadedBlockSbbBuilder;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.content.schematics.client.SchematicTransformation;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.render.BlockEntityRenderHelper;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;

public class SchematicRenderer {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private final Map<ChunkSectionLayer, SuperByteBuffer> bufferCache = new LinkedHashMap<ChunkSectionLayer, SuperByteBuffer>(ChunkSectionLayer.values().length);
    private boolean changed;
    protected final SchematicLevel schematic;
    private final BlockPos anchor;
    private final List<BlockEntity> renderedBlockEntities = new ArrayList<BlockEntity>();
    private final BitSet shouldRenderBlockEntities = new BitSet();
    private final BitSet scratchErroredBlockEntities = new BitSet();

    public SchematicRenderer(SchematicLevel world) {
        this.anchor = world.anchor;
        this.schematic = world;
        this.changed = true;
        for (BlockEntity renderedBlockEntity : this.schematic.getRenderedBlockEntities()) {
            this.renderedBlockEntities.add(renderedBlockEntity);
        }
        this.shouldRenderBlockEntities.set(0, this.renderedBlockEntities.size());
    }

    public void update() {
        this.changed = true;
    }

    public void render(Minecraft mc, PoseStack ms, SuperRenderTypeBuffer buffers, SchematicTransformation transformation, Vec3 camera) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        if (this.changed) {
            this.redraw(mc);
        }
        this.changed = false;
        this.bufferCache.forEach((layer, buffer) -> buffer.renderInto(ms.last(), buffers.getBuffer((ChunkSectionLayer)layer)));
        this.scratchErroredBlockEntities.clear();
        BlockEntityRenderHelper.BlockEntityListRenderState renderState = BlockEntityRenderHelper.getBlockEntitiesRenderState(VisualizationManager.supportsVisualization(this.schematic), this.renderedBlockEntities, this.shouldRenderBlockEntities, this.scratchErroredBlockEntities, null, this.schematic, ms, null, transformation.toLocalSpace(camera), AnimationTickHolder.getPartialTicks());
        if (renderState != null) {
            FeatureRenderDispatcher renderDispatcher = Minecraft.getInstance().gameRenderer.getFeatureRenderDispatcher();
            renderState.render((SubmitNodeCollector)renderDispatcher.getSubmitNodeStorage(), mc.gameRenderer.getLevelRenderState().cameraRenderState);
        }
        this.shouldRenderBlockEntities.andNot(this.scratchErroredBlockEntities);
    }

    protected void redraw(Minecraft mc) {
        this.bufferCache.clear();
        for (ChunkSectionLayer layer : ChunkSectionLayer.values()) {
            SuperByteBuffer buffer = this.drawLayer(mc, layer);
            if (buffer.isEmpty()) continue;
            this.bufferCache.put(layer, buffer);
        }
    }

    protected SuperByteBuffer drawLayer(Minecraft mc, ChunkSectionLayer layer) {
        BlockRenderDispatcher dispatcher = mc.getBlockRenderer();
        ModelBlockRenderer renderer = dispatcher.getModelRenderer();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        PoseStack poseStack = objects.poseStack;
        RandomSource random = objects.random;
        BlockPos.MutableBlockPos mutableBlockPos = objects.mutableBlockPos;
        SchematicLevel renderWorld = this.schematic;
        BoundingBox bounds = renderWorld.getBounds();
        ShadedBlockSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.begin();
        renderWorld.renderMode = true;
        ModelBlockRenderer.enableCaching();
        for (BlockPos localPos : BlockPos.betweenClosed((int)bounds.minX(), (int)bounds.minY(), (int)bounds.minZ(), (int)bounds.maxX(), (int)bounds.maxY(), (int)bounds.maxZ())) {
            BlockPos.MutableBlockPos pos = mutableBlockPos.setWithOffset((Vec3i)localPos, (Vec3i)this.anchor);
            BlockState state = renderWorld.getBlockState((BlockPos)pos);
            if (state.getRenderShape() != RenderShape.MODEL || ItemBlockRenderTypes.getChunkRenderType((BlockState)state) != layer) continue;
            long seed = state.getSeed((BlockPos)pos);
            BlockStateModel model = dispatcher.getBlockModel(state);
            random.setSeed(seed);
            poseStack.pushPose();
            poseStack.translate((float)localPos.getX(), (float)localPos.getY(), (float)localPos.getZ());
            ObjectArrayList parts = new ObjectArrayList();
            BlockStateModel blockStateModel = WrapperBlockStateModel.unwrapCompat(model);
            if (blockStateModel instanceof WrapperBlockStateModel) {
                WrapperBlockStateModel wrapper = (WrapperBlockStateModel)blockStateModel;
                wrapper.addPartsWithInfo((BlockAndTintGetter)renderWorld, (BlockPos)pos, state, random, (List<BlockModelPart>)parts);
            } else {
                model.collectParts(random, (List)parts);
            }
            renderer.tesselateBlock((BlockAndTintGetter)renderWorld, (List)parts, state, (BlockPos)pos, poseStack, (VertexConsumer)sbbBuilder, true, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        ModelBlockRenderer.clearCache();
        renderWorld.renderMode = false;
        return sbbBuilder.end();
    }

    private static class ThreadLocalObjects {
        public final PoseStack poseStack = new PoseStack();
        public final RandomSource random = RandomSource.createNewThreadLocalInstance();
        public final BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        public final ShadedBlockSbbBuilder sbbBuilder = ShadedBlockSbbBuilder.create();

        private ThreadLocalObjects() {
        }
    }
}

