/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client;

import com.mojang.blaze3d.platform.Window;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.content.schematics.client.tools.ToolType;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import org.joml.Matrix3x2fStack;

public class ToolSelectionScreen
extends Screen {
    public final String scrollToCycle = CreateLang.translateDirect("gui.toolmenu.cycle", new Object[0]).getString();
    public final String holdToFocus = "gui.toolmenu.focusKey";
    protected List<ToolType> tools;
    protected Consumer<ToolType> callback;
    public boolean focused;
    private float yOffset;
    protected int selection;
    private boolean initialized;
    protected int w;
    protected int h;

    public ToolSelectionScreen(Minecraft mc, List<ToolType> tools, Consumer<ToolType> callback) {
        super(mc, mc.font, (Component)Component.literal((String)"Tool Selection"));
        this.tools = tools;
        this.callback = callback;
        this.focused = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.initialized = false;
        callback.accept(tools.get(this.selection));
        this.w = Math.max(tools.size() * 50 + 30, 220);
        this.h = 30;
    }

    public void setSelectedElement(ToolType tool) {
        if (!this.tools.contains((Object)tool)) {
            return;
        }
        this.selection = this.tools.indexOf((Object)tool);
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(GuiGraphics graphics, float partialTicks) {
        Matrix3x2fStack matrixStack = graphics.pose();
        Window mainWindow = this.minecraft.getWindow();
        int scaledWidth = mainWindow.getGuiScaledWidth();
        int scaledHeight = mainWindow.getGuiScaledHeight();
        if (!this.initialized) {
            this.init(scaledWidth, scaledHeight);
        }
        int x = (scaledWidth - this.w) / 2 + 15;
        int y = scaledHeight - this.h - 75;
        matrixStack.pushMatrix();
        matrixStack.translate(0.0f, -this.yOffset);
        AllGuiTextures gray = AllGuiTextures.HUD_BACKGROUND;
        graphics.blit(RenderPipelines.GUI_TEXTURED, gray.location, x - 15, y, (float)gray.getStartX(), (float)gray.getStartY(), this.w, this.h, gray.getWidth(), gray.getHeight(), this.focused ? -520093697 : -2130706433);
        float toolTipAlpha = this.yOffset / 10.0f;
        List<Component> toolTip = this.tools.get(this.selection).getDescription();
        int stringAlphaComponent = (int)(toolTipAlpha * 255.0f) << 24;
        if (toolTipAlpha > 0.25f) {
            graphics.blit(RenderPipelines.GUI_TEXTURED, gray.location, x - 15, y + 33, (float)gray.getStartX(), (float)gray.getStartY(), this.w, this.h + 22, gray.getWidth(), gray.getHeight(), 0xB2B2CC | stringAlphaComponent);
            if (toolTip.size() > 0) {
                graphics.drawString(this.font, toolTip.get(0), x - 10, y + 38, 0xEEEEEE | stringAlphaComponent, false);
            }
            if (toolTip.size() > 1) {
                graphics.drawString(this.font, toolTip.get(1), x - 10, y + 50, 0xCCDDFF | stringAlphaComponent, false);
            }
            if (toolTip.size() > 2) {
                graphics.drawString(this.font, toolTip.get(2), x - 10, y + 60, 0xCCDDFF | stringAlphaComponent, false);
            }
            if (toolTip.size() > 3) {
                graphics.drawString(this.font, toolTip.get(3), x - 10, y + 72, 0xCCCCDD | stringAlphaComponent, false);
            }
        }
        if (this.tools.size() > 1) {
            String keyName = AllKeys.TOOL_MENU.getTranslatedKeyMessage().getString().toUpperCase();
            if (!this.focused) {
                graphics.drawCenteredString(this.font, (Component)CreateLang.translateDirect("gui.toolmenu.focusKey", keyName), scaledWidth / 2, y - 10, -3351041);
            } else {
                graphics.drawCenteredString(this.font, this.scrollToCycle, scaledWidth / 2, y - 10, -3351041);
            }
        } else {
            x += 65;
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            float alpha;
            matrixStack.pushMatrix();
            float f = alpha = this.focused ? 1.0f : 0.2f;
            if (i == this.selection) {
                matrixStack.translate(0.0f, -10.0f);
                graphics.drawCenteredString(this.font, this.tools.get(i).getDisplayName().getString(), x + i * 50 + 24, y + 28, -3351041);
                alpha = 1.0f;
            }
            int color = (int)(alpha * 255.0f) << 24;
            this.tools.get(i).getIcon().render(graphics, x + i * 50 + 16, y + 12, color);
            this.tools.get(i).getIcon().render(graphics, x + i * 50 + 16, y + 11, 0xFFFFFF | color);
            matrixStack.popMatrix();
        }
        matrixStack.popMatrix();
    }

    public void update() {
        this.yOffset = this.focused ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public void renderPassive(GuiGraphics graphics, float partialTicks) {
        this.draw(graphics, partialTicks);
    }

    public void onClose() {
        this.callback.accept(this.tools.get(this.selection));
    }

    protected void init() {
        super.init();
        this.initialized = true;
    }
}

