/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.bogey;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.client.AllBogeyStyleRenders;
import com.zurrtum.create.client.content.trains.bogey.BogeyVisual;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.zurrtum.create.content.trains.bogey.BogeySize;
import com.zurrtum.create.content.trains.bogey.BogeyStyle;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class BogeyBlockEntityVisual
extends AbstractBlockEntityVisual<AbstractBogeyBlockEntity>
implements SimpleDynamicVisual {
    private final PoseStack poseStack = new PoseStack();
    @Nullable
    private final BogeySize bogeySize;
    private BogeyStyle lastStyle;
    @Nullable
    private BogeyVisual bogey;

    public BogeyBlockEntityVisual(VisualizationContext ctx, AbstractBogeyBlockEntity blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        this.lastStyle = blockEntity.getStyle();
        Block block = this.blockState.getBlock();
        if (!(block instanceof AbstractBogeyBlock)) {
            this.bogeySize = null;
            return;
        }
        AbstractBogeyBlock block2 = (AbstractBogeyBlock)block;
        this.bogeySize = block2.getSize();
        BlockPos visualPos = this.getVisualPosition();
        this.poseStack.translate((float)visualPos.getX(), (float)visualPos.getY(), (float)visualPos.getZ());
        this.poseStack.translate(0.5f, 0.5f, 0.5f);
        if (this.blockState.getValue(AbstractBogeyBlock.AXIS) == Direction.Axis.X) {
            this.poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        }
        this.poseStack.translate(0.0, -1.5078125, 0.0);
        this.bogey = AllBogeyStyleRenders.createVisual(this.lastStyle, this.bogeySize, this.visualizationContext, partialTick, false);
        this.updateBogey(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        if (this.bogeySize == null) {
            return;
        }
        BogeyStyle style = ((AbstractBogeyBlockEntity)this.blockEntity).getStyle();
        if (style != this.lastStyle) {
            if (this.bogey != null) {
                this.bogey.delete();
                this.bogey = null;
            }
            this.lastStyle = style;
            this.bogey = AllBogeyStyleRenders.createVisual(this.lastStyle, this.bogeySize, this.visualizationContext, context.partialTick(), false);
            this.updateLight(context.partialTick());
        }
        this.updateBogey(context.partialTick());
    }

    private void updateBogey(float partialTick) {
        if (this.bogey == null) {
            return;
        }
        CompoundTag bogeyData = ((AbstractBogeyBlockEntity)this.blockEntity).getBogeyData();
        float angle = ((AbstractBogeyBlockEntity)this.blockEntity).getVirtualAngle(partialTick);
        this.bogey.update(bogeyData, angle, this.poseStack);
    }

    @Override
    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        if (this.bogey != null) {
            this.bogey.collectCrumblingInstances(consumer);
        }
    }

    @Override
    public void updateLight(float partialTick) {
        if (this.bogey != null) {
            this.bogey.updateLight(this.computePackedLight());
        }
    }

    @Override
    protected void _delete() {
        if (this.bogey != null) {
            this.bogey.delete();
        }
    }
}

