/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.bogey;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.content.trains.bogey.BogeyBlockEntityRenderer;
import com.zurrtum.create.client.content.trains.bogey.BogeyRenderer;
import com.zurrtum.create.client.content.trains.bogey.LargeBogeyRenderState;
import com.zurrtum.create.client.content.trains.bogey.SmallBogeyRenderState;
import com.zurrtum.create.client.content.trains.bogey.StandardBogeyRenderState;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class StandardBogeyRenderer
implements BogeyRenderer {
    public static void updateRenderState(StandardBogeyRenderState data, float wheelAngle, int light) {
        data.layer = RenderTypes.cutoutMovingBlock();
        data.shaft = CachedBuffers.block((BlockState)AllBlocks.SHAFT.defaultBlockState().setValue((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.Z));
        data.angle = (float)Math.PI / 180 * wheelAngle;
        data.light = light;
        data.offset = -1.5078125;
    }

    @Override
    public BogeyBlockEntityRenderer.BogeyRenderState getRenderData(@Nullable CompoundTag bogeyData, float wheelAngle, float tickProgress, int light, boolean inContraption) {
        StandardBogeyRenderState data = new StandardBogeyRenderState();
        StandardBogeyRenderer.updateRenderState(data, wheelAngle, light);
        return data;
    }

    public static class Large
    extends StandardBogeyRenderer {
        public static final float BELT_RADIUS_PX = 5.0f;
        public static final float BELT_RADIUS_IN_UV_SPACE = 0.3125f;

        @Override
        public BogeyBlockEntityRenderer.BogeyRenderState getRenderData(@Nullable CompoundTag bogeyData, float wheelAngle, float tickProgress, int light, boolean inContraption) {
            LargeBogeyRenderState data = new LargeBogeyRenderState();
            Large.updateRenderState(data, wheelAngle, light);
            data.secondaryShaft = CachedBuffers.block((BlockState)AllBlocks.SHAFT.defaultBlockState().setValue((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.X));
            BlockState air = Blocks.AIR.defaultBlockState();
            data.drive = CachedBuffers.partial(AllPartialModels.BOGEY_DRIVE, air);
            data.belt = CachedBuffers.partial(AllPartialModels.BOGEY_DRIVE_BELT, air);
            float spriteSize = AllSpriteShifts.BOGEY_BELT.getTarget().getV1() - AllSpriteShifts.BOGEY_BELT.getTarget().getV0();
            float scroll = 0.0054541538f * wheelAngle;
            scroll -= (float)Mth.floor((float)scroll);
            data.scroll = scroll * spriteSize * 0.5f;
            data.piston = CachedBuffers.partial(AllPartialModels.BOGEY_PISTON, air);
            data.pistonOffset = (float)(0.25 * Math.sin(AngleHelper.rad(wheelAngle)));
            data.wheels = CachedBuffers.partial(AllPartialModels.LARGE_BOGEY_WHEELS, air);
            data.pin = CachedBuffers.partial(AllPartialModels.BOGEY_PIN, air);
            return data;
        }
    }

    public static class Small
    extends StandardBogeyRenderer {
        @Override
        public BogeyBlockEntityRenderer.BogeyRenderState getRenderData(@Nullable CompoundTag bogeyData, float wheelAngle, float tickProgress, int light, boolean inContraption) {
            SmallBogeyRenderState data = new SmallBogeyRenderState();
            Small.updateRenderState(data, wheelAngle, light);
            BlockState air = Blocks.AIR.defaultBlockState();
            data.frame = CachedBuffers.partial(AllPartialModels.BOGEY_FRAME, air);
            data.wheels = CachedBuffers.partial(AllPartialModels.SMALL_BOGEY_WHEELS, air);
            return data;
        }
    }
}

