/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.display;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.content.trains.display.FlapDisplayBlock;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayLayout;
import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GlyphSource;
import net.minecraft.client.gui.font.TextRenderable;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.minecraft.util.StringDecomposer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class FlapDisplayRenderer
extends KineticBlockEntityRenderer<FlapDisplayBlockEntity, FlapDisplayRenderState> {
    protected final Font textRenderer;

    public FlapDisplayRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.textRenderer = context.font();
    }

    @Override
    public FlapDisplayRenderState createRenderState() {
        return new FlapDisplayRenderState();
    }

    @Override
    public void extractRenderState(FlapDisplayBlockEntity be, FlapDisplayRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (!be.isController) {
            return;
        }
        if (state.support) {
            BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        }
        FlapDisplayData display = new FlapDisplayData();
        List<FlapDisplayLayout> lines = be.getLines();
        boolean paused = !be.isSpeedRequirementFulfilled();
        Level world = be.getLevel();
        int levelTicks = AnimationTickHolder.getTicks((LevelAccessor)world);
        int ticks = paused ? 0 : levelTicks;
        float time = paused ? 0.0f : AnimationTickHolder.getRenderTime((LevelAccessor)world);
        int size = lines.size();
        float y = 4.5f;
        int light = state.lightCoords;
        for (int j = 0; j < size; ++j) {
            List<FlapDisplaySection> line = lines.get(j).getSections();
            int color = FlapDisplayRenderer.getLineColor(be, j);
            float w = 0.0f;
            int count = line.size();
            float[] offsets = new float[count];
            for (int i = 0; i < count; ++i) {
                FlapDisplaySection section = line.get(i);
                offsets[i] = w;
                w += section.getSize() + (float)(section.hasGap ? 8 : 1);
            }
            float margin = (float)(be.xSize * 16) - w / 2.0f + 1.0f;
            boolean glowing = be.isLineGlowing(j);
            FlapDisplayRenderOutput renderOutput = new FlapDisplayRenderOutput(y, this.textRenderer, color, j, paused, ticks, time, glowing, drawable -> display.add(light, glowing, (TextRenderable)drawable));
            for (int i = 0; i < count; ++i) {
                FlapDisplaySection section = line.get(i);
                renderOutput.nextSection(section, margin + offsets[i]);
                String text = section.renderCharsIndividually() || !section.spinning[0] ? section.text : section.cyclingOptions[(levelTicks / 3 + i * 13) % section.cyclingOptions.length];
                StringDecomposer.iterateFormatted((String)text, (Style)Style.EMPTY, (FormattedCharSink)renderOutput);
            }
            y += 16.0f;
        }
        if (display.isEmpty()) {
            return;
        }
        display.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle((Direction)state.blockState.getValue((Property)FlapDisplayBlock.HORIZONTAL_FACING));
        state.display = display;
    }

    @Override
    public void submit(FlapDisplayRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.display != null) {
            state.display.render(matrices, queue);
        }
    }

    public static int getLineColor(FlapDisplayBlockEntity be, int line) {
        DyeColor color = be.colour[line];
        return color == null ? -2898246 : (Integer)DyeHelper.getDyeColors(color).getFirst() | 0xFF000000;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(FlapDisplayBlockEntity be, FlapDisplayRenderState state) {
        return CachedBuffers.partialFacingVertical(AllPartialModels.SHAFTLESS_COGWHEEL, state.blockState, (Direction)state.blockState.getValue((Property)FlapDisplayBlock.HORIZONTAL_FACING));
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public static class FlapDisplayRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public FlapDisplayData display;
    }

    public static class FlapDisplayData {
        public Map<RenderType, TextRenderState> map = new IdentityHashMap<RenderType, TextRenderState>();
        public float yRot;

        public void add(int light, boolean glowing, TextRenderable textDrawable) {
            this.map.computeIfAbsent(textDrawable.renderType(Font.DisplayMode.NORMAL), layer -> new TextRenderState(light)).add(glowing, textDrawable);
        }

        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            matrices.pushPose();
            matrices.translate(0.5f, 0.5f, 0.5f);
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.yRot));
            matrices.translate(-0.5f, 0.5f, 0.3125f);
            matrices.scale(0.03125f, -0.03125f, 0.03125f);
            matrices.translate(0.0f, 0.0f, 0.5f);
            this.map.forEach((layer, state) -> queue.submitCustomGeometry(matrices, layer, (SubmitNodeCollector.CustomGeometryRenderer)state));
            matrices.popPose();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }
    }

    public static class FlapDisplayRenderOutput
    implements FormattedCharSink {
        final Font textRenderer;
        final int color;
        final int r;
        final int g;
        final int b;
        final int a;
        final boolean paused;
        final int ticks;
        final float time;
        final int lineIndex;
        final float y;
        final Consumer<TextRenderable> consumer;
        FlapDisplaySection section;
        float x;

        public FlapDisplayRenderOutput(float y, Font textRenderer, int color, int lineIndex, boolean paused, int ticks, float time, boolean glowing, Consumer<TextRenderable> consumer) {
            this.y = y;
            this.textRenderer = textRenderer;
            this.lineIndex = lineIndex;
            this.paused = paused;
            this.ticks = ticks;
            this.time = time;
            this.a = glowing ? -134217728 : -671088640;
            this.r = color >> 16 & 0xFF;
            this.g = color >> 8 & 0xFF;
            this.b = color & 0xFF;
            this.color = color;
            this.consumer = consumer;
        }

        public void nextSection(FlapDisplaySection section, float offset) {
            this.section = section;
            this.x = offset;
        }

        public boolean accept(int charIndex, Style style, int glyph) {
            TextRenderable.Styled textDrawable;
            float standardWidth;
            TextColor textcolor = style.getColor();
            boolean canDim = textcolor == null;
            boolean dim = false;
            if (this.section.renderCharsIndividually() && this.section.spinning[Math.min(charIndex, this.section.spinning.length)]) {
                float speed = this.section.spinningTicks > 5 && this.section.spinningTicks < 20 ? 1.75f : 2.5f;
                float cycle = this.time / speed + (float)charIndex * 16.83f + (float)this.lineIndex * 0.75f;
                float partial = cycle % 1.0f;
                int cyclingGlyph = this.section.cyclingOptions[(int)cycle % this.section.cyclingOptions.length].charAt(0);
                glyph = this.paused ? cyclingGlyph : (partial > 0.5f ? (partial > 0.75f ? 95 : 45) : cyclingGlyph);
                if (canDim) {
                    dim = true;
                }
            }
            GlyphSource glyphProvider = this.textRenderer.getGlyphSource(style.getFont());
            BakedGlyph bakedglyph = glyphProvider.getGlyph(glyph);
            float glyphWidth = bakedglyph.info().getAdvance(false);
            boolean obfuscated = style.isObfuscated();
            if (!this.section.renderCharsIndividually() && this.section.spinning[0]) {
                if (!obfuscated) {
                    int oldGlyph = glyph;
                    int i = this.ticks % 3;
                    if (i == 0) {
                        if (glyphWidth == 6.0f) {
                            glyph = 45;
                        } else if (glyphWidth == 1.0f) {
                            glyph = 39;
                        }
                    } else if (i == 2) {
                        if (glyphWidth == 6.0f) {
                            glyph = 95;
                        } else if (glyphWidth == 1.0f) {
                            glyph = 46;
                        }
                    }
                    if (oldGlyph != glyph) {
                        bakedglyph = glyphProvider.getGlyph(glyph);
                    }
                }
                if (canDim && this.ticks % 3 != 1) {
                    dim = true;
                }
            }
            if (obfuscated && glyph != 32) {
                bakedglyph = glyphProvider.getRandomGlyph(this.textRenderer.random, Mth.ceil((float)glyphWidth));
            }
            int drawColor = this.a;
            drawColor = textcolor != null ? (drawColor |= textcolor.getValue()) : (dim ? (drawColor |= this.r * 192 >> 8 << 16 | this.g * 192 >> 8 << 8 | this.b * 192 >> 8) : (drawColor |= this.color));
            float f = standardWidth = this.section.wideFlaps ? 9.0f : 7.0f;
            if (this.section.renderCharsIndividually()) {
                this.x += (standardWidth - glyphWidth) / 2.0f;
            }
            if ((textDrawable = bakedglyph.createGlyph(this.x, this.y, drawColor, 0, style, 0.0f, 0.0f)) != null) {
                this.consumer.accept((TextRenderable)textDrawable);
            }
            this.x = this.section.renderCharsIndividually() ? (this.x += standardWidth - (standardWidth - glyphWidth) / 2.0f) : (this.x += glyphWidth);
            return true;
        }
    }

    public static class TextRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public List<TextRenderable> glowingText = new ArrayList<TextRenderable>();
        public List<TextRenderable> normalText = new ArrayList<TextRenderable>();
        public int light;

        public TextRenderState(int light) {
            this.light = light;
        }

        public void add(boolean glowing, TextRenderable textDrawable) {
            if (glowing) {
                this.glowingText.add(textDrawable);
            } else {
                this.normalText.add(textDrawable);
            }
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            Matrix4f pose = matricesEntry.pose();
            for (TextRenderable glyph : this.glowingText) {
                glyph.render(pose, vertexConsumer, 0xF000F0, true);
            }
            for (TextRenderable glyph : this.normalText) {
                glyph.render(pose, vertexConsumer, this.light, true);
            }
        }
    }
}

