/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.entity;

import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import java.util.BitSet;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class CarriageClientContraption
extends ClientContraption {
    public final BitSet scratchBlockEntitiesOutsidePortal = new BitSet();

    public CarriageClientContraption(CarriageContraption contraption) {
        super(contraption);
    }

    @Override
    public ClientContraption.RenderedBlocks getRenderedBlocks() {
        CarriageContraption contraption = (CarriageContraption)this.contraption;
        if (contraption.notInPortal()) {
            return super.getRenderedBlocks();
        }
        HashMap values = new HashMap();
        contraption.getBlocks().forEach((pos, info) -> {
            if (contraption.withinVisible((BlockPos)pos)) {
                values.put(pos, info.state());
            } else if (contraption.atSeam((BlockPos)pos)) {
                values.put(pos, Blocks.PURPLE_STAINED_GLASS.defaultBlockState());
            }
        });
        return new ClientContraption.RenderedBlocks(pos -> values.getOrDefault(pos, Blocks.AIR.defaultBlockState()), values.keySet());
    }

    @Override
    public BlockEntity readBlockEntity(Level level, StructureTemplate.StructureBlockInfo info, boolean legacy) {
        AbstractBogeyBlock bogey;
        Block block = info.state().getBlock();
        if (block instanceof AbstractBogeyBlock && !(bogey = (AbstractBogeyBlock)block).captureBlockEntityForTrain()) {
            return null;
        }
        return super.readBlockEntity(level, info, legacy);
    }

    @Override
    public BitSet getAndAdjustShouldRenderBlockEntities() {
        CarriageContraption contraption = (CarriageContraption)this.contraption;
        if (contraption.notInPortal()) {
            return super.getAndAdjustShouldRenderBlockEntities();
        }
        this.scratchBlockEntitiesOutsidePortal.clear();
        this.scratchBlockEntitiesOutsidePortal.or(this.shouldRenderBlockEntities);
        for (int i = 0; i < this.renderedBlockEntityView.size(); ++i) {
            BlockEntity be = (BlockEntity)this.renderedBlockEntityView.get(i);
            if (!contraption.isHiddenInPortal(be.getBlockPos())) continue;
            this.scratchBlockEntitiesOutsidePortal.clear(i);
        }
        return this.scratchBlockEntitiesOutsidePortal;
    }
}

