/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.AllBogeyStyleRenders;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.client.content.contraptions.render.OrientedContraptionEntityRenderer;
import com.zurrtum.create.client.content.trains.bogey.BogeyBlockEntityRenderer;
import com.zurrtum.create.client.content.trains.entity.CarriageClientContraption;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class CarriageContraptionEntityRenderer
extends OrientedContraptionEntityRenderer<CarriageContraptionEntity, CarriageContraptionState> {
    public CarriageContraptionEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public CarriageContraptionState createRenderState() {
        return new CarriageContraptionState();
    }

    @Override
    public boolean shouldRender(CarriageContraptionEntity entity, Frustum clippingHelper, double cameraX, double cameraY, double cameraZ) {
        Carriage carriage = entity.getCarriage();
        if (carriage != null) {
            for (CarriageBogey bogey : carriage.bogeys) {
                if (bogey == null) continue;
                bogey.couplingAnchors.replace(v -> null);
            }
        }
        if (!entity.validForRender || entity.firstPositionUpdate) {
            return false;
        }
        return super.shouldRender(entity, clippingHelper, cameraX, cameraY, cameraZ);
    }

    @Override
    public void extractRenderState(CarriageContraptionEntity entity, CarriageContraptionState state, float tickProgress) {
        BlockPos bogeyPos;
        super.extractRenderState(entity, state, tickProgress);
        Carriage carriage = entity.getCarriage();
        if (carriage == null) {
            return;
        }
        Level level = entity.level();
        Couple<CarriageBogey> bogeys = carriage.bogeys;
        CarriageBogey first = (CarriageBogey)bogeys.getFirst();
        CarriageBogey second = (CarriageBogey)bogeys.getSecond();
        Vec3 position = entity.getPosition(tickProgress);
        float viewYRot = entity.getViewYRot(tickProgress);
        float viewXRot = entity.getViewXRot(tickProgress);
        int bogeySpacing = carriage.bogeySpacing;
        float firstYaw = first.yaw.getValue(tickProgress);
        float firstPitch = first.pitch.getValue(tickProgress);
        float secondYaw = 0.0f;
        float secondPitch = 0.0f;
        first.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, firstYaw, firstPitch, true);
        if (second == null) {
            first.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, firstYaw, firstPitch, false);
        } else {
            secondYaw = second.yaw.getValue(tickProgress);
            secondPitch = second.pitch.getValue(tickProgress);
            second.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, secondYaw, secondPitch, false);
        }
        if (VisualizationManager.supportsVisualization((LevelAccessor)level)) {
            return;
        }
        int cameraLight = -1;
        if (!state.contraption.isHiddenInPortal(BlockPos.ZERO)) {
            Vec3 pos = first.getAnchorPosition();
            int light = pos != null ? CarriageContraptionEntityRenderer.getBogeyLightCoords(level, pos) : (cameraLight = CarriageContraptionEntityRenderer.getBogeyLightCoords(level, entity.getLightProbePosition(tickProgress)));
            state.firstBogey = CarriageBogeyRenderState.create(first, viewXRot, viewYRot, bogeySpacing, firstYaw, firstPitch, light, tickProgress);
        }
        if (second != null && !state.contraption.isHiddenInPortal(bogeyPos = BlockPos.ZERO.relative(entity.getInitialOrientation().getCounterClockWise(), bogeySpacing))) {
            Vec3 pos = second.getAnchorPosition();
            int light = pos != null ? CarriageContraptionEntityRenderer.getBogeyLightCoords(level, pos) : (cameraLight == -1 ? CarriageContraptionEntityRenderer.getBogeyLightCoords(level, entity.getLightProbePosition(tickProgress)) : cameraLight);
            state.secondBogey = CarriageBogeyRenderState.create(second, viewXRot, viewYRot, bogeySpacing, secondYaw, secondPitch, light, tickProgress);
        }
    }

    @Override
    protected ClientContraption createClientContraption(Contraption contraption) {
        return new CarriageClientContraption((CarriageContraption)contraption);
    }

    @Override
    public void submit(CarriageContraptionState state, PoseStack ms, SubmitNodeCollector queue, CameraRenderState cameraRenderState) {
        super.submit(state, ms, queue, cameraRenderState);
        if (state.firstBogey != null) {
            state.firstBogey.render(ms, queue);
        }
        if (state.secondBogey != null) {
            state.secondBogey.render(ms, queue);
        }
    }

    public static void translateBogey(PoseStack ms, CarriageBogey bogey, int bogeySpacing, float viewYRot, float viewXRot, float yaw, float pitch) {
        boolean selfUpsideDown = bogey.isUpsideDown();
        boolean leadingUpsideDown = bogey.carriage.leadingBogey().isUpsideDown();
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).rotateYDegrees(viewYRot + 90.0f)).rotateXDegrees(-viewXRot)).rotateYDegrees(180.0f)).translate(0.0f, 0.0f, bogey.isLeading ? 0.0f : (float)(-bogeySpacing)).rotateYDegrees(-180.0f)).rotateXDegrees(viewXRot)).rotateYDegrees(-viewYRot - 90.0f)).rotateYDegrees(yaw)).rotateXDegrees(pitch)).translate(0.0f, 0.5f, 0.0f).rotateZDegrees(selfUpsideDown ? 180.0f : 0.0f)).translateY(selfUpsideDown != leadingUpsideDown ? 2.0f : 0.0f);
    }

    public static int getBogeyLightCoords(Level world, Vec3 pos) {
        BlockPos lightPos = BlockPos.containing((Position)pos);
        return LightTexture.pack((int)world.getBrightness(LightLayer.BLOCK, lightPos), (int)world.getBrightness(LightLayer.SKY, lightPos));
    }

    public static class CarriageContraptionState
    extends OrientedContraptionEntityRenderer.OrientedContraptionState {
        public CarriageBogeyRenderState firstBogey;
        public CarriageBogeyRenderState secondBogey;
    }

    public static class CarriageBogeyRenderState {
        public BogeyBlockEntityRenderer.BogeyRenderState data;
        public float viewYRot;
        public float viewXRot;
        public float yRot;
        public int offsetZ;
        public float yaw;
        public float pitch;
        public float zRot;
        public int offsetY;

        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            matrices.pushPose();
            if (this.offsetZ != 0) {
                matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.viewYRot));
                matrices.mulPose((Quaternionfc)Axis.XP.rotation(-this.viewXRot));
                matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.yRot));
                matrices.translate(0.0f, 0.0f, (float)this.offsetZ);
                matrices.mulPose((Quaternionfc)Axis.YP.rotation(-this.yRot));
                matrices.mulPose((Quaternionfc)Axis.XP.rotation(this.viewXRot));
                matrices.mulPose((Quaternionfc)Axis.YP.rotation(-this.viewYRot));
            }
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.yaw));
            matrices.mulPose((Quaternionfc)Axis.XP.rotation(this.pitch));
            matrices.translate(0.0f, 0.5f, 0.0f);
            if (this.zRot != 0.0f) {
                matrices.mulPose((Quaternionfc)Axis.ZP.rotation(this.zRot));
            }
            matrices.translate(0.0f, (float)this.offsetY, 0.0f);
            this.data.render(matrices, queue);
            matrices.popPose();
        }

        @Nullable
        public static CarriageBogeyRenderState create(CarriageBogey bogey, float viewXRot, float viewYRot, int bogeySpacing, float yaw, float pitch, int light, float tickProgress) {
            boolean leadingUpsideDown;
            float wheelAngle = bogey.wheelAngle.getValue(tickProgress);
            BogeyBlockEntityRenderer.BogeyRenderState data = AllBogeyStyleRenders.getRenderData(bogey.getStyle(), bogey.getSize(), tickProgress, light, wheelAngle, bogey.bogeyData, true);
            if (data == null) {
                return null;
            }
            CarriageBogeyRenderState state = new CarriageBogeyRenderState();
            state.data = data;
            if (!bogey.isLeading) {
                state.viewYRot = (float)Math.PI / 180 * (viewYRot + 90.0f);
                state.viewXRot = (float)Math.PI / 180 * viewXRot;
                state.yRot = (float)Math.PI;
                state.offsetZ = -bogeySpacing;
            }
            state.yaw = (float)Math.PI / 180 * yaw;
            state.pitch = (float)Math.PI / 180 * pitch;
            boolean selfUpsideDown = bogey.isUpsideDown();
            if (selfUpsideDown) {
                state.zRot = (float)Math.PI;
            }
            if (selfUpsideDown != (leadingUpsideDown = bogey.carriage.leadingBogey().isUpsideDown())) {
                state.offsetY = 2;
            }
            return state;
        }
    }
}

