/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.entity;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TrainRelocator;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import com.zurrtum.create.infrastructure.packet.c2s.TrainRelocationPacket;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TrainRelocatorClient {
    static WeakReference<CarriageContraptionEntity> hoveredEntity = new WeakReference<Object>(null);
    static UUID relocatingTrain;
    static Vec3 relocatingOrigin;
    static int relocatingEntityId;
    static BlockPos lastHoveredPos;
    static BezierTrackPointLocation lastHoveredBezierSegment;
    static Boolean lastHoveredResult;
    static List<Vec3> toVisualise;

    public static boolean onClicked(Minecraft mc) {
        Boolean relocate;
        if (relocatingTrain == null) {
            return false;
        }
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        if (player.isSpectator()) {
            return false;
        }
        if (!player.position().closerThan((Position)relocatingOrigin, 24.0) || player.isShiftKeyDown()) {
            relocatingTrain = null;
            player.displayClientMessage((Component)CreateLang.translateDirect("train.relocate.abort", new Object[0]).withStyle(ChatFormatting.RED), true);
            return false;
        }
        if (player.isPassenger()) {
            return false;
        }
        if (mc.level == null) {
            return false;
        }
        Train relocating = TrainRelocatorClient.getRelocating();
        if (relocating != null && (relocate = TrainRelocatorClient.relocateClient(mc, relocating, false)) != null) {
            if (relocate.booleanValue()) {
                relocatingTrain = null;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static Boolean relocateClient(Minecraft mc, Train relocating, boolean simulate) {
        BlockState blockState;
        TrackBlockOutline.BezierPointSelection bezierSelection;
        Vec3 offset;
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult blockhit = (BlockHitResult)hitResult;
        BlockPos blockPos = blockhit.getBlockPos();
        BezierTrackPointLocation hoveredBezier = null;
        boolean upsideDown = relocating.carriages.getFirst().leadingBogey().isUpsideDown();
        Vec3 vec3 = offset = upsideDown ? new Vec3(0.0, -0.5, 0.0) : Vec3.ZERO;
        if (simulate && !toVisualise.isEmpty() && lastHoveredResult != null) {
            for (int i = 0; i < toVisualise.size() - 1; ++i) {
                Vec3 vec1 = toVisualise.get(i).add(offset);
                Vec3 vec2 = toVisualise.get(i + 1).add(offset);
                Outliner.getInstance().showLine(Pair.of(relocating, i), vec1.add(0.0, (double)-0.925f, 0.0), vec2.add(0.0, (double)-0.925f, 0.0)).colored(lastHoveredResult != false || i != toVisualise.size() - 2 ? 9817409 : 15359019).disableLineNormals().lineWidth(i % 2 == 1 ? 0.16666667f : 0.25f);
            }
        }
        if ((bezierSelection = TrackBlockOutline.result) != null) {
            blockPos = bezierSelection.blockEntity().getBlockPos();
            hoveredBezier = bezierSelection.loc();
        }
        if (simulate) {
            if (lastHoveredPos != null && lastHoveredPos.equals((Object)blockPos) && Objects.equals(lastHoveredBezierSegment, hoveredBezier)) {
                return lastHoveredResult;
            }
            lastHoveredPos = blockPos;
            lastHoveredBezierSegment = hoveredBezier;
            toVisualise.clear();
        }
        if (!((blockState = mc.level.getBlockState(blockPos)).getBlock() instanceof ITrackBlock)) {
            lastHoveredResult = null;
            return null;
        }
        Vec3 lookAngle = mc.player.getLookAngle();
        boolean direction = bezierSelection != null && lookAngle.dot(bezierSelection.direction()) < 0.0;
        boolean result = TrainRelocator.relocate(relocating, (Level)mc.level, blockPos, hoveredBezier, direction, lookAngle, toVisualise);
        if (!simulate && result) {
            relocating.carriages.forEach(c -> c.forEachPresentEntity(e -> {
                e.nonDamageTicks = 10;
            }));
            mc.player.connection.send((Packet)new TrainRelocationPacket(relocatingTrain, blockPos, lookAngle, relocatingEntityId, direction, hoveredBezier));
        }
        lastHoveredResult = result;
        return lastHoveredResult;
    }

    public static void clientTick(Minecraft mc) {
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (player.isPassenger()) {
            return;
        }
        ClientLevel world = mc.level;
        if (world == null) {
            return;
        }
        if (relocatingTrain != null) {
            AbstractContraptionEntity ce;
            Train relocating = TrainRelocatorClient.getRelocating();
            if (relocating == null) {
                relocatingTrain = null;
                return;
            }
            Entity entity = world.getEntity(relocatingEntityId);
            if (entity instanceof AbstractContraptionEntity && Math.abs((ce = (AbstractContraptionEntity)entity).getPosition(0.0f).subtract(ce.getPosition(1.0f)).lengthSqr()) > 9.765625E-4) {
                player.displayClientMessage((Component)CreateLang.translateDirect("train.cannot_relocate_moving", new Object[0]).withStyle(ChatFormatting.RED), true);
                relocatingTrain = null;
                return;
            }
            if (!player.getMainHandItem().is((Item)AllItems.WRENCH)) {
                player.displayClientMessage((Component)CreateLang.translateDirect("train.relocate.abort", new Object[0]).withStyle(ChatFormatting.RED), true);
                relocatingTrain = null;
                return;
            }
            if (!player.position().closerThan((Position)relocatingOrigin, 24.0)) {
                player.displayClientMessage((Component)CreateLang.translateDirect("train.relocate.too_far", new Object[0]).withStyle(ChatFormatting.RED), true);
                return;
            }
            Boolean success = TrainRelocatorClient.relocateClient(mc, relocating, true);
            if (success == null) {
                player.displayClientMessage((Component)CreateLang.translateDirect("train.relocate", relocating.name), true);
            } else if (success.booleanValue()) {
                player.displayClientMessage((Component)CreateLang.translateDirect("train.relocate.valid", new Object[0]).withStyle(ChatFormatting.GREEN), true);
            } else {
                player.displayClientMessage((Component)CreateLang.translateDirect("train.relocate.invalid", new Object[0]).withStyle(ChatFormatting.RED), true);
            }
            return;
        }
        Couple<Vec3> rayInputs = ContraptionHandlerClient.getRayInputs(mc, player);
        Vec3 origin = (Vec3)rayInputs.getFirst();
        Vec3 target = (Vec3)rayInputs.getSecond();
        CarriageContraptionEntity currentEntity = (CarriageContraptionEntity)((Object)hoveredEntity.get());
        if (currentEntity != null) {
            if (ContraptionHandlerClient.rayTraceContraption(origin, target, currentEntity) != null) {
                return;
            }
            hoveredEntity = new WeakReference<Object>(null);
        }
        AABB aabb = new AABB(origin, target);
        List intersectingContraptions = world.getEntitiesOfClass(CarriageContraptionEntity.class, aabb);
        for (CarriageContraptionEntity contraptionEntity : intersectingContraptions) {
            if (ContraptionHandlerClient.rayTraceContraption(origin, target, contraptionEntity) == null) continue;
            hoveredEntity = new WeakReference<CarriageContraptionEntity>(contraptionEntity);
        }
    }

    public static boolean carriageWrenched(Vec3 vec3, CarriageContraptionEntity entity) {
        Train train = TrainRelocatorClient.getTrainFromEntity(entity);
        if (train == null) {
            return false;
        }
        relocatingOrigin = vec3;
        relocatingTrain = train.id;
        relocatingEntityId = entity.getId();
        return true;
    }

    public static boolean addToTooltip(List<Component> tooltip) {
        Train train = TrainRelocatorClient.getTrainFromEntity((CarriageContraptionEntity)((Object)hoveredEntity.get()));
        if (train != null && train.derailed) {
            TooltipHelper.addHint(tooltip, "hint.derailed_train", new Object[0]);
            return true;
        }
        return false;
    }

    private static Train getRelocating() {
        return relocatingTrain == null ? null : Create.RAILWAYS.trains.get(relocatingTrain);
    }

    private static Train getTrainFromEntity(CarriageContraptionEntity carriageContraptionEntity) {
        if (carriageContraptionEntity == null) {
            return null;
        }
        Carriage carriage = carriageContraptionEntity.getCarriage();
        if (carriage == null) {
            return null;
        }
        return carriage.train;
    }

    static {
        toVisualise = new ArrayList<Vec3>();
    }
}

